/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.util.Assert;

public final class HttpMessageConverterAuthenticationSuccessHandler
implements AuthenticationSuccessHandler {
    private HttpMessageConverter<Object> converter = new MappingJackson2HttpMessageConverter();
    private RequestCache requestCache = new HttpSessionRequestCache();

    public void setConverter(HttpMessageConverter<Object> converter) {
        Assert.notNull(converter, (String)"converter cannot be null");
        this.converter = converter;
    }

    public void setRequestCache(RequestCache requestCache) {
        Assert.notNull((Object)requestCache, (String)"requestCache cannot be null");
        this.requestCache = requestCache;
    }

    @Override
    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        SavedRequest savedRequest = this.requestCache.getRequest(request, response);
        Object redirectUrl = savedRequest != null ? savedRequest.getRedirectUrl() : request.getContextPath() + "/";
        this.requestCache.removeRequest(request, response);
        this.converter.write((Object)new AuthenticationSuccess((String)redirectUrl), MediaType.APPLICATION_JSON, (HttpOutputMessage)new ServletServerHttpResponse(response));
    }

    public static final class AuthenticationSuccess {
        private final String redirectUrl;

        private AuthenticationSuccess(String redirectUrl) {
            this.redirectUrl = redirectUrl;
        }

        public String getRedirectUrl() {
            return this.redirectUrl;
        }

        public boolean isAuthenticated() {
            return true;
        }
    }
}

