/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.stat.internal;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.internal.util.collections.BoundedConcurrentHashMap;

public final class StatsNamedContainer<@UnknownKeyFor V> {
    private final @UnknownKeyFor @NonNull @Initialized ConcurrentMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> map;
    private static final @UnknownKeyFor @NonNull @Initialized Object NULL_TOKEN = new Object();

    public StatsNamedContainer(@UnknownKeyFor @NonNull @Initialized int capacity, @UnknownKeyFor @NonNull @Initialized int concurrencyLevel) {
        this.map = new BoundedConcurrentHashMap<String, Object>(capacity, concurrencyLevel, BoundedConcurrentHashMap.Eviction.LRU);
    }

    public StatsNamedContainer() {
        this.map = new ConcurrentHashMap<String, Object>();
    }

    public void clear() {
        this.map.clear();
    }

    public @UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] keysAsArray() {
        return this.map.keySet().toArray(new String[0]);
    }

    public @Nullable V getOrCompute(@UnknownKeyFor @NonNull @Initialized String key, @UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized String, V> function) {
        Object v1 = this.map.get(key);
        if (v1 != null) {
            if (v1 == NULL_TOKEN) {
                return null;
            }
            return v1;
        }
        V v2 = function.apply(key);
        if (v2 == null) {
            this.map.put(key, NULL_TOKEN);
            return null;
        }
        Object v3 = this.map.putIfAbsent(key, v2);
        if (v3 == null) {
            return v2;
        }
        return (V)v3;
    }

    public @Nullable V get(@UnknownKeyFor @NonNull @Initialized String key) {
        Object o = this.map.get(key);
        if (o == NULL_TOKEN) {
            return null;
        }
        return o;
    }
}

