/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.MethodHandles;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThreadDumpUtil {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    /*
     * Enabled aggressive exception aggregation
     */
    public static String threadDump(String msg) {
        try (StringWriter str = new StringWriter();){
            PrintWriter out = new PrintWriter(str);
            try {
                ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
                out.println("*******************************************************************************");
                out.println("Complete Thread dump " + msg);
                for (ThreadInfo threadInfo : threadMXBean.dumpAllThreads(true, true)) {
                    out.println(ThreadDumpUtil.threadInfoToString(threadInfo));
                }
                long[] deadlockedThreads = threadMXBean.findDeadlockedThreads();
                if (deadlockedThreads != null && deadlockedThreads.length > 0) {
                    out.println("Deadlock detected!");
                    out.println();
                    for (ThreadInfo threadInfo : threadMXBean.getThreadInfo(deadlockedThreads, true, true)) {
                        out.println(ThreadDumpUtil.threadInfoToString(threadInfo));
                    }
                }
                out.println("===============================================================================");
                out.println("End Thread dump " + msg);
                out.println("*******************************************************************************");
                String string = str.toString();
                out.close();
                return string;
            }
            catch (Throwable throwable) {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            logger.error("Exception thrown during generating of thread dump.", (Throwable)e);
            return "Generating of thread dump failed " + msg;
        }
    }

    private static String threadInfoToString(ThreadInfo threadInfo) {
        StringBuilder sb = new StringBuilder("\"" + threadInfo.getThreadName() + "\" Id=" + threadInfo.getThreadId() + " " + threadInfo.getThreadState());
        if (threadInfo.getLockName() != null) {
            sb.append(" on " + threadInfo.getLockName());
        }
        if (threadInfo.getLockOwnerName() != null) {
            sb.append(" owned by \"" + threadInfo.getLockOwnerName() + "\" Id=" + threadInfo.getLockOwnerId());
        }
        if (threadInfo.isSuspended()) {
            sb.append(" (suspended)");
        }
        if (threadInfo.isInNative()) {
            sb.append(" (in native)");
        }
        sb.append('\n');
        for (int i = 0; i < threadInfo.getStackTrace().length; ++i) {
            StackTraceElement ste = threadInfo.getStackTrace()[i];
            sb.append("\tat " + ste.toString());
            sb.append('\n');
            if (i == 0 && threadInfo.getLockInfo() != null) {
                Thread.State ts = threadInfo.getThreadState();
                switch (ts) {
                    case BLOCKED: {
                        sb.append("\t-  blocked on " + threadInfo.getLockInfo());
                        sb.append('\n');
                        break;
                    }
                    case WAITING: 
                    case TIMED_WAITING: {
                        sb.append("\t-  waiting on " + threadInfo.getLockInfo());
                        sb.append('\n');
                        break;
                    }
                }
            }
            for (LockInfo lockInfo : threadInfo.getLockedMonitors()) {
                if (((MonitorInfo)lockInfo).getLockedStackDepth() != i) continue;
                sb.append("\t-  locked " + (MonitorInfo)lockInfo);
                sb.append('\n');
            }
        }
        LockInfo[] locks = threadInfo.getLockedSynchronizers();
        if (locks.length > 0) {
            sb.append("\n\tNumber of locked synchronizers = " + locks.length);
            sb.append('\n');
            for (LockInfo lockInfo : locks) {
                sb.append("\t- " + lockInfo);
                sb.append('\n');
            }
        }
        sb.append('\n');
        return sb.toString();
    }
}

