/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.database;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.dbunit.database.DatabaseDataSet;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.database.IResultSetTable;
import org.dbunit.database.ResultSetTableMetaData;
import org.dbunit.dataset.AbstractTable;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.ITableMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResultSetTable
extends AbstractTable
implements IResultSetTable {
    private static final Logger logger = LoggerFactory.getLogger(AbstractResultSetTable.class);
    protected ITableMetaData _metaData;
    private Statement _statement;
    protected ResultSet _resultSet;

    public AbstractResultSetTable(ITableMetaData metaData, ResultSet resultSet) throws SQLException, DataSetException {
        this._metaData = metaData;
        this._resultSet = resultSet;
    }

    public AbstractResultSetTable(String tableName, String selectStatement, IDatabaseConnection connection) throws DataSetException, SQLException {
        this(tableName, selectStatement, connection, false);
    }

    public AbstractResultSetTable(String tableName, String selectStatement, IDatabaseConnection connection, boolean caseSensitiveTableNames) throws DataSetException, SQLException {
        this._statement = this.createStatement(connection);
        try {
            this._resultSet = this._statement.executeQuery(selectStatement);
            this._metaData = new ResultSetTableMetaData(tableName, this._resultSet, connection, caseSensitiveTableNames);
        }
        catch (SQLException e) {
            this._statement.close();
            this._statement = null;
            throw e;
        }
    }

    public AbstractResultSetTable(ITableMetaData metaData, IDatabaseConnection connection) throws DataSetException, SQLException {
        this._statement = this.createStatement(connection);
        String escapePattern = (String)connection.getConfig().getProperty("http://www.dbunit.org/properties/escapePattern");
        try {
            String schema = connection.getSchema();
            String selectStatement = AbstractResultSetTable.getSelectStatement(schema, metaData, escapePattern);
            if (logger.isDebugEnabled()) {
                logger.debug("Query: {}", (Object)selectStatement);
            }
            this._resultSet = this._statement.executeQuery(selectStatement);
            this._metaData = metaData;
        }
        catch (SQLException e) {
            this._statement.close();
            this._statement = null;
            throw e;
        }
    }

    private Statement createStatement(IDatabaseConnection connection) throws SQLException {
        logger.trace("createStatement() - start");
        Connection jdbcConnection = connection.getConnection();
        Statement stmt = jdbcConnection.createStatement();
        connection.getConfig().getConfigurator().configureStatement(stmt);
        return stmt;
    }

    static String getSelectStatement(String schema, ITableMetaData metaData, String escapePattern) throws DataSetException {
        return DatabaseDataSet.getSelectStatement(schema, metaData, escapePattern);
    }

    @Override
    public ITableMetaData getTableMetaData() {
        return this._metaData;
    }

    @Override
    public void close() throws DataSetException {
        logger.trace("close() - start");
        try {
            if (this._resultSet != null) {
                this._resultSet.close();
                this._resultSet = null;
            }
            if (this._statement != null) {
                this._statement.close();
                this._statement = null;
            }
        }
        catch (SQLException e) {
            throw new DataSetException(e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(2000);
        sb.append(this.getClass().getName()).append("[");
        sb.append("_metaData=[").append(this._metaData).append("], ");
        sb.append("_resultSet=[").append(this._resultSet).append("], ");
        sb.append("_statement=[").append(this._statement).append("]");
        sb.append("]");
        return sb.toString();
    }
}

