/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.deploy.permissions.service.impl;

import ai.digital.deploy.permissions.jpa.ReadOnlyTransactionalPermissionService;
import ai.digital.deploy.permissions.jpa.TransactionalPermissionService;
import ai.digital.deploy.permissions.model.Role;
import ai.digital.deploy.permissions.model.Role$;
import ai.digital.deploy.permissions.repository.GlobalPermissionRepository;
import ai.digital.deploy.permissions.repository.ReferencedPermissionRepository;
import ai.digital.deploy.permissions.repository.RolePrincipalRepository;
import ai.digital.deploy.permissions.repository.RoleRepository;
import ai.digital.deploy.permissions.service.RoleNameAlreadyExistsServiceException;
import ai.digital.deploy.permissions.service.RoleNameNotFoundServiceException;
import ai.digital.deploy.permissions.service.RoleService;
import ai.digital.deploy.permissions.service.impl.package$;
import java.io.Serializable;
import java.util.UUID;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@Service
@TransactionalPermissionService
@ScalaSignature(bytes="\u0006\u0005\u00055g\u0001B\f\u0019\u0001\u0015B\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\to\u0001\u0011\t\u0011)A\u0005q!A1\b\u0001B\u0001B\u0003%A\b\u0003\u0005@\u0001\t\u0005\t\u0015!\u0003A\u0011\u0015\u0019\u0005\u0001\"\u0001E\u0011\u0015Y\u0005\u0001\"\u0011M\u0011\u0015a\u0007\u0001\"\u0011n\u0011\u0015\u0001\b\u0001\"\u0011r\u0011\u0015\u0001\b\u0001\"\u0011{\u0011\u001d\tY\u0001\u0001C!\u0003\u001bAq!a\u0005\u0001\t\u0003\n)\u0002C\u0004\u0002\u001a\u0001!\t%a\u0007\t\u000f\u0005u\u0001\u0001\"\u0011\u0002 !9\u00111\u0005\u0001\u0005B\u0005\u0015\u0002bBA\u0012\u0001\u0011\u0005\u0013Q\b\u0005\b\u0003G\u0001A\u0011IA(\u0011\u001d\t\u0019\u0003\u0001C!\u0003oBq!a\t\u0001\t\u0003\ni\bC\u0004\u0002\b\u0002!\t%!#\t\u000f\u0005=\u0005\u0001\"\u0011\u0002\u0012\"9\u0011Q\u0013\u0001\u0005B\u0005]\u0005bBAT\u0001\u0011\u0005\u0013\u0011\u0016\u0002\u0010%>dWmU3sm&\u001cW-S7qY*\u0011\u0011DG\u0001\u0005S6\u0004HN\u0003\u0002\u001c9\u000591/\u001a:wS\u000e,'BA\u000f\u001f\u0003-\u0001XM]7jgNLwN\\:\u000b\u0005}\u0001\u0013A\u00023fa2|\u0017P\u0003\u0002\"E\u00059A-[4ji\u0006d'\"A\u0012\u0002\u0005\u0005L7\u0001A\n\u0004\u0001\u0019b\u0003CA\u0014+\u001b\u0005A#\"A\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005-B#AB!osJ+g\r\u0005\u0002.]5\t!$\u0003\u000205\tY!k\u001c7f'\u0016\u0014h/[2f\u00039\u0011x\u000e\\3SKB|7/\u001b;pef\u0004\"AM\u001b\u000e\u0003MR!\u0001\u000e\u000f\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u00027g\tq!k\u001c7f%\u0016\u0004xn]5u_JL\u0018a\u0006:pY\u0016\u0004&/\u001b8dSB\fGNU3q_NLGo\u001c:z!\t\u0011\u0014(\u0003\u0002;g\t9\"k\u001c7f!JLgnY5qC2\u0014V\r]8tSR|'/_\u0001\u001bO2|'-\u00197QKJl\u0017n]:j_:\u0014V\r]8tSR|'/\u001f\t\u0003euJ!AP\u001a\u00035\u001dcwNY1m!\u0016\u0014X.[:tS>t'+\u001a9pg&$xN]=\u0002=I,g-\u001a:f]\u000e,G\rU3s[&\u001c8/[8o%\u0016\u0004xn]5u_JL\bC\u0001\u001aB\u0013\t\u00115G\u0001\u0010SK\u001a,'/\u001a8dK\u0012\u0004VM]7jgNLwN\u001c*fa>\u001c\u0018\u000e^8ss\u00061A(\u001b8jiz\"R!R$I\u0013*\u0003\"A\u0012\u0001\u000e\u0003aAQ\u0001M\u0003A\u0002EBQaN\u0003A\u0002aBQaO\u0003A\u0002qBQaP\u0003A\u0002\u0001\u000baa\u0019:fCR,GCA'c!\u0011qe+\u0017/\u000f\u0005=#fB\u0001)T\u001b\u0005\t&B\u0001*%\u0003\u0019a$o\\8u}%\t\u0011&\u0003\u0002VQ\u00059\u0001/Y2lC\u001e,\u0017BA,Y\u0005\u0019)\u0015\u000e\u001e5fe*\u0011Q\u000b\u000b\t\u0003[iK!a\u0017\u000e\u0003KI{G.\u001a(b[\u0016\fEN]3bIf,\u00050[:ugN+'O^5dK\u0016C8-\u001a9uS>t\u0007CA/a\u001b\u0005q&BA0\u001d\u0003\u0015iw\u000eZ3m\u0013\t\tgL\u0001\u0003S_2,\u0007\"B2\u0007\u0001\u0004!\u0017\u0001\u00028b[\u0016\u0004\"!Z5\u000f\u0005\u0019<\u0007C\u0001))\u0013\tA\u0007&\u0001\u0004Qe\u0016$WMZ\u0005\u0003U.\u0014aa\u0015;sS:<'B\u00015)\u00039\u0019'/Z1uK>\u0013X\u000b\u001d3bi\u0016$\"!\u00148\t\u000b=<\u0001\u0019\u0001/\u0002\tI|G.Z\u0001\u0007I\u0016dW\r^3\u0015\u0005IL\b\u0003\u0002(WgZ\u0004\"!\f;\n\u0005UT\"\u0001\t*pY\u0016t\u0015-\\3O_R4u.\u001e8e'\u0016\u0014h/[2f\u000bb\u001cW\r\u001d;j_:\u0004\"aJ<\n\u0005aD#\u0001B+oSRDQa\u0019\u0005A\u0002\u0011$\"A^>\t\u000bqL\u0001\u0019A?\u0002\u0005%$\u0007c\u0001@\u0002\b5\tqP\u0003\u0003\u0002\u0002\u0005\r\u0011\u0001B;uS2T!!!\u0002\u0002\t)\fg/Y\u0005\u0004\u0003\u0013y(\u0001B+V\u0013\u0012\u000bq\u0003Z3mKR,\u0017\t\u001c7S_2,'+\u001a4fe\u0016t7-Z:\u0015\u0007I\fy\u0001\u0003\u0004\u0002\u0012)\u0001\r\u0001Z\u0001\te>dWMT1nK\u00061!/Z7pm\u0016$2A^A\f\u0011\u0015y7\u00021\u0001]\u0003%\u0011X-\\8wK\u0006cG\u000eF\u0001w\u0003\u0019)\b\u000fZ1uKR\u0019A,!\t\t\u000b=l\u0001\u0019\u0001/\u0002\tI,\u0017\r\u001a\u000b\u0005\u0003O\ti\u0003\u0005\u0003(\u0003Sa\u0016bAA\u0016Q\t1q\n\u001d;j_:DQa\u0019\bA\u0002\u0011D3ADA\u0019!\u0011\t\u0019$!\u000f\u000e\u0005\u0005U\"bAA\u001c9\u0005\u0019!\u000e]1\n\t\u0005m\u0012Q\u0007\u0002'%\u0016\fGm\u00148msR\u0013\u0018M\\:bGRLwN\\1m!\u0016\u0014X.[:tS>t7+\u001a:wS\u000e,G\u0003BA \u0003\u000f\u0002RA\u0014,t\u0003\u0003\u0002BATA\"9&\u0019\u0011Q\t-\u0003\t1K7\u000f\u001e\u0005\b\u0003\u0013z\u0001\u0019AA&\u0003\u0015q\u0017-\\3t!\u0011q\u00151\t3)\u0007=\t\t\u0004\u0006\u0004\u0002R\u0005%\u00141\u000e\t\u0006\u0003'\n)\u0007X\u0007\u0003\u0003+RA!a\u0016\u0002Z\u00051Am\\7bS:TA!a\u0017\u0002^\u0005!A-\u0019;b\u0015\u0011\ty&!\u0019\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T!!a\u0019\u0002\u0007=\u0014x-\u0003\u0003\u0002h\u0005U#\u0001\u0002)bO\u0016Dq!!\u0013\u0011\u0001\u0004\tY\u0005C\u0004\u0002nA\u0001\r!a\u001c\u0002\u0011A\fw-Z1cY\u0016\u0004B!a\u0015\u0002r%!\u00111OA+\u0005!\u0001\u0016mZ3bE2,\u0007f\u0001\t\u00022Q!\u0011qEA=\u0011\u0015a\u0018\u00031\u0001~Q\r\t\u0012\u0011\u0007\u000b\u0007\u0003#\ny(a!\t\r\u0005\u0005%\u00031\u0001e\u0003-q\u0017-\\3QCR$XM\u001d8\t\u000f\u00055$\u00031\u0001\u0002p!\u001a!#!\r\u0002#I,\u0017\r\u001a\"z%>dW\rU1ui\u0016\u0014h\u000e\u0006\u0003\u0002B\u0005-\u0005BBAA'\u0001\u0007A\rK\u0002\u0014\u0003c\tqA]3bI\u0006cG\u000e\u0006\u0002\u0002B!\u001aA#!\r\u0002\rI,g.Y7f)\u0019\tI*!)\u0002$B)aJVAN9B\u0019a*!(\n\u0007\u0005}\u0005LA\u0005UQJ|w/\u00192mK\")1-\u0006a\u0001I\"1\u0011QU\u000bA\u0002\u0011\fqA\\3x\u001d\u0006lW-A\u0003d_VtG\u000f\u0006\u0003\u0002,\u0006E\u0006cA\u0014\u0002.&\u0019\u0011q\u0016\u0015\u0003\t1{gn\u001a\u0005\u0007\u0003g3\u0002\u0019\u00013\u0002\u001fI|G.\u001a(b[\u0016\u0004\u0016\r\u001e;fe:D3AFA\u0019Q\r\u0001\u0011\u0011\u0018\t\u0005\u0003w\u000b\t-\u0004\u0002\u0002>*!\u0011qXA/\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0003\u0007\fiLA\u0004TKJ4\u0018nY3)\u0007\u0001\t9\r\u0005\u0003\u00024\u0005%\u0017\u0002BAf\u0003k\u0011a\u0004\u0016:b]N\f7\r^5p]\u0006d\u0007+\u001a:nSN\u001c\u0018n\u001c8TKJ4\u0018nY3")
public class RoleServiceImpl
implements RoleService {
    private final RoleRepository roleRepository;
    private final RolePrincipalRepository rolePrincipalRepository;
    private final GlobalPermissionRepository globalPermissionRepository;
    private final ReferencedPermissionRepository referencedPermissionRepository;

    @Override
    public Either<RoleNameAlreadyExistsServiceException, Role> create(String name) {
        if (this.roleRepository.get(name).isDefined()) {
            return new Left((Object)new RoleNameAlreadyExistsServiceException(name));
        }
        return new Right((Object)this.roleRepository.add(Role$.MODULE$.apply(name)));
    }

    @Override
    public Either<RoleNameAlreadyExistsServiceException, Role> createOrUpdate(Role role) {
        if (this.roleRepository.get(role.id()).isEmpty()) {
            if (this.roleRepository.get(role.name()).isDefined()) {
                return new Left((Object)new RoleNameAlreadyExistsServiceException(role.name()));
            }
            return new Right((Object)this.roleRepository.add(role));
        }
        return new Right((Object)this.roleRepository.update(role));
    }

    @Override
    public Either<RoleNameNotFoundServiceException, BoxedUnit> delete(String name) {
        return (Either)this.read(name).map((Function1 & Serializable)role -> {
            $this.roleRepository.remove((Role)role);
            return new Right((Object)BoxedUnit.UNIT);
        }).getOrElse((Function0 & Serializable)() -> new Left((Object)new RoleNameNotFoundServiceException(name)));
    }

    @Override
    public void delete(UUID id) {
        this.roleRepository.removeById(id);
    }

    @Override
    public Either<RoleNameNotFoundServiceException, BoxedUnit> deleteAllRoleReferences(String roleName) {
        return (Either)this.read(roleName).map((Function1 & Serializable)role -> {
            $this.rolePrincipalRepository.removeForRole((Role)role);
            $this.globalPermissionRepository.removeForRole((Role)role);
            $this.referencedPermissionRepository.removeForRole((Role)role);
            this.remove((Role)role);
            return new Right((Object)BoxedUnit.UNIT);
        }).getOrElse((Function0 & Serializable)() -> new Left((Object)new RoleNameNotFoundServiceException(roleName)));
    }

    @Override
    public void remove(Role role) {
        this.roleRepository.remove(role);
    }

    @Override
    public void removeAll() {
        this.rolePrincipalRepository.removeAll();
        this.roleRepository.removeAll();
    }

    @Override
    public Role update(Role role) {
        return this.roleRepository.add(role);
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public Option<Role> read(String name) {
        return this.roleRepository.get(name);
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public Either<RoleNameNotFoundServiceException, List<Role>> read(List<String> names) {
        List<Role> roles = this.roleRepository.get(names);
        if (roles.size() != names.size()) {
            return new Left((Object)new RoleNameNotFoundServiceException(((IterableOnceOps)names.diff((Seq)roles.map((Function1 & Serializable)x$1 -> x$1.name()))).mkString("[", ", ", "]")));
        }
        return new Right(roles);
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public Page<Role> read(List<String> names, Pageable pageable) {
        return this.roleRepository.get(names, pageable);
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public Option<Role> read(UUID id) {
        return this.roleRepository.get(id).map((Function1 & Serializable)r -> {
            r.setPrincipals($this.rolePrincipalRepository.get((Role)r));
            return r;
        });
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public Page<Role> read(String namePattern, Pageable pageable) {
        return (Page)package$.MODULE$.wrapNullablePatternSearch(namePattern, (Function1 & Serializable)p -> $this.roleRepository.listByNamePattern((String)p, pageable), (Function0 & Serializable)() -> $this.roleRepository.list(pageable));
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public List<Role> readByRolePattern(String namePattern) {
        return (List)package$.MODULE$.wrapNullablePatternSearch(namePattern, (Function1 & Serializable)p -> $this.roleRepository.listByNamePattern((String)p), (Function0 & Serializable)() -> $this.roleRepository.getAll());
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public List<Role> readAll() {
        return this.roleRepository.getAll();
    }

    @Override
    public Either<Throwable, Role> rename(String name, String newName) {
        return (Either)this.read(name).map((Function1 & Serializable)role -> {
            if (this.read(newName).isDefined()) {
                return new Left((Object)new RoleNameAlreadyExistsServiceException(newName));
            }
            return new Right((Object)$this.roleRepository.update(Role$.MODULE$.apply(role.id(), newName)));
        }).getOrElse((Function0 & Serializable)() -> new Left((Object)new RoleNameNotFoundServiceException(name)));
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public long count(String roleNamePattern) {
        return BoxesRunTime.unboxToLong(package$.MODULE$.wrapNullablePatternSearch(roleNamePattern, (Function1 & Serializable)p -> BoxesRunTime.boxToLong((long)this.roleRepository.countRolesByRoleNamePattern(p)), (JFunction0.mcJ.sp & Serializable)() -> $this.roleRepository.countAllRoles()));
    }

    public RoleServiceImpl(RoleRepository roleRepository, RolePrincipalRepository rolePrincipalRepository, GlobalPermissionRepository globalPermissionRepository, ReferencedPermissionRepository referencedPermissionRepository) {
        this.roleRepository = roleRepository;
        this.rolePrincipalRepository = rolePrincipalRepository;
        this.globalPermissionRepository = globalPermissionRepository;
        this.referencedPermissionRepository = referencedPermissionRepository;
    }
}

