/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.management;

import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.JMXAuthenticator;
import org.apache.activemq.artemis.core.config.JMXConnectorConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.management.BasicAuthenticator;
import org.apache.activemq.artemis.core.server.management.ConnectorServerFactory;
import org.apache.activemq.artemis.core.server.management.JaasAuthenticator;
import org.apache.activemq.artemis.core.server.management.MBeanServerFactory;
import org.apache.activemq.artemis.core.server.management.RmiRegistryFactory;
import org.apache.activemq.artemis.spi.core.security.ActiveMQBasicSecurityManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagementConnector
implements ActiveMQComponent {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final JMXConnectorConfiguration configuration;
    private ConnectorServerFactory connectorServerFactory;
    private RmiRegistryFactory rmiRegistryFactory;
    private MBeanServerFactory mbeanServerFactory;
    private ActiveMQSecurityManager securityManager;

    public ManagementConnector(JMXConnectorConfiguration configuration, ActiveMQSecurityManager securityManager) {
        this.configuration = configuration;
        this.securityManager = securityManager;
    }

    public boolean isStarted() {
        return this.rmiRegistryFactory != null;
    }

    public void start() throws Exception {
        JMXAuthenticator authenticator;
        this.rmiRegistryFactory = new RmiRegistryFactory();
        this.rmiRegistryFactory.setPort(this.configuration.getConnectorPort());
        this.rmiRegistryFactory.setHost(this.configuration.getConnectorHost());
        this.rmiRegistryFactory.init();
        this.mbeanServerFactory = new MBeanServerFactory();
        this.mbeanServerFactory.setLocateExistingServerIfPossible(true);
        this.mbeanServerFactory.init();
        MBeanServer mbeanServer = this.mbeanServerFactory.getServer();
        if (this.securityManager != null && this.securityManager instanceof ActiveMQBasicSecurityManager) {
            authenticator = new BasicAuthenticator((ActiveMQBasicSecurityManager)this.securityManager);
        } else {
            JaasAuthenticator jaasAuthenticator = new JaasAuthenticator();
            jaasAuthenticator.setRealm(this.configuration.getJmxRealm());
            authenticator = jaasAuthenticator;
        }
        this.connectorServerFactory = new ConnectorServerFactory();
        this.connectorServerFactory.setServer(mbeanServer);
        this.connectorServerFactory.setServiceUrl(this.configuration.getServiceUrl());
        this.connectorServerFactory.setRmiServerHost(this.configuration.getConnectorHost());
        this.connectorServerFactory.setObjectName(new ObjectName(this.configuration.getObjectName()));
        HashMap<String, BasicAuthenticator> environment = new HashMap<String, BasicAuthenticator>();
        environment.put("jmx.remote.authenticator", (BasicAuthenticator)authenticator);
        try {
            this.connectorServerFactory.setEnvironment(environment);
            this.connectorServerFactory.setAuthenticatorType(this.configuration.getAuthenticatorType());
            this.connectorServerFactory.setSecured(this.configuration.isSecured());
            this.connectorServerFactory.setKeyStorePath(this.configuration.getKeyStorePath());
            this.connectorServerFactory.setkeyStoreProvider(this.configuration.getKeyStoreProvider());
            this.connectorServerFactory.setkeyStoreType(this.configuration.getKeyStoreType());
            this.connectorServerFactory.setKeyStorePassword(this.configuration.getKeyStorePassword());
            this.connectorServerFactory.setTrustStorePath(this.configuration.getTrustStorePath());
            this.connectorServerFactory.setTrustStoreProvider(this.configuration.getTrustStoreProvider());
            this.connectorServerFactory.setTrustStoreType(this.configuration.getTrustStoreType());
            this.connectorServerFactory.setTrustStorePassword(this.configuration.getTrustStorePassword());
            this.connectorServerFactory.init();
        }
        catch (Exception e) {
            logger.error("Can't init JMXConnectorServer:", (Throwable)e);
        }
    }

    public void stop() {
        if (this.connectorServerFactory != null) {
            try {
                this.connectorServerFactory.destroy();
            }
            catch (Exception e) {
                logger.warn("Error destroying ConnectorServerFactory", (Throwable)e);
            }
            this.connectorServerFactory = null;
        }
        if (this.mbeanServerFactory != null) {
            try {
                this.mbeanServerFactory.destroy();
            }
            catch (Exception e) {
                logger.warn("Error destroying MBeanServerFactory", (Throwable)e);
            }
            this.mbeanServerFactory = null;
        }
        if (this.rmiRegistryFactory != null) {
            try {
                this.rmiRegistryFactory.destroy();
            }
            catch (Exception e) {
                logger.warn("Error destroying RMIRegistryFactory", (Throwable)e);
            }
            this.rmiRegistryFactory = null;
        }
    }

    public ConnectorServerFactory getConnectorServerFactory() {
        return this.connectorServerFactory;
    }
}

