/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.resource.transaction.backend.jta.internal;

import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import java.sql.Connection;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.resource.transaction.spi.DdlTransactionIsolator;
import org.hibernate.tool.schema.internal.exec.JdbcContext;
import org.jboss.logging.Logger;

public class DdlTransactionIsolatorJtaImpl
implements DdlTransactionIsolator {
    private static final Logger log = Logger.getLogger(DdlTransactionIsolatorJtaImpl.class);
    private final JdbcContext jdbcContext;
    private final Transaction suspendedTransaction;
    private Connection jdbcConnection;

    public DdlTransactionIsolatorJtaImpl(JdbcContext jdbcContext) {
        this.jdbcContext = jdbcContext;
        try {
            JtaPlatform jtaPlatform = jdbcContext.getServiceRegistry().requireService(JtaPlatform.class);
            log.tracef("DdlTransactionIsolatorJtaImpl#prepare: JtaPlatform -> %s", (Object)jtaPlatform);
            TransactionManager tm = jtaPlatform.retrieveTransactionManager();
            if (tm == null) {
                throw new HibernateException("DdlTransactionIsolatorJtaImpl could not locate TransactionManager to suspend any current transaction; base JtaPlatform impl (" + jtaPlatform.toString() + ")?");
            }
            log.tracef("DdlTransactionIsolatorJtaImpl#prepare: TransactionManager -> %s", (Object)tm);
            this.suspendedTransaction = tm.suspend();
            log.tracef("DdlTransactionIsolatorJtaImpl#prepare: suspended Transaction -> %s", (Object)this.suspendedTransaction);
        }
        catch (SystemException e) {
            throw new HibernateException("Unable to suspend current JTA transaction in preparation for DDL execution");
        }
    }

    @Override
    public JdbcContext getJdbcContext() {
        return this.jdbcContext;
    }

    @Override
    public Connection getIsolatedConnection() {
        return this.getIsolatedConnection(true);
    }

    @Override
    public Connection getIsolatedConnection(boolean autocommit) {
        if (this.jdbcConnection == null) {
            try {
                this.jdbcConnection = this.jdbcContext.getJdbcConnectionAccess().obtainConnection();
            }
            catch (SQLException e) {
                throw this.jdbcContext.getSqlExceptionHelper().convert(e, "Unable to open JDBC Connection for DDL execution");
            }
            try {
                if (this.jdbcConnection.getAutoCommit() != autocommit) {
                    this.jdbcConnection.setAutoCommit(autocommit);
                }
            }
            catch (SQLException e) {
                throw this.jdbcContext.getSqlExceptionHelper().convert(e, "Unable set JDBC Connection for DDL execution to autocommit");
            }
        }
        return this.jdbcConnection;
    }

    @Override
    public void release() {
        if (this.jdbcConnection != null) {
            try {
                this.jdbcContext.getJdbcConnectionAccess().releaseConnection(this.jdbcConnection);
            }
            catch (SQLException e) {
                throw this.jdbcContext.getSqlExceptionHelper().convert(e, "Unable to release JDBC Connection used for DDL execution");
            }
        }
        if (this.suspendedTransaction != null) {
            try {
                this.jdbcContext.getServiceRegistry().requireService(JtaPlatform.class).retrieveTransactionManager().resume(this.suspendedTransaction);
            }
            catch (Exception e) {
                throw new HibernateException("Unable to resume JTA transaction after DDL execution");
            }
        }
    }
}

