/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.stream;

import org.dbunit.dataset.AbstractDataSet;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.stream.IDataSetProducer;
import org.dbunit.dataset.stream.StreamingIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingDataSet
extends AbstractDataSet {
    private static final Logger logger = LoggerFactory.getLogger(StreamingDataSet.class);
    private IDataSetProducer _source;
    private int _iteratorCount;

    public StreamingDataSet(IDataSetProducer source) {
        this._source = source;
    }

    @Override
    protected ITableIterator createIterator(boolean reversed) throws DataSetException {
        logger.debug("createIterator(reversed={}) - start", (Object)reversed);
        if (reversed) {
            throw new UnsupportedOperationException("Reverse iterator not supported!");
        }
        if (this._iteratorCount > 0) {
            throw new UnsupportedOperationException("Only one iterator allowed!");
        }
        ++this._iteratorCount;
        return new StreamingIterator(this._source);
    }

    @Override
    public String[] getTableNames() throws DataSetException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ITableMetaData getTableMetaData(String tableName) throws DataSetException {
        logger.debug("getTableMetaData(tableName={}) - start", (Object)tableName);
        throw new UnsupportedOperationException();
    }

    @Override
    public ITable getTable(String tableName) throws DataSetException {
        logger.debug("getTable(tableName={}) - start", (Object)tableName);
        throw new UnsupportedOperationException();
    }
}

