/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.mail;

import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.actuate.autoconfigure.health.CompositeHealthContributorConfiguration;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.health.HealthContributor;
import org.springframework.boot.actuate.mail.MailHealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.mail.MailSenderAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.mail.javamail.JavaMailSenderImpl;

@AutoConfiguration(after={MailSenderAutoConfiguration.class})
@ConditionalOnClass(value={JavaMailSenderImpl.class})
@ConditionalOnBean(value={JavaMailSenderImpl.class})
@ConditionalOnEnabledHealthIndicator(value="mail")
public class MailHealthContributorAutoConfiguration
extends CompositeHealthContributorConfiguration<MailHealthIndicator, JavaMailSenderImpl> {
    public MailHealthContributorAutoConfiguration() {
        super(MailHealthIndicator::new);
    }

    @Bean
    @ConditionalOnMissingBean(name={"mailHealthIndicator", "mailHealthContributor"})
    public HealthContributor mailHealthContributor(ConfigurableListableBeanFactory beanFactory) {
        return (HealthContributor)this.createContributor(beanFactory, JavaMailSenderImpl.class);
    }
}

