/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.mappers;

import java.util.Arrays;
import java.util.regex.Pattern;
import org.owasp.html.HtmlChangeListener;
import org.owasp.html.HtmlPolicyBuilder;
import org.owasp.html.HtmlSanitizer;
import org.owasp.html.HtmlStreamEventReceiver;
import org.owasp.html.HtmlStreamRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sanitizer {
    private static final Logger logger = LoggerFactory.getLogger(Sanitizer.class);
    private static final HtmlPolicyBuilder POLICY_DEFINITION = new HtmlPolicyBuilder().allowStandardUrlProtocols().allowAttributes(new String[]{"title"}).globally().allowAttributes(new String[]{"href"}).onElements(new String[]{"a"}).requireRelNofollowOnLinks().allowAttributes(new String[]{"lang"}).matching(Pattern.compile("[a-zA-Z]{2,20}")).globally().allowAttributes(new String[]{"align"}).matching(true, new String[]{"center", "left", "right", "justify", "char"}).onElements(new String[]{"p"}).allowElements(new String[]{"a", "p", "div", "i", "b", "em", "blockquote", "tt", "strong", "br", "ul", "ol", "li"}).allowElements(new String[]{"quote", "ecode"});

    public static String sanitize(String input) {
        StringBuilder sanitized = new StringBuilder();
        HtmlSanitizer.sanitize((String)input, (HtmlSanitizer.Policy)POLICY_DEFINITION.build((HtmlStreamEventReceiver)HtmlStreamRenderer.create((StringBuilder)sanitized, null), (HtmlChangeListener)new HtmlChangeListener<Object>(){

            public void discardedTag(Object context, String elementName) {
                logger.warn("Found errors during sanitation: discarded tag {}", (Object)elementName);
            }

            public void discardedAttributes(Object context, String tagName, String ... attributeNames) {
                logger.warn("Found errors during sanitation: discarded attributes {} on tag {}", (Object)Arrays.toString(attributeNames), (Object)tagName);
            }
        }, null));
        return sanitized.toString();
    }
}

