/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.internal;

import org.hibernate.boot.model.TypeDefinitionRegistryStandardImpl;
import org.hibernate.boot.model.naming.ObjectNameNormalizer;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MappingDefaults;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.MetadataBuildingOptions;

public class MetadataBuildingContextRootImpl
implements MetadataBuildingContext {
    private final String contributor;
    private final BootstrapContext bootstrapContext;
    private final MetadataBuildingOptions options;
    private final MappingDefaults mappingDefaults;
    private final InFlightMetadataCollector metadataCollector;
    private final ObjectNameNormalizer objectNameNormalizer;
    private final TypeDefinitionRegistryStandardImpl typeDefinitionRegistry;

    public MetadataBuildingContextRootImpl(String contributor, BootstrapContext bootstrapContext, MetadataBuildingOptions options, InFlightMetadataCollector metadataCollector) {
        this.contributor = contributor;
        this.bootstrapContext = bootstrapContext;
        this.options = options;
        this.mappingDefaults = options.getMappingDefaults();
        this.metadataCollector = metadataCollector;
        this.objectNameNormalizer = new ObjectNameNormalizer(){

            @Override
            protected MetadataBuildingContext getBuildingContext() {
                return MetadataBuildingContextRootImpl.this;
            }
        };
        this.typeDefinitionRegistry = new TypeDefinitionRegistryStandardImpl();
    }

    @Override
    public BootstrapContext getBootstrapContext() {
        return this.bootstrapContext;
    }

    @Override
    public MetadataBuildingOptions getBuildingOptions() {
        return this.options;
    }

    @Override
    public MappingDefaults getMappingDefaults() {
        return this.mappingDefaults;
    }

    @Override
    public InFlightMetadataCollector getMetadataCollector() {
        return this.metadataCollector;
    }

    @Override
    public ObjectNameNormalizer getObjectNameNormalizer() {
        return this.objectNameNormalizer;
    }

    @Override
    public TypeDefinitionRegistryStandardImpl getTypeDefinitionRegistry() {
        return this.typeDefinitionRegistry;
    }

    @Override
    public String getCurrentContributorName() {
        return this.contributor;
    }
}

