/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.sshj.key;

import com.hierynomus.sshj.key.KeyAlgorithm;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.common.KeyType;
import net.schmizz.sshj.signature.Signature;

public class BaseKeyAlgorithm
implements KeyAlgorithm {
    private final String keyAlgorithm;
    private final Factory.Named<Signature> signature;
    private final KeyType keyFormat;

    public BaseKeyAlgorithm(String keyAlgorithm, Factory.Named<Signature> signature, KeyType keyFormat) {
        this.keyAlgorithm = keyAlgorithm;
        this.signature = signature;
        this.keyFormat = keyFormat;
    }

    @Override
    public void putPubKeyIntoBuffer(PublicKey pk, Buffer<?> buf) {
        this.keyFormat.putPubKeyIntoBuffer(pk, buf);
    }

    @Override
    public PublicKey readPubKeyFromBuffer(Buffer<?> buf) throws GeneralSecurityException {
        return this.keyFormat.readPubKeyFromBuffer(buf);
    }

    @Override
    public String getKeyAlgorithm() {
        return this.keyAlgorithm;
    }

    @Override
    public KeyType getKeyFormat() {
        return this.keyFormat;
    }

    @Override
    public Signature newSignature() {
        return (Signature)this.signature.create();
    }
}

