/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.core.oidc.user;

import java.util.Collection;
import java.util.Map;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.core.oidc.OidcIdToken;
import org.springframework.security.oauth2.core.oidc.OidcUserInfo;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.oauth2.core.oidc.user.OidcUserAuthority;
import org.springframework.security.oauth2.core.user.DefaultOAuth2User;

public class DefaultOidcUser
extends DefaultOAuth2User
implements OidcUser {
    private static final long serialVersionUID = -2378469202439157250L;
    private final OidcIdToken idToken;
    private final OidcUserInfo userInfo;

    public DefaultOidcUser(Collection<? extends GrantedAuthority> authorities, OidcIdToken idToken) {
        this(authorities, idToken, "sub");
    }

    public DefaultOidcUser(Collection<? extends GrantedAuthority> authorities, OidcIdToken idToken, String nameAttributeKey) {
        this(authorities, idToken, null, nameAttributeKey);
    }

    public DefaultOidcUser(Collection<? extends GrantedAuthority> authorities, OidcIdToken idToken, OidcUserInfo userInfo) {
        this(authorities, idToken, userInfo, "sub");
    }

    public DefaultOidcUser(Collection<? extends GrantedAuthority> authorities, OidcIdToken idToken, OidcUserInfo userInfo, String nameAttributeKey) {
        super(authorities, OidcUserAuthority.collectClaims(idToken, userInfo), nameAttributeKey);
        this.idToken = idToken;
        this.userInfo = userInfo;
    }

    @Override
    public Map<String, Object> getClaims() {
        return this.getAttributes();
    }

    @Override
    public OidcIdToken getIdToken() {
        return this.idToken;
    }

    @Override
    public OidcUserInfo getUserInfo() {
        return this.userInfo;
    }
}

