/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.hint;

import java.util.Objects;
import org.springframework.aot.hint.ConditionalHint;
import org.springframework.aot.hint.TypeReference;
import org.springframework.lang.Nullable;

public final class ResourceBundleHint
implements ConditionalHint {
    private final String baseName;
    @Nullable
    private final TypeReference reachableType;

    ResourceBundleHint(Builder builder) {
        this.baseName = builder.baseName;
        this.reachableType = builder.reachableType;
    }

    public String getBaseName() {
        return this.baseName;
    }

    @Override
    @Nullable
    public TypeReference getReachableType() {
        return this.reachableType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof ResourceBundleHint)) return false;
        ResourceBundleHint that = (ResourceBundleHint)other;
        if (!this.baseName.equals(that.baseName)) return false;
        if (!Objects.equals(this.reachableType, that.reachableType)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.baseName, this.reachableType);
    }

    public static class Builder {
        private String baseName;
        @Nullable
        private TypeReference reachableType;

        Builder(String baseName) {
            this.baseName = baseName;
        }

        public Builder onReachableType(TypeReference reachableType) {
            this.reachableType = reachableType;
            return this;
        }

        public Builder baseName(String baseName) {
            this.baseName = baseName;
            return this;
        }

        ResourceBundleHint build() {
            return new ResourceBundleHint(this);
        }
    }
}

