/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.core.functions;

import java.util.Objects;
import java.util.function.Consumer;

@FunctionalInterface
public interface CheckedConsumer<T> {
    public void accept(T var1) throws Throwable;

    default public CheckedConsumer<T> andThen(CheckedConsumer<? super T> after) {
        Objects.requireNonNull(after, "after is null");
        return t -> {
            this.accept(t);
            after.accept(t);
        };
    }

    default public Consumer<T> unchecked() {
        return t -> {
            try {
                this.accept(t);
            }
            catch (Throwable x) {
                CheckedConsumer.sneakyThrow(x);
            }
        };
    }

    public static <T extends Throwable, R> R sneakyThrow(Throwable t) throws T {
        throw t;
    }
}

