/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm;

import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.lang.Nullable;

public class ObjectRetrievalFailureException
extends DataRetrievalFailureException {
    @Nullable
    private final Object persistentClass;
    @Nullable
    private final Object identifier;

    public ObjectRetrievalFailureException(@Nullable String msg, Throwable cause) {
        super(msg, cause);
        this.persistentClass = null;
        this.identifier = null;
    }

    public ObjectRetrievalFailureException(Class<?> persistentClass, Object identifier) {
        this(persistentClass, identifier, "Object of class [" + persistentClass.getName() + "] with identifier [" + String.valueOf(identifier) + "]: not found", null);
    }

    public ObjectRetrievalFailureException(Class<?> persistentClass, @Nullable Object identifier, String msg, @Nullable Throwable cause) {
        super(msg, cause);
        this.persistentClass = persistentClass;
        this.identifier = identifier;
    }

    public ObjectRetrievalFailureException(String persistentClassName, Object identifier) {
        this(persistentClassName, identifier, "Object of class [" + persistentClassName + "] with identifier [" + String.valueOf(identifier) + "]: not found", null);
    }

    public ObjectRetrievalFailureException(String persistentClassName, @Nullable Object identifier, @Nullable String msg, @Nullable Throwable cause) {
        super(msg, cause);
        this.persistentClass = persistentClassName;
        this.identifier = identifier;
    }

    @Nullable
    public Class<?> getPersistentClass() {
        Class clazz;
        Object object = this.persistentClass;
        return object instanceof Class ? (clazz = (Class)object) : null;
    }

    @Nullable
    public String getPersistentClassName() {
        Object object = this.persistentClass;
        if (object instanceof Class) {
            Class clazz = (Class)object;
            return clazz.getName();
        }
        return this.persistentClass != null ? this.persistentClass.toString() : null;
    }

    @Nullable
    public Object getIdentifier() {
        return this.identifier;
    }
}

