/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.ntlm.messages;

import com.hierynomus.ntlm.av.AvId;
import com.hierynomus.ntlm.av.AvPair;
import com.hierynomus.ntlm.av.AvPairEnd;
import com.hierynomus.ntlm.av.AvPairFactory;
import com.hierynomus.protocol.commons.buffer.Buffer;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TargetInfo {
    private static final Logger logger = LoggerFactory.getLogger(TargetInfo.class);
    private List<AvPair<?>> targetInfo = new ArrayList();

    public TargetInfo readFrom(Buffer.PlainBuffer buffer) throws Buffer.BufferException {
        AvPair<?> p;
        while ((p = AvPairFactory.read(buffer)).getAvId() != AvId.MsvAvEOL) {
            logger.trace("Read TargetInfo {} --> {}", (Object)p.getAvId(), p.getValue());
            this.targetInfo.add(p);
        }
        return this;
    }

    public void writeTo(Buffer.PlainBuffer buffer) {
        for (AvPair<Buffer.PlainBuffer> avPair : this.targetInfo) {
            logger.trace("Writing TargetInfo {} --> {}", (Object)avPair.getAvId(), avPair.getValue());
            avPair.write(buffer);
        }
        new AvPairEnd().write(buffer);
    }

    public TargetInfo copy() {
        TargetInfo c = new TargetInfo();
        c.targetInfo = new ArrayList(this.targetInfo);
        return c;
    }

    public <T extends AvPair<?>> T getAvPair(AvId key) {
        for (AvPair<?> avPair : this.targetInfo) {
            if (avPair.getAvId() != key) continue;
            return (T)avPair;
        }
        return null;
    }

    public void putAvPair(AvPair<?> pair) {
        for (AvPair<?> avPair : this.targetInfo) {
            if (avPair.getAvId() != pair.getAvId()) continue;
            this.targetInfo.remove(avPair);
            break;
        }
        this.targetInfo.add(pair);
    }

    public boolean hasAvPair(AvId key) {
        for (AvPair<?> avPair : this.targetInfo) {
            if (avPair.getAvId() != key) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "TargetInfo{targetInfo=" + this.targetInfo + '}';
    }
}

