/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.pdfboxout;

import com.openhtmltopdf.css.style.CssContext;
import com.openhtmltopdf.layout.SharedContext;
import com.openhtmltopdf.pdfboxout.DOMUtil;
import com.openhtmltopdf.pdfboxout.PdfBoxAccessibilityHelper;
import com.openhtmltopdf.pdfboxout.PdfBoxFastOutputDevice;
import com.openhtmltopdf.render.Box;
import com.openhtmltopdf.render.PageBox;
import com.openhtmltopdf.render.RenderingContext;
import com.openhtmltopdf.render.displaylist.PagedBoxCollector;
import com.openhtmltopdf.util.LogMessageId;
import com.openhtmltopdf.util.XRLog;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureElement;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageFitHeightDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageXYZDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PdfBoxBookmarkManager {
    private final List<Bookmark> _bookmarks = new ArrayList<Bookmark>();
    private final PDDocument _writer;
    private final SharedContext _sharedContext;
    private final float _dotsPerPoint;
    private final PdfBoxFastOutputDevice _od;
    private final Document _xml;
    private PDDestination _defaultDestination;

    public PdfBoxBookmarkManager(Document xml, PDDocument doc, SharedContext sharedContext, float dotsPerPoint, PdfBoxFastOutputDevice od) {
        this._writer = doc;
        this._sharedContext = sharedContext;
        this._dotsPerPoint = dotsPerPoint;
        this._od = od;
        this._xml = xml;
    }

    public void writeOutline(RenderingContext c, Box root) {
        if (this._bookmarks.size() > 0) {
            PDPageFitHeightDestination dest = new PDPageFitHeightDestination();
            dest.setPage(this._writer.getPage(0));
            this._defaultDestination = dest;
            PDDocumentOutline outline = this._writer.getDocumentCatalog().getDocumentOutline();
            if (outline == null) {
                outline = new PDDocumentOutline();
                this._writer.getDocumentCatalog().setDocumentOutline(outline);
            }
            this.writeBookmarks(c, root, (PDOutlineNode)outline, this._bookmarks);
        }
    }

    private void writeBookmarks(RenderingContext c, Box root, PDOutlineNode parent, List<Bookmark> bookmarks) {
        for (Bookmark bookmark : bookmarks) {
            this.writeBookmark(c, root, parent, bookmark);
        }
    }

    private void writeBookmark(RenderingContext c, Box root, PDOutlineNode parent, Bookmark bookmark) {
        String href = bookmark.getHRef();
        PDDestination target = null;
        Box box = null;
        if (href.length() > 0 && href.charAt(0) == '#' && (box = this._sharedContext.getBoxById(href.substring(1))) != null) {
            target = PdfBoxBookmarkManager.createBoxDestination(c, this._writer, this._od, this._dotsPerPoint, root, box);
        }
        if (target == null) {
            XRLog.log((Level)Level.WARNING, (LogMessageId.LogMessageId1Param)LogMessageId.LogMessageId1Param.GENERAL_PDF_COULD_NOT_FIND_VALID_TARGET_FOR_BOOKMARK, (Object)href);
        }
        PDOutlineItem outline = new PDOutlineItem();
        outline.setDestination(target == null ? this._defaultDestination : target);
        outline.setTitle(bookmark.getName());
        PDStructureElement se = PdfBoxAccessibilityHelper.getStructualElementForBox(box);
        if (se != null) {
            outline.setStructureElement(se);
        }
        parent.addLast(outline);
        this.writeBookmarks(c, root, (PDOutlineNode)outline, bookmark.getChildren());
    }

    public static PDPageXYZDestination createBoxDestination(RenderingContext c, PDDocument writer, PdfBoxFastOutputDevice od, float dotsPerPoint, Box root, Box box) {
        List pages = root.getLayer().getPages();
        Rectangle bounds = PagedBoxCollector.findAdjustedBoundsForBorderBox((CssContext)c, (Box)box, (List)pages);
        int pageBoxIndex = PagedBoxCollector.findPageForY((CssContext)c, (double)bounds.getMinY(), (List)pages);
        PageBox page = (PageBox)pages.get(pageBoxIndex);
        int distanceFromTop = page.getMarginBorderPadding((CssContext)c, 3);
        distanceFromTop = (int)((double)distanceFromTop + (bounds.getMinY() - (double)page.getTop()));
        int shadowPage = PagedBoxCollector.getShadowPageForBounds((CssContext)c, (Rectangle)bounds, (PageBox)page);
        int pdfPageIndex = shadowPage == -1 ? page.getBasePagePdfPageIndex() : shadowPage + 1 + page.getBasePagePdfPageIndex();
        PDPageXYZDestination target = new PDPageXYZDestination();
        target.setTop((int)(od.normalizeY(distanceFromTop, page.getHeight((CssContext)c)) / dotsPerPoint));
        target.setPage(writer.getPage(pdfPageIndex));
        return target;
    }

    public void loadBookmarks() {
        Document doc = this._xml;
        Element head = DOMUtil.getChild(doc.getDocumentElement(), "head");
        Element body = DOMUtil.getChild(doc.getDocumentElement(), "body");
        this.handleBookmarksInParent(head);
        this.handleBookmarksInParent(body);
    }

    private void handleBookmarksInParent(Element element) {
        List<Element> l;
        Element bookmarks;
        if (element != null && (bookmarks = DOMUtil.getChild(element, "bookmarks")) != null && (l = DOMUtil.getChildren(bookmarks, "bookmark")) != null) {
            for (Element e : l) {
                this.loadBookmark(null, e);
            }
        }
    }

    private void loadBookmark(Bookmark parent, Element bookmark) {
        Bookmark us = new Bookmark(bookmark.getAttribute("name"), bookmark.getAttribute("href"));
        if (parent == null) {
            this._bookmarks.add(us);
        } else {
            parent.addChild(us);
        }
        List<Element> l = DOMUtil.getChildren(bookmark, "bookmark");
        if (l != null) {
            for (Element e : l) {
                this.loadBookmark(us, e);
            }
        }
    }

    private static class Bookmark {
        private final String _name;
        private final String _HRef;
        private List<Bookmark> _children;

        public Bookmark(String name, String href) {
            this._name = name;
            this._HRef = href;
        }

        public String getHRef() {
            return this._HRef;
        }

        public String getName() {
            return this._name;
        }

        public void addChild(Bookmark child) {
            if (this._children == null) {
                this._children = new ArrayList<Bookmark>();
            }
            this._children.add(child);
        }

        public List<Bookmark> getChildren() {
            return this._children == null ? Collections.emptyList() : this._children;
        }
    }
}

