/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.chill.java;

import com.esotericsoftware.kryo.kryo5.Kryo;
import com.esotericsoftware.kryo.kryo5.Serializer;
import com.esotericsoftware.kryo.kryo5.io.Input;
import com.esotericsoftware.kryo.kryo5.io.Output;
import com.twitter.chill.IKryoRegistrar;
import com.twitter.chill.SingleRegistrar;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ArraysAsListSerializer
extends Serializer<List<?>> {
    private static final Map<Class<?>, Class<?>> primitives = new HashMap(8, 1.0f);
    private Field _arrayField;

    public static IKryoRegistrar registrar() {
        return new SingleRegistrar(Arrays.asList("").getClass(), new ArraysAsListSerializer());
    }

    public ArraysAsListSerializer() {
        try {
            this._arrayField = Class.forName("java.util.Arrays$ArrayList").getDeclaredField("a");
            this._arrayField.setAccessible(true);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public List<?> read(Kryo kryo, Input input, Class<? extends List<?>> clazz) {
        int n = input.readInt(true);
        Class clazz2 = kryo.readClass(input).getType();
        try {
            Object object = Array.newInstance(ArraysAsListSerializer.getBoxedClass(clazz2), n);
            for (int i = 0; i < n; ++i) {
                Array.set(object, i, kryo.readClassAndObject(input));
            }
            return Arrays.asList((Object[])object);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void write(Kryo kryo, Output output, List<?> list) {
        try {
            Object[] objectArray = (Object[])this._arrayField.get(list);
            output.writeInt(objectArray.length, true);
            Class<?> clazz = objectArray.getClass().getComponentType();
            kryo.writeClass(output, clazz);
            for (Object object : objectArray) {
                kryo.writeClassAndObject(output, object);
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static Class<?> getBoxedClass(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            Class<?> clazz2 = primitives.get(clazz);
            return clazz2 != null ? clazz2 : clazz;
        }
        return clazz;
    }

    static {
        primitives.put(Byte.TYPE, Byte.class);
        primitives.put(Short.TYPE, Short.class);
        primitives.put(Integer.TYPE, Integer.class);
        primitives.put(Long.TYPE, Long.class);
        primitives.put(Character.TYPE, Character.class);
        primitives.put(Float.TYPE, Float.class);
        primitives.put(Double.TYPE, Double.class);
        primitives.put(Boolean.TYPE, Boolean.class);
    }
}

