/*
 * Decompiled with CFR 0.152.
 */
package kamon.context.generated.binary.context;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.InputMismatchException;

public class Entry
implements Serializable {
    public static int colferSizeMax = 0x1000000;
    public String key;
    public byte[] value;
    private static final byte[] _zeroBytes = new byte[0];
    private static final long serialVersionUID = 2L;

    public Entry() {
        this.init();
    }

    private void init() {
        this.key = "";
        this.value = _zeroBytes;
    }

    public byte[] marshal(OutputStream outputStream, byte[] byArray) throws IOException {
        int n;
        if (byArray == null || byArray.length == 0) {
            byArray = new byte[Math.min(colferSizeMax, 2048)];
        }
        while (true) {
            try {
                n = this.marshal(byArray, 0);
            }
            catch (BufferOverflowException bufferOverflowException) {
                byArray = new byte[Math.min(colferSizeMax, byArray.length * 4)];
                continue;
            }
            break;
        }
        outputStream.write(byArray, 0, n);
        return byArray;
    }

    public int marshal(byte[] byArray, int n) {
        int n2 = n;
        try {
            int n3;
            int n4;
            if (!this.key.isEmpty()) {
                int n5;
                byArray[n2++] = 0;
                n4 = ++n2;
                String string = this.key;
                int n6 = string.length();
                for (n3 = 0; n3 < n6; ++n3) {
                    n5 = string.charAt(n3);
                    if (n5 < 128) {
                        byArray[n2++] = (byte)n5;
                        continue;
                    }
                    if (n5 < 2048) {
                        byArray[n2++] = (byte)(0xC0 | n5 >>> 6);
                        byArray[n2++] = (byte)(0x80 | n5 & 0x3F);
                        continue;
                    }
                    if (n5 < 55296 || n5 > 57343) {
                        byArray[n2++] = (byte)(0xE0 | n5 >>> 12);
                        byArray[n2++] = (byte)(0x80 | n5 >>> 6 & 0x3F);
                        byArray[n2++] = (byte)(0x80 | n5 & 0x3F);
                        continue;
                    }
                    int n7 = 0;
                    if (++n3 < n6) {
                        n7 = Character.toCodePoint((char)n5, string.charAt(n3));
                    }
                    if (n7 >= 65536 && n7 < 0x200000) {
                        byArray[n2++] = (byte)(0xF0 | n7 >>> 18);
                        byArray[n2++] = (byte)(0x80 | n7 >>> 12 & 0x3F);
                        byArray[n2++] = (byte)(0x80 | n7 >>> 6 & 0x3F);
                        byArray[n2++] = (byte)(0x80 | n7 & 0x3F);
                        continue;
                    }
                    byArray[n2++] = 63;
                }
                n3 = n2 - n4;
                if (n3 > colferSizeMax) {
                    throw new IllegalStateException(String.format("colfer: kamon/context/generated/binary/context.Entry.key size %d exceeds %d UTF-8 bytes", n3, colferSizeMax));
                }
                n6 = n4 - 1;
                if (n3 > 127) {
                    ++n2;
                    for (n5 = n3; n5 >= 16384; n5 >>>= 7) {
                        ++n2;
                    }
                    System.arraycopy(byArray, n4, byArray, n2 - n3, n3);
                    do {
                        byArray[n6++] = (byte)(n3 | 0x80);
                    } while ((n3 >>>= 7) > 127);
                }
                byArray[n6] = (byte)n3;
            }
            if (this.value.length != 0) {
                int n8;
                byArray[n2++] = 1;
                n4 = this.value.length;
                if (n4 > colferSizeMax) {
                    throw new IllegalStateException(String.format("colfer: kamon/context/generated/binary/context.Entry.value size %d exceeds %d bytes", n4, colferSizeMax));
                }
                for (n8 = n4; n8 > 127; n8 >>>= 7) {
                    byArray[n2++] = (byte)(n8 | 0x80);
                }
                byArray[n2++] = (byte)n8;
                n3 = n2;
                n2 += n4;
                System.arraycopy(this.value, 0, byArray, n3, n4);
            }
            byArray[n2++] = 127;
            return n2;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (n2 - n > colferSizeMax) {
                throw new IllegalStateException(String.format("colfer: kamon/context/generated/binary/context.Entry exceeds %d bytes", colferSizeMax));
            }
            if (n2 > byArray.length) {
                throw new BufferOverflowException();
            }
            throw arrayIndexOutOfBoundsException;
        }
    }

    public int unmarshal(byte[] byArray, int n) {
        return this.unmarshal(byArray, n, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int unmarshal(byte[] byArray, int n, int n2) {
        int n3;
        block15: {
            if (n2 > byArray.length) {
                n2 = byArray.length;
            }
            n3 = n;
            try {
                byte by;
                int n4;
                int n5;
                byte by2 = byArray[n3++];
                if (by2 == 0) {
                    n5 = 0;
                    n4 = 0;
                    while (true) {
                        by = byArray[n3++];
                        n5 |= (by & 0x7F) << n4;
                        if (n4 == 28 || by >= 0) break;
                        n4 += 7;
                    }
                    if (n5 < 0 || n5 > colferSizeMax) {
                        throw new SecurityException(String.format("colfer: kamon/context/generated/binary/context.Entry.key size %d exceeds %d UTF-8 bytes", n5, colferSizeMax));
                    }
                    n4 = n3;
                    n3 += n5;
                    this.key = new String(byArray, n4, n5, StandardCharsets.UTF_8);
                    by2 = byArray[n3++];
                }
                if (by2 == 1) {
                    n5 = 0;
                    n4 = 0;
                    while (true) {
                        by = byArray[n3++];
                        n5 |= (by & 0x7F) << n4;
                        if (n4 == 28 || by >= 0) break;
                        n4 += 7;
                    }
                    if (n5 < 0 || n5 > colferSizeMax) {
                        throw new SecurityException(String.format("colfer: kamon/context/generated/binary/context.Entry.value size %d exceeds %d bytes", n5, colferSizeMax));
                    }
                    this.value = new byte[n5];
                    n4 = n3;
                    n3 += n5;
                    System.arraycopy(byArray, n4, this.value, 0, n5);
                    by2 = byArray[n3++];
                }
                if (by2 != 127) {
                    throw new InputMismatchException(String.format("colfer: unknown header at byte %d", n3 - 1));
                }
                if (n3 <= n2 || n2 - n >= colferSizeMax) break block15;
            }
            catch (Throwable throwable) {
                if (n3 > n2 && n2 - n < colferSizeMax) {
                    throw new BufferUnderflowException();
                }
                if (n3 < 0 || n3 - n > colferSizeMax) {
                    throw new SecurityException(String.format("colfer: kamon/context/generated/binary/context.Entry exceeds %d bytes", colferSizeMax));
                }
                if (n3 > n2) {
                    throw new BufferUnderflowException();
                }
                throw throwable;
            }
            throw new BufferUnderflowException();
        }
        if (n3 < 0 || n3 - n > colferSizeMax) {
            throw new SecurityException(String.format("colfer: kamon/context/generated/binary/context.Entry exceeds %d bytes", colferSizeMax));
        }
        if (n3 > n2) {
            throw new BufferUnderflowException();
        }
        return n3;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n;
        byte[] byArray = new byte[1024];
        while (true) {
            try {
                n = this.marshal(byArray, 0);
            }
            catch (BufferUnderflowException bufferUnderflowException) {
                byArray = new byte[4 * byArray.length];
                continue;
            }
            break;
        }
        objectOutputStream.writeInt(n);
        objectOutputStream.write(byArray, 0, n);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        this.init();
        int n = objectInputStream.readInt();
        byte[] byArray = new byte[n];
        objectInputStream.readFully(byArray);
        this.unmarshal(byArray, 0);
    }

    private void readObjectNoData() throws ObjectStreamException {
        this.init();
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String string) {
        this.key = string;
    }

    public Entry withKey(String string) {
        this.key = string;
        return this;
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] byArray) {
        this.value = byArray;
    }

    public Entry withValue(byte[] byArray) {
        this.value = byArray;
        return this;
    }

    public final int hashCode() {
        int n = 1;
        if (this.key != null) {
            n = 31 * n + this.key.hashCode();
        }
        for (byte by : this.value) {
            n = 31 * n + by;
        }
        return n;
    }

    public final boolean equals(Object object) {
        return object instanceof Entry && this.equals((Entry)object);
    }

    public final boolean equals(Entry entry) {
        if (entry == null) {
            return false;
        }
        if (entry == this) {
            return true;
        }
        return entry.getClass() == Entry.class && (this.key == null ? entry.key == null : this.key.equals(entry.key)) && Arrays.equals(this.value, entry.value);
    }

    public static class Unmarshaller {
        protected InputStream in;
        public byte[] buf;
        protected int offset;
        protected int i;

        public Unmarshaller(InputStream inputStream, byte[] byArray) {
            if (byArray == null || byArray.length == 0) {
                byArray = new byte[Math.min(colferSizeMax, 2048)];
            }
            this.buf = byArray;
            this.reset(inputStream);
        }

        public void reset(InputStream inputStream) {
            if (this.i != this.offset) {
                throw new IllegalStateException("colfer: pending data");
            }
            this.in = inputStream;
            this.offset = 0;
            this.i = 0;
        }

        public Entry next() throws IOException {
            if (this.in == null) {
                return null;
            }
            while (true) {
                if (this.i > this.offset) {
                    try {
                        Entry entry = new Entry();
                        this.offset = entry.unmarshal(this.buf, this.offset, this.i);
                        return entry;
                    }
                    catch (BufferUnderflowException bufferUnderflowException) {
                        // empty catch block
                    }
                }
                if (this.i <= this.offset) {
                    this.offset = 0;
                    this.i = 0;
                } else if (this.i == this.buf.length) {
                    byte[] byArray = this.buf;
                    if (this.offset == 0) {
                        this.buf = new byte[Math.min(colferSizeMax, this.buf.length * 4)];
                    }
                    System.arraycopy(byArray, this.offset, this.buf, 0, this.i - this.offset);
                    this.i -= this.offset;
                    this.offset = 0;
                }
                assert (this.i < this.buf.length);
                int n = this.in.read(this.buf, this.i, this.buf.length - this.i);
                if (n < 0) {
                    if (this.i > this.offset) {
                        throw new InputMismatchException("colfer: pending data with EOF");
                    }
                    return null;
                }
                assert (n > 0);
                this.i += n;
            }
        }
    }
}

