/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.server;

import java.util.Arrays;
import org.apache.activemq.artemis.api.core.ActiveMQAddressExistsException;
import org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException;
import org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException;
import org.apache.activemq.artemis.jms.server.ActiveMQJMSServerBundle;
import org.slf4j.Logger;
import org.slf4j.helpers.MessageFormatter;

public class ActiveMQJMSServerBundle_impl
implements ActiveMQJMSServerBundle {
    private final Logger logger;

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    public ActiveMQJMSServerBundle_impl(Logger logger) {
        this.logger = logger;
    }

    @Override
    public ActiveMQInternalErrorException cfDoesntExist(String name) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ129000: Connection Factory {} does not exist", (Object[])new Object[]{name}).getMessage();
        ActiveMQInternalErrorException objReturn_cfDoesntExist = new ActiveMQInternalErrorException(returnString);
        ActiveMQJMSServerBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_cfDoesntExist);
        return objReturn_cfDoesntExist;
    }

    @Override
    public ActiveMQIllegalStateException discoveryGroupDoesntExist(String name) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ129003: Discovery Group '{}' does not exist on main config", (Object[])new Object[]{name}).getMessage();
        ActiveMQIllegalStateException objReturn_discoveryGroupDoesntExist = new ActiveMQIllegalStateException(returnString);
        ActiveMQJMSServerBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_discoveryGroupDoesntExist);
        return objReturn_discoveryGroupDoesntExist;
    }

    @Override
    public ActiveMQIllegalStateException noConnectorNameOnCF() {
        String returnString = "AMQ129004: No Connector name configured on create ConnectionFactory";
        ActiveMQIllegalStateException objReturn_noConnectorNameOnCF = new ActiveMQIllegalStateException(returnString);
        ActiveMQJMSServerBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_noConnectorNameOnCF);
        return objReturn_noConnectorNameOnCF;
    }

    @Override
    public ActiveMQIllegalStateException noConnectorNameConfiguredOnCF(String name) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ129005: Connector '{}' not found on the main configuration file", (Object[])new Object[]{name}).getMessage();
        ActiveMQIllegalStateException objReturn_noConnectorNameConfiguredOnCF = new ActiveMQIllegalStateException(returnString);
        ActiveMQJMSServerBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_noConnectorNameConfiguredOnCF);
        return objReturn_noConnectorNameConfiguredOnCF;
    }

    @Override
    public ActiveMQAddressExistsException cfBindingsExists(String name) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ129006: Binding {} is already being used by another connection factory", (Object[])new Object[]{name}).getMessage();
        ActiveMQAddressExistsException objReturn_cfBindingsExists = new ActiveMQAddressExistsException(returnString);
        ActiveMQJMSServerBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_cfBindingsExists);
        return objReturn_cfBindingsExists;
    }

    @Override
    public ActiveMQIllegalStateException errorDecodingPassword(Exception e) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ129007: Error decoding password using codec instance", (Object[])new Object[]{e}).getMessage();
        ActiveMQIllegalStateException objReturn_errorDecodingPassword = new ActiveMQIllegalStateException(returnString);
        objReturn_errorDecodingPassword.initCause((Throwable)e);
        ActiveMQJMSServerBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_errorDecodingPassword);
        return objReturn_errorDecodingPassword;
    }
}

