/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jandex;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.Declaration;
import org.jboss.jandex.Descriptor;
import org.jboss.jandex.DescriptorReconstruction;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.GenericSignature;
import org.jboss.jandex.GenericSignatureReconstruction;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.RecordComponentInternal;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeTarget;
import org.jboss.jandex.Utils;

public final class RecordComponentInfo
implements Declaration,
Descriptor,
GenericSignature {
    private ClassInfo clazz;
    private RecordComponentInternal internal;

    RecordComponentInfo() {
    }

    RecordComponentInfo(ClassInfo clazz, RecordComponentInternal internal) {
        this.clazz = clazz;
        this.internal = internal;
    }

    RecordComponentInfo(ClassInfo clazz, byte[] name, Type type) {
        this(clazz, new RecordComponentInternal(name, type));
    }

    public static RecordComponentInfo create(ClassInfo clazz, String name, Type type) {
        if (clazz == null) {
            throw new IllegalArgumentException("Clazz can't be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Name can't be null");
        }
        return new RecordComponentInfo(clazz, Utils.toUTF8(name), type);
    }

    public final ClassInfo declaringClass() {
        return this.clazz;
    }

    public final FieldInfo field() {
        return this.clazz.field(this.internal.name());
    }

    public final MethodInfo accessor() {
        return this.clazz.method(this.internal.name(), new Type[0]);
    }

    public final String name() {
        return this.internal.name();
    }

    public Type type() {
        return this.internal.type();
    }

    @Override
    public final boolean hasAnnotation(DotName name) {
        return this.internal.hasAnnotation(name);
    }

    @Override
    public final AnnotationInstance annotation(DotName name) {
        return this.internal.annotation(name);
    }

    public final List<AnnotationInstance> annotations(DotName name) {
        ArrayList<AnnotationInstance> instances = new ArrayList<AnnotationInstance>();
        for (AnnotationInstance instance : this.internal.annotationArray()) {
            if (!instance.name().equals(name)) continue;
            instances.add(instance);
        }
        return Collections.unmodifiableList(instances);
    }

    public final List<AnnotationInstance> annotationsWithRepeatable(DotName name, IndexView index) {
        if (index == null) {
            throw new IllegalArgumentException("Index must not be null");
        }
        ArrayList<AnnotationInstance> instances = new ArrayList<AnnotationInstance>(this.annotations(name));
        ClassInfo annotationClass = index.getClassByName(name);
        if (annotationClass == null) {
            throw new IllegalArgumentException("Index does not contain the annotation definition: " + name);
        }
        if (!annotationClass.isAnnotation()) {
            throw new IllegalArgumentException("Not an annotation type: " + annotationClass);
        }
        AnnotationInstance repeatable = annotationClass.declaredAnnotation(DotName.REPEATABLE_NAME);
        if (repeatable != null) {
            Type containingType = repeatable.value().asClass();
            for (AnnotationInstance container : this.annotations(containingType.name())) {
                for (AnnotationInstance nestedInstance : container.value().asNestedArray()) {
                    instances.add(AnnotationInstance.create(nestedInstance, container.target()));
                }
            }
        }
        return Collections.unmodifiableList(instances);
    }

    public final List<AnnotationInstance> annotations() {
        return this.internal.annotations();
    }

    @Override
    public final boolean hasDeclaredAnnotation(DotName name) {
        return this.declaredAnnotation(name) != null;
    }

    @Override
    public final AnnotationInstance declaredAnnotation(DotName name) {
        for (AnnotationInstance instance : this.internal.annotationArray()) {
            if (instance.target().kind() != AnnotationTarget.Kind.RECORD_COMPONENT || !instance.name().equals(name)) continue;
            return instance;
        }
        return null;
    }

    public final List<AnnotationInstance> declaredAnnotationsWithRepeatable(DotName name, IndexView index) {
        Type containingType;
        AnnotationInstance container;
        ClassInfo annotationClass;
        if (index == null) {
            throw new IllegalArgumentException("Index must not be null");
        }
        ArrayList<AnnotationInstance> instances = new ArrayList<AnnotationInstance>();
        AnnotationInstance declaredInstance = this.declaredAnnotation(name);
        if (declaredInstance != null) {
            instances.add(declaredInstance);
        }
        if ((annotationClass = index.getClassByName(name)) == null) {
            throw new IllegalArgumentException("Index does not contain the annotation definition: " + name);
        }
        if (!annotationClass.isAnnotation()) {
            throw new IllegalArgumentException("Not an annotation type: " + annotationClass);
        }
        AnnotationInstance repeatable = annotationClass.declaredAnnotation(DotName.REPEATABLE_NAME);
        if (repeatable != null && (container = this.declaredAnnotation((containingType = repeatable.value().asClass()).name())) != null) {
            for (AnnotationInstance nestedInstance : container.value().asNestedArray()) {
                instances.add(AnnotationInstance.create(nestedInstance, container.target()));
            }
        }
        return Collections.unmodifiableList(instances);
    }

    public final List<AnnotationInstance> declaredAnnotations() {
        ArrayList<AnnotationInstance> instances = new ArrayList<AnnotationInstance>();
        for (AnnotationInstance instance : this.internal.annotationArray()) {
            if (instance.target().kind() != AnnotationTarget.Kind.RECORD_COMPONENT) continue;
            instances.add(instance);
        }
        return Collections.unmodifiableList(instances);
    }

    @Override
    public boolean requiresGenericSignature() {
        return GenericSignatureReconstruction.requiresGenericSignature(this);
    }

    @Override
    public String genericSignature(Function<String, Type> typeVariableSubstitution) {
        return GenericSignatureReconstruction.reconstructGenericSignature(this, typeVariableSubstitution);
    }

    @Override
    public String descriptor(Function<String, Type> typeVariableSubstitution) {
        return DescriptorReconstruction.recordComponentDescriptor(this, typeVariableSubstitution);
    }

    public String toString() {
        return this.internal.toString(this.clazz);
    }

    @Override
    public final ClassInfo asClass() {
        throw new IllegalArgumentException("Not a class");
    }

    @Override
    public final FieldInfo asField() {
        throw new IllegalArgumentException("Not a field");
    }

    @Override
    public final MethodInfo asMethod() {
        throw new IllegalArgumentException("Not a method");
    }

    @Override
    public final MethodParameterInfo asMethodParameter() {
        throw new IllegalArgumentException("Not a method parameter");
    }

    @Override
    public final TypeTarget asType() {
        throw new IllegalArgumentException("Not a type");
    }

    @Override
    public final RecordComponentInfo asRecordComponent() {
        return this;
    }

    @Override
    public AnnotationTarget.Kind kind() {
        return AnnotationTarget.Kind.RECORD_COMPONENT;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.clazz.hashCode();
        result = 31 * result + this.internal.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecordComponentInfo other = (RecordComponentInfo)o;
        return this.clazz.equals(other.clazz) && this.internal.equals(other.internal);
    }

    void setType(Type type) {
        this.internal.setType(type);
    }

    void setAnnotations(List<AnnotationInstance> annotations) {
        this.internal.setAnnotations(annotations);
    }

    RecordComponentInternal recordComponentInternal() {
        return this.internal;
    }

    void setRecordComponentInternal(RecordComponentInternal internal) {
        this.internal = internal;
    }

    void setClassInfo(ClassInfo clazz) {
        this.clazz = clazz;
    }
}

