/*
 * Decompiled with CFR 0.152.
 */
package com.xhaus.modjy;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.python.core.Options;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PySystemState;
import org.python.core.PyType;
import org.python.util.PythonInterpreter;

public class ModjyJServlet
extends HttpServlet {
    protected static final String MODJY_PYTHON_CLASSNAME = "modjy_servlet";
    protected static final String LIB_PYTHON = "/WEB-INF/lib-python";
    protected static final String PTH_FILE_EXTENSION = ".pth";
    protected static final String LOAD_SITE_PACKAGES_PARAM = "load_site_packages";
    protected static final String PYTHON_HOME_PARAM = "python.home";
    protected PythonInterpreter interp;
    protected HttpServlet modjyServlet;

    protected Properties readConfiguration() {
        String name;
        Properties props = new Properties();
        ServletContext context = this.getServletContext();
        Enumeration e = context.getInitParameterNames();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            props.put(name, context.getInitParameter(name));
        }
        e = this.getInitParameterNames();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            props.put(name, this.getInitParameter(name));
        }
        String pythonHomeString = props.getProperty(PYTHON_HOME_PARAM);
        if (pythonHomeString != null) {
            File pythonHome = new File(pythonHomeString);
            if (!pythonHome.isAbsolute()) {
                pythonHomeString = context.getRealPath(pythonHomeString);
            }
            props.setProperty(PYTHON_HOME_PARAM, pythonHomeString);
        }
        return props;
    }

    public void init() throws ServletException {
        try {
            Properties props = this.readConfiguration();
            this.checkSitePackages(props);
            PythonInterpreter.initialize(System.getProperties(), props, new String[0]);
            PySystemState systemState = new PySystemState();
            this.interp = new PythonInterpreter(null, systemState);
            this.setupEnvironment(this.interp, props, systemState);
            try {
                this.interp.exec("from modjy.modjy import modjy_servlet");
            }
            catch (PyException ix) {
                throw new ServletException("Unable to import 'modjy_servlet': maybe you need to set the 'python.home' parameter?", (Throwable)ix);
            }
            PyObject pyServlet = ((PyType)this.interp.get(MODJY_PYTHON_CLASSNAME)).__call__();
            Object temp = pyServlet.__tojava__(HttpServlet.class);
            if (temp == Py.NoConversion) {
                throw new ServletException("Corrupted modjy file: cannot find definition of 'modjy_servlet' class");
            }
            this.modjyServlet = (HttpServlet)temp;
            this.modjyServlet.init((ServletConfig)this);
        }
        catch (PyException pyx) {
            throw new ServletException("Exception creating modjy servlet: " + pyx.toString(), (Throwable)pyx);
        }
    }

    public void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.modjyServlet.service((ServletRequest)req, (ServletResponse)resp);
    }

    public void destroy() {
        this.interp.cleanup();
    }

    protected void setupEnvironment(PythonInterpreter interp, Properties props, PySystemState systemState) throws PyException {
        this.processPythonLib(interp, systemState);
    }

    protected void checkSitePackages(Properties props) throws PyException {
        boolean loadSitePackages = true;
        String loadSitePackagesParam = props.getProperty(LOAD_SITE_PACKAGES_PARAM);
        if (loadSitePackagesParam != null && loadSitePackagesParam.trim().compareTo("0") == 0) {
            loadSitePackages = false;
        }
        Options.importSite = loadSitePackages;
    }

    protected void processPythonLib(PythonInterpreter interp, PySystemState systemState) {
        String[] libPythonContents;
        String pythonLibPath = this.getServletContext().getRealPath(LIB_PYTHON);
        if (pythonLibPath == null) {
            return;
        }
        File pythonLib = new File(pythonLibPath);
        if (!pythonLib.exists()) {
            return;
        }
        systemState.path.append(new PyString(pythonLibPath));
        for (String libPythonContent : libPythonContents = pythonLib.list()) {
            if (!libPythonContent.endsWith(PTH_FILE_EXTENSION)) continue;
            this.processPthFile(interp, systemState, pythonLibPath, libPythonContent);
        }
    }

    protected void processPthFile(PythonInterpreter interp, PySystemState systemState, String pythonLibPath, String pthFilename) {
        try {
            String line;
            LineNumberReader lineReader = new LineNumberReader(new FileReader(new File(pythonLibPath, pthFilename)));
            while ((line = lineReader.readLine()) != null) {
                if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
                if (line.startsWith("import")) {
                    interp.exec(line);
                    continue;
                }
                File archiveFile = new File(pythonLibPath, line);
                String archiveRealpath = archiveFile.getAbsolutePath();
                systemState.path.append(new PyString(archiveRealpath));
            }
        }
        catch (IOException iox) {
            System.err.println("IOException: " + iox.toString());
        }
    }
}

