/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.upgrade.service;

import ai.digital.configuration.central.deploy.ClientProperties;
import com.xebialabs.deployit.core.upgrade.service.BatchUpgraderService;
import com.xebialabs.deployit.engine.spi.artifact.resolution.CannotLocateArtifactException;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.repository.sql.CiRepository;
import com.xebialabs.deployit.repository.sql.TypeNotFoundException;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;

@Component
@ScalaSignature(bytes="\u0006\u0005I4Aa\u0002\u0005\u0001+!A\u0001\u0006\u0001B\u0001B\u0003%\u0011\u0006C\u0003A\u0001\u0011\u0005\u0011\tC\u0005F\u0001\u0001\u0007\t\u0019!C\u0001\r\"IQ\u000b\u0001a\u0001\u0002\u0004%\tA\u0016\u0005\n9\u0002\u0001\r\u0011!Q!\n\u001dCQA\u0018\u0001\u0005B}\u00131\u0004R3gCVdGOQ1uG\",\u0006o\u001a:bI\u0016\u00148+\u001a:wS\u000e,'BA\u0005\u000b\u0003\u001d\u0019XM\u001d<jG\u0016T!a\u0003\u0007\u0002\u000fU\u0004xM]1eK*\u0011QBD\u0001\u0005G>\u0014XM\u0003\u0002\u0010!\u0005AA-\u001a9m_fLGO\u0003\u0002\u0012%\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002'\u0005\u00191m\\7\u0004\u0001M!\u0001A\u0006\u000f!!\t9\"$D\u0001\u0019\u0015\u0005I\u0012!B:dC2\f\u0017BA\u000e\u0019\u0005\u0019\te.\u001f*fMB\u0011QDH\u0007\u0002\u0011%\u0011q\u0004\u0003\u0002\u0015\u0005\u0006$8\r[+qOJ\fG-\u001a:TKJ4\u0018nY3\u0011\u0005\u00052S\"\u0001\u0012\u000b\u0005\r\"\u0013!B:mMRR'\"A\u0013\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!a\n\u0012\u0003\u000f1{wmZ5oO\u0006a1-\u001b*fa>\u001c\u0018\u000e^8ssB\u0011!fL\u0007\u0002W)\u0011A&L\u0001\u0004gFd'B\u0001\u0018\u000f\u0003)\u0011X\r]8tSR|'/_\u0005\u0003a-\u0012AbQ5SKB|7/\u001b;pefD#!\u0001\u001a\u0011\u0005MrT\"\u0001\u001b\u000b\u0005U2\u0014AC1o]>$\u0018\r^5p]*\u0011q\u0007O\u0001\bM\u0006\u001cGo\u001c:z\u0015\tI$(A\u0003cK\u0006t7O\u0003\u0002<y\u0005y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001>\u0003\ry'oZ\u0005\u0003\u007fQ\u0012\u0011\"Q;u_^L'/\u001a3\u0002\rqJg.\u001b;?)\t\u00115\t\u0005\u0002\u001e\u0001!)\u0001F\u0001a\u0001S!\u00121IM\u0001\u0014G2LWM\u001c;D_:4\u0017nZ;sCRLwN\\\u000b\u0002\u000fB\u0011\u0001jU\u0007\u0002\u0013*\u0011!jS\u0001\u0007I\u0016\u0004Hn\\=\u000b\u00051k\u0015aB2f]R\u0014\u0018\r\u001c\u0006\u0003\u001d>\u000bQbY8oM&<WO]1uS>t'B\u0001)R\u0003\u001d!\u0017nZ5uC2T\u0011AU\u0001\u0003C&L!\u0001V%\u0003!\rc\u0017.\u001a8u!J|\u0007/\u001a:uS\u0016\u001c\u0018aF2mS\u0016tGoQ8oM&<WO]1uS>tw\fJ3r)\t9&\f\u0005\u0002\u00181&\u0011\u0011\f\u0007\u0002\u0005+:LG\u000fC\u0004\\\t\u0005\u0005\t\u0019A$\u0002\u0007a$\u0013'\u0001\u000bdY&,g\u000e^\"p]\u001aLw-\u001e:bi&|g\u000e\t\u0015\u0003\u000bI\n1bZ3u\u0005\u0006$8\r[\"jgR\u0019q\u000b\u00194\t\u000b\u00054\u0001\u0019\u00012\u0002\u000bE,XM]=\u0011\u0005\r$W\"A\u0017\n\u0005\u0015l#\u0001E*fCJ\u001c\u0007\u000eU1sC6,G/\u001a:t\u0011\u00159g\u00011\u0001i\u00035\u0011\u0017\r^2i\u0007\u0006dGNY1dWB!q#\u001b2X\u0013\tQ\u0007DA\u0005Gk:\u001cG/[8oc!\u0012\u0001\u0001\u001c\t\u0003[Bl\u0011A\u001c\u0006\u0003_j\n!b\u001d;fe\u0016|G/\u001f9f\u0013\t\thNA\u0005D_6\u0004xN\\3oi\u0002")
public class DefaultBatchUpgraderService
implements BatchUpgraderService,
Logging {
    @Autowired
    private final CiRepository ciRepository;
    @Autowired
    private ClientProperties clientConfiguration;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DefaultBatchUpgraderService defaultBatchUpgraderService = this;
        synchronized (defaultBatchUpgraderService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public ClientProperties clientConfiguration() {
        return this.clientConfiguration;
    }

    public void clientConfiguration_$eq(ClientProperties x$1) {
        this.clientConfiguration = x$1;
    }

    @Override
    public void getBatchCis(SearchParameters query, Function1<SearchParameters, BoxedUnit> batchCallback) {
        int batchSize = this.clientConfiguration().upgradeBatchSize();
        Integer count = this.ciRepository.count(query);
        this.logger().info((Function0 & Serializable)() -> "Running batch migration on " + count + " CIs in batches of " + batchSize + ".");
        IntRef pagesIndexed = IntRef.create((int)0);
        int totalPages = (Predef$.MODULE$.Integer2int(count) + batchSize - 1) / batchSize;
        while (pagesIndexed.elem < totalPages) {
            SearchParameters params = query.setPage((long)pagesIndexed.elem).setResultsPerPage((long)batchSize);
            try {
                Object object;
                try {
                    object = batchCallback.apply((Object)params);
                }
                catch (TypeNotFoundException e) {
                    this.logger().error((Function0 & Serializable)() -> e.getMessage(), (Function0 & Serializable)() -> e.getCause());
                    this.logger().info((Function0 & Serializable)() -> "Skipping page " + pagesIndexed$1.elem + " due to a missed type.");
                    object = BoxedUnit.UNIT;
                }
                catch (CannotLocateArtifactException e) {
                    this.logger().error((Function0 & Serializable)() -> e.getMessage(), (Function0 & Serializable)() -> e.getCause());
                    this.logger().info((Function0 & Serializable)() -> "Skipping page " + pagesIndexed$1.elem + " due to missed artifact.");
                    object = BoxedUnit.UNIT;
                }
                catch (Exception ex) {
                    throw ex;
                }
            }
            finally {
                ++pagesIndexed.elem;
                this.logger().info((Function0 & Serializable)() -> "Completed batch " + pagesIndexed$1.elem + " / total: " + totalPages + ".");
            }
        }
    }

    public DefaultBatchUpgraderService(@Autowired CiRepository ciRepository) {
        this.ciRepository = ciRepository;
        Logging.$init$((Logging)this);
    }
}

