/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.io.copy;

import com.xebialabs.deployit.io.copy.ArchiveOptions;
import com.xebialabs.deployit.io.copy.CopyStrategies$;
import com.xebialabs.deployit.io.copy.CopyStrategy;
import com.xebialabs.deployit.io.copy.NoZipCopy;
import com.xebialabs.deployit.io.copy.ZippedCopy;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.local.LocalFile;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option$;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class CopyStrategies$ {
    public static final CopyStrategies$ MODULE$ = new CopyStrategies$();
    private static final CopyStrategy oneByOne = new NoZipCopy(){

        public void copyZipped(LocalFile src, OverthereFile dest, ArchiveOptions archiveOptions) {
            NoZipCopy.copyZipped$(this, src, dest, archiveOptions);
        }
        {
            NoZipCopy.$init$(this);
        }
    };
    private static final CopyStrategy unzipWindows = new ZippedCopy(){

        public void copyZipped(LocalFile src, OverthereFile dest, ArchiveOptions archiveOptions) {
            ZippedCopy.copyZipped$(this, src, dest, archiveOptions);
        }

        public void extractFolder(String srcFileName, OverthereFile dest, ArchiveOptions archiveOptions, OverthereFile remoteZippedCopy) {
            ZippedCopy.extractFolder$(this, srcFileName, dest, archiveOptions, remoteZippedCopy);
        }

        private CmdLine buildPowershellCommand(OverthereFile zipped, ArchiveOptions archiveOptions) {
            String targetPath = this.getTargetPath(zipped, archiveOptions);
            String escapedZipped = CopyStrategies$.MODULE$.powershellEscape(zipped.getPath());
            String escapedTarget = CopyStrategies$.MODULE$.powershellEscape(targetPath);
            String command = "Expand-Archive -LiteralPath " + escapedZipped + " -Destination " + escapedTarget;
            this.logger().debug((Function0 & Serializable)() -> "encoding powershell command: " + command);
            byte[] bytes = command.getBytes(StandardCharsets.UTF_16LE);
            String encoded = Base64.getEncoder().encodeToString(bytes);
            return CmdLine.build((String[])new String[]{"powershell", "-encodedCommand", encoded});
        }

        public List<CmdLine> unzipCommands(OverthereFile zipped, ArchiveOptions archiveOptions, String srcFileName) {
            return new .colon.colon((Object)this.buildPowershellCommand(zipped, archiveOptions), (List)Nil$.MODULE$);
        }
        {
            ZippedCopy.$init$(this);
        }

        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$buildPowershellCommand$1(java.lang.String )}, serializedLambda);
        }
    };
    private static final CopyStrategy unzipUnix = new ZippedCopy(){

        public void copyZipped(LocalFile src, OverthereFile dest, ArchiveOptions archiveOptions) {
            ZippedCopy.copyZipped$(this, src, dest, archiveOptions);
        }

        public void extractFolder(String srcFileName, OverthereFile dest, ArchiveOptions archiveOptions, OverthereFile remoteZippedCopy) {
            ZippedCopy.extractFolder$(this, srcFileName, dest, archiveOptions, remoteZippedCopy);
        }

        private CmdLine buildUnixUnzipCommand(OverthereFile zipped, ArchiveOptions archiveOptions) {
            String targetPath = this.getTargetPath(zipped, archiveOptions);
            CmdLine cmd = new CmdLine();
            cmd.addArgument("unzip");
            cmd.addArgument(zipped.getPath());
            cmd.addArgument("-d");
            cmd.addArgument(targetPath);
            return cmd;
        }

        public List<CmdLine> unzipCommands(OverthereFile zipped, ArchiveOptions archiveOptions, String srcFileName) {
            if (archiveOptions.isDefault()) {
                return new .colon.colon((Object)CmdLine.build((String[])new String[]{"unzip", zipped.getPath(), "-d", zipped.getParentFile().getPath()}), (List)Nil$.MODULE$);
            }
            return new .colon.colon((Object)this.buildUnixUnzipCommand(zipped, archiveOptions), (List)Nil$.MODULE$);
        }
        {
            ZippedCopy.$init$(this);
        }
    };
    private static final CopyStrategy untar = new ZippedCopy(){

        public void copyZipped(LocalFile src, OverthereFile dest, ArchiveOptions archiveOptions) {
            ZippedCopy.copyZipped$(this, src, dest, archiveOptions);
        }

        public void extractFolder(String srcFileName, OverthereFile dest, ArchiveOptions archiveOptions, OverthereFile remoteZippedCopy) {
            ZippedCopy.extractFolder$(this, srcFileName, dest, archiveOptions, remoteZippedCopy);
        }

        private List<CmdLine> buildTarCommands(OverthereFile zipped, ArchiveOptions archiveOptions, String srcFileName) {
            CmdLine cmd = new CmdLine();
            cmd.addArgument("tar");
            cmd.addArgument("-xf");
            cmd.addArgument(zipped.getPath());
            cmd.addArgument("-C");
            String targetPath = this.getTargetPath(zipped, archiveOptions);
            if (archiveOptions.extractToTargetPath()) {
                cmd.addArgument(targetPath);
                int stripComponents = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)archiveOptions.stripComponents())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
                Object object = stripComponents > 0 ? cmd.addArgument("--strip-components=" + stripComponents) : BoxedUnit.UNIT;
                Option$.MODULE$.apply(archiveOptions.members()).filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)anon.4.$anonfun$buildTarCommands$2(x$2))).foreach((Function1 & Serializable)x$3 -> {
                    anon.4.$anonfun$buildTarCommands$3(cmd, x$3);
                    return BoxedUnit.UNIT;
                });
                return new .colon.colon((Object)cmd, (List)Nil$.MODULE$);
            }
            int stripComponents = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)archiveOptions.stripComponents())).map((Function1)(JFunction1.mcII.sp & Serializable)x$4 -> x$4 + 1).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
            String targetPathIsNotForceArchive = stripComponents > 0 ? zipped.getParentFile().getFile(srcFileName).getPath() : targetPath;
            this.logger().debug((Function0 & Serializable)() -> "folder:deploy:targetPathIsNotForceArchive: " + targetPathIsNotForceArchive);
            cmd.addArgument(targetPathIsNotForceArchive);
            CmdLine mkdirCmd = CmdLine.build((String[])new String[]{"mkdir", targetPathIsNotForceArchive});
            Object object = stripComponents > 0 ? cmd.addArgument("--strip-components=" + stripComponents) : BoxedUnit.UNIT;
            Option$.MODULE$.apply(archiveOptions.members()).filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)anon.4.$anonfun$buildTarCommands$8(x$5))).foreach((Function1 & Serializable)x$6 -> {
                anon.4.$anonfun$buildTarCommands$9(cmd, srcFileName, x$6);
                return BoxedUnit.UNIT;
            });
            if (stripComponents > 0) {
                return new .colon.colon((Object)mkdirCmd, (List)new .colon.colon((Object)cmd, (List)Nil$.MODULE$));
            }
            return new .colon.colon((Object)cmd, (List)Nil$.MODULE$);
        }

        public List<CmdLine> unzipCommands(OverthereFile zipped, ArchiveOptions archiveOptions, String srcFileName) {
            if (archiveOptions.isDefault()) {
                return new .colon.colon((Object)CmdLine.build((String[])new String[]{"tar", "-xf", zipped.getPath(), "-C", zipped.getParentFile().getPath()}), (List)Nil$.MODULE$);
            }
            return this.buildTarCommands(zipped, archiveOptions, srcFileName);
        }

        public static final /* synthetic */ boolean $anonfun$buildTarCommands$2(Set x$2) {
            return x$2.nonEmpty();
        }

        public static final /* synthetic */ void $anonfun$buildTarCommands$3(CmdLine cmd$1, Set x$3) {
            x$3.foreach((Function1 & Serializable)member -> {
                if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(member.trim()))) {
                    return cmd$1.addArgument(member);
                }
                return BoxedUnit.UNIT;
            });
        }

        public static final /* synthetic */ boolean $anonfun$buildTarCommands$8(Set x$5) {
            return x$5.nonEmpty();
        }

        public static final /* synthetic */ void $anonfun$buildTarCommands$9(CmdLine cmd$1, String srcFileName$2, Set x$6) {
            x$6.foreach((Function1 & Serializable)member -> {
                if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(member.trim()))) {
                    return cmd$1.addArgument(String.join((CharSequence)"/", srcFileName$2, member));
                }
                return BoxedUnit.UNIT;
            });
        }
        {
            ZippedCopy.$init$(this);
        }

        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$buildTarCommands$1(), $anonfun$buildTarCommands$10(com.xebialabs.overthere.CmdLine java.lang.String java.lang.String ), $anonfun$buildTarCommands$2$adapted(scala.collection.immutable.Set ), $anonfun$buildTarCommands$3$adapted(com.xebialabs.overthere.CmdLine scala.collection.immutable.Set ), $anonfun$buildTarCommands$4(com.xebialabs.overthere.CmdLine java.lang.String ), $anonfun$buildTarCommands$5(int ), $anonfun$buildTarCommands$6(), $anonfun$buildTarCommands$7(java.lang.String ), $anonfun$buildTarCommands$8$adapted(scala.collection.immutable.Set ), $anonfun$buildTarCommands$9$adapted(com.xebialabs.overthere.CmdLine java.lang.String scala.collection.immutable.Set )}, serializedLambda);
        }
    };

    public CopyStrategy oneByOne() {
        return oneByOne;
    }

    public CopyStrategy unzipWindows() {
        return unzipWindows;
    }

    public String powershellEscape(String str2) {
        String special = "#`'\"";
        return '\"' + (String)StringOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.augmentString(special), (Object)str2, (Function2 & Serializable)(str, c) -> str.replace(String.valueOf(BoxesRunTime.boxToCharacter((char)BoxesRunTime.unboxToChar((Object)c))), "`" + BoxesRunTime.unboxToChar((Object)c))) + '\"';
    }

    public CopyStrategy unzipUnix() {
        return unzipUnix;
    }

    public CopyStrategy untar() {
        return untar;
    }

    private CopyStrategies$() {
    }
}

