/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.artery.aeron;

import io.aeron.Aeron;
import io.aeron.AvailableImageHandler;
import io.aeron.CommonContext;
import io.aeron.Image;
import io.aeron.UnavailableImageHandler;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.ThreadingMode;
import io.aeron.exceptions.ConductorServiceTimeoutException;
import io.aeron.exceptions.DriverTimeoutException;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.nio.channels.DatagramChannel;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.IoUtil;
import org.agrona.concurrent.BackoffIdleStrategy;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.status.CountersReader;
import org.apache.pekko.Done;
import org.apache.pekko.Done$;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.Cancellable;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.dispatch.MessageDispatcher;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.remote.RemoteActorRefProvider;
import org.apache.pekko.remote.RemoteTransportException;
import org.apache.pekko.remote.artery.ArteryTransport;
import org.apache.pekko.remote.artery.ArteryTransport$;
import org.apache.pekko.remote.artery.ArteryTransport$ShuttingDown$;
import org.apache.pekko.remote.artery.Decoder;
import org.apache.pekko.remote.artery.DuplicateFlush;
import org.apache.pekko.remote.artery.DuplicateHandshakeReq;
import org.apache.pekko.remote.artery.EnvelopeBuffer;
import org.apache.pekko.remote.artery.EnvelopeBufferPool;
import org.apache.pekko.remote.artery.FixedSizePartitionHub;
import org.apache.pekko.remote.artery.InboundControlJunction;
import org.apache.pekko.remote.artery.InboundEnvelope;
import org.apache.pekko.remote.artery.OutboundContext;
import org.apache.pekko.remote.artery.aeron.AeronErrorLog;
import org.apache.pekko.remote.artery.aeron.AeronSink;
import org.apache.pekko.remote.artery.aeron.AeronSource;
import org.apache.pekko.remote.artery.aeron.ArteryAeronUdpTransport$;
import org.apache.pekko.remote.artery.aeron.TaskRunner;
import org.apache.pekko.remote.artery.aeron.TaskRunner$;
import org.apache.pekko.remote.artery.compress.NoInboundCompressions$;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.Shape;
import org.apache.pekko.stream.SharedKillSwitch;
import org.apache.pekko.stream.impl.TraversalBuilder;
import org.apache.pekko.stream.scaladsl.Flow$;
import org.apache.pekko.stream.scaladsl.Keep$;
import org.apache.pekko.stream.scaladsl.RunnableGraph;
import org.apache.pekko.stream.scaladsl.Sink;
import org.apache.pekko.stream.scaladsl.Sink$;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.BuildFrom$;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnce;
import scala.collection.MapOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.concurrent.Await$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005}h!\u0002\u0011\"\u0001\u0015j\u0003\"\u0003\u001a\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001b;\u0011%q\u0004A!A!\u0002\u0013y4\tC\u0003F\u0001\u0011\u0005a)\u0002\u0003L\u0001\u0001b\u0005BB*\u0001A\u0003%A\u000bC\u0005#\u0001\u0001\u0007\t\u0011)Q\u0005_\"Iq\u000f\u0001a\u0001\u0002\u0003\u0006K\u0001\u001f\u0005\ny\u0002\u0001\r\u0011!Q!\naD\u0011B \u0001A\u0002\u0003\u0005\u000b\u0015B@\t\u0013\u0005\u001d\u0001A1A\u0005\n\u0005%\u0001\u0002CA\t\u0001\u0001\u0006I!a\u0003\t\u000f\u0005M\u0001\u0001\"\u0003\u0002\u0016!9\u0011Q\u0006\u0001\u0005R\u0005=\u0002bBA\u001c\u0001\u0011%\u0011q\u0006\u0005\b\u0003s\u0001A\u0011BA\u001e\u0011\u001d\t\t\u0006\u0001C\u0005\u0003_Aq!a\u0015\u0001\t\u0013\ty\u0003C\u0004\u0002V\u0001!I!a\f\t\u000f\u0005]\u0003\u0001\"\u0003\u00020!9\u0011\u0011\f\u0001\u0005\n\u0005=\u0002bBA.\u0001\u0011E\u0013Q\f\u0005\b\u0003K\u0003A\u0011BAT\u0011\u001d\tI\f\u0001C\u0005\u0003wCq!!0\u0001\t#\ny\fC\u0004\u0002H\u0002!\t&!3\t\u000f\u0005M\u0007\u0001\"\u0003\u0002V\"9\u0011\u0011\u001c\u0001\u0005\n\u0005m\u0007bBAp\u0001\u0011%\u0011\u0011\u001d\u0005\b\u0003K\u0004A\u0011BAt\u0011\u001d\t\u0019\u0010\u0001C)\u0003kDq!a>\u0001\t\u0003\tIPA\fBeR,'/_!fe>tW\u000b\u001a9Ue\u0006t7\u000f]8si*\u0011!eI\u0001\u0006C\u0016\u0014xN\u001c\u0006\u0003I\u0015\na!\u0019:uKJL(B\u0001\u0014(\u0003\u0019\u0011X-\\8uK*\u0011\u0001&K\u0001\u0006a\u0016\\7n\u001c\u0006\u0003U-\na!\u00199bG\",'\"\u0001\u0017\u0002\u0007=\u0014xm\u0005\u0002\u0001]A\u0011q\u0006M\u0007\u0002G%\u0011\u0011g\t\u0002\u0010\u0003J$XM]=Ue\u0006t7\u000f]8si\u00069ql]=ti\u0016l7\u0001\u0001\t\u0003kaj\u0011A\u000e\u0006\u0003o\u001d\nQ!Y2u_JL!!\u000f\u001c\u0003'\u0015CH/\u001a8eK\u0012\f5\r^8s'f\u001cH/Z7\n\u0005mb\u0014AB:zgR,W.\u0003\u0002>K\ty!+Z7pi\u0016$&/\u00198ta>\u0014H/A\u0005`aJ|g/\u001b3feB\u0011\u0001)Q\u0007\u0002K%\u0011!)\n\u0002\u0017%\u0016lw\u000e^3BGR|'OU3g!J|g/\u001b3fe&\u0011A\tP\u0001\taJ|g/\u001b3fe\u00061A(\u001b8jiz\"2aR%K!\tA\u0005!D\u0001\"\u0011\u0015\u00114\u00011\u00015\u0011\u0015q4\u00011\u0001@\u0005%a\u0015NZ3Ds\u000edW\r\u0005\u0002N!:\u0011\u0001JT\u0005\u0003\u001f\u0006\n1\"Q3s_:\u001cv.\u001e:dK&\u0011\u0011K\u0015\u0002\u000f\u0003\u0016\u0014xN\u001c'jM\u0016\u001c\u0017p\u00197f\u0015\ty\u0015%A\u0006nK\u0012L\u0017\r\u0012:jm\u0016\u0014\bcA+_A6\taK\u0003\u0002X1\u00061\u0011\r^8nS\u000eT!!\u0017.\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002\\9\u0006!Q\u000f^5m\u0015\u0005i\u0016\u0001\u00026bm\u0006L!a\u0018,\u0003\u001f\u0005#x.\\5d%\u00164WM]3oG\u0016\u00042!\u00193g\u001b\u0005\u0011'\"A2\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0014'AB(qi&|g\u000e\u0005\u0002h[6\t\u0001N\u0003\u0002jU\u00061AM]5wKJT!AI6\u000b\u00031\f!![8\n\u00059D'aC'fI&\fGI]5wKJ\u0004\"\u0001]9\u000e\u0003)L!A\u001d6\u0003\u000b\u0005+'o\u001c8)\u0005\u0019!\bCA1v\u0013\t1(M\u0001\u0005w_2\fG/\u001b7f\u0003A\tWM]8o\u0007>,h\u000e^3s)\u0006\u001c8\u000e\u0005\u00026s&\u0011!P\u000e\u0002\f\u0007\u0006t7-\u001a7mC\ndW\r\u000b\u0002\bi\u0006\t\u0012-\u001a:p]\u0016\u0013(o\u001c:M_\u001e$\u0016m]6)\u0005!!\u0018!D1fe>tWI\u001d:pe2{w\rE\u0002I\u0003\u0003I1!a\u0001\"\u00055\tUM]8o\u000bJ\u0014xN\u001d'pO\"\u0012\u0011\u0002^\u0001\u000bi\u0006\u001c8NU;o]\u0016\u0014XCAA\u0006!\rA\u0015QB\u0005\u0004\u0003\u001f\t#A\u0003+bg.\u0014VO\u001c8fe\u0006YA/Y:l%Vtg.\u001a:!\u0003=yW\u000f\u001e2pk:$7\t[1o]\u0016dG\u0003BA\f\u0003G\u0001B!!\u0007\u0002 5\u0011\u00111\u0004\u0006\u0004\u0003;a\u0016\u0001\u00027b]\u001eLA!!\t\u0002\u001c\t11\u000b\u001e:j]\u001eDq!!\n\r\u0001\u0004\t9#A\u0001b!\r)\u0014\u0011F\u0005\u0004\u0003W1$aB!eIJ,7o]\u0001\u000fgR\f'\u000f\u001e+sC:\u001c\bo\u001c:u)\t\t\t\u0004E\u0002b\u0003gI1!!\u000ec\u0005\u0011)f.\u001b;\u0002!M$\u0018M\u001d;NK\u0012L\u0017\r\u0012:jm\u0016\u0014\u0018\u0001C1fe>tG)\u001b:\u0016\u0005\u0005u\u0002\u0003BA \u0003\u001brA!!\u0011\u0002JA\u0019\u00111\t2\u000e\u0005\u0005\u0015#bAA$g\u00051AH]8pizJ1!a\u0013c\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011EA(\u0015\r\tYEY\u0001\u0010gR|\u0007/T3eS\u0006$%/\u001b<fe\u0006Q1\u000f^1si\u0006+'o\u001c8\u0002/\tdwnY6V]RLGn\u00115b]:,G.Q2uSZ,\u0017AE:uCJ$\u0018)\u001a:p]\u0016\u0013(o\u001c:M_\u001e\fAc\u001d;beR\fUM]8o\u0007>,h\u000e^3s\u0019><\u0017!F8vi\n|WO\u001c3Ue\u0006t7\u000f]8siNKgn\u001b\u000b\t\u0003?\n9)!%\u0002\u001cBA\u0011\u0011MA6\u0003_\n)(\u0004\u0002\u0002d)!\u0011QMA4\u0003!\u00198-\u00197bINd'bAA5O\u000511\u000f\u001e:fC6LA!!\u001c\u0002d\t!1+\u001b8l!\ry\u0013\u0011O\u0005\u0004\u0003g\u001a#AD#om\u0016dw\u000e]3Ck\u001a4WM\u001d\t\u0007\u0003o\nY(a \u000e\u0005\u0005e$BA-c\u0013\u0011\ti(!\u001f\u0003\r\u0019+H/\u001e:f!\u0011\t\t)a!\u000e\u0003\u001dJ1!!\"(\u0005\u0011!uN\\3\t\u000f\u0005%U\u00031\u0001\u0002\f\u0006yq.\u001e;c_VtGmQ8oi\u0016DH\u000fE\u00020\u0003\u001bK1!a$$\u0005=yU\u000f\u001e2pk:$7i\u001c8uKb$\bbBAJ+\u0001\u0007\u0011QS\u0001\tgR\u0014X-Y7JIB\u0019\u0011-a&\n\u0007\u0005e%MA\u0002J]RDq!!(\u0016\u0001\u0004\ty*\u0001\u0006ck\u001a4WM\u001d)p_2\u00042aLAQ\u0013\r\t\u0019k\t\u0002\u0013\u000b:4X\r\\8qK\n+hMZ3s!>|G.A\u0006bKJ|gnU8ve\u000e,G\u0003CAU\u0003_\u000b\t,!.\u0011\u000f\u0005\u0005\u00141VA8\u0019&!\u0011QVA2\u0005\u0019\u0019v.\u001e:dK\"9\u00111\u0013\fA\u0002\u0005U\u0005bBAZ-\u0001\u0007\u0011qT\u0001\u0005a>|G\u000eC\u0004\u00028Z\u0001\r!!\u0010\u0002\u001d%t'm\\;oI\u000eC\u0017M\u001c8fY\u0006Y\u0012-\u001a:p]N{WO]2f'BLgN\\5oON#(/\u0019;fOf,\"!!&\u0002%\tLg\u000eZ%oE>,h\u000eZ*ue\u0016\fWn\u001d\u000b\u0003\u0003\u0003\u0004r!YAb\u0003+\u000b)*C\u0002\u0002F\n\u0014a\u0001V;qY\u0016\u0014\u0014!\u0005:v]&s'm\\;oIN#(/Z1ngR1\u0011\u0011GAf\u0003\u001fDq!!4\u001a\u0001\u0004\t)*\u0001\u0003q_J$\bbBAi3\u0001\u0007\u0011QS\u0001\tE&tG\rU8si\u00069\"/\u001e8J]\n|WO\u001c3D_:$(o\u001c7TiJ,\u0017-\u001c\u000b\u0005\u0003c\t9\u000eC\u0004\u00028j\u0001\r!!\u0010\u0002AI,h.\u00138c_VtGm\u0014:eS:\f'/_'fgN\fw-Z:TiJ,\u0017-\u001c\u000b\u0005\u0003c\ti\u000eC\u0004\u00028n\u0001\r!!\u0010\u0002;I,h.\u00138c_VtG\rT1sO\u0016lUm]:bO\u0016\u001c8\u000b\u001e:fC6$B!!\r\u0002d\"9\u0011q\u0017\u000fA\u0002\u0005u\u0012!F;qI\u0006$Xm\u0015;sK\u0006lW*\u0019;WC2,Xm\u001d\u000b\t\u0003c\tI/a;\u0002p\"9\u00111S\u000fA\u0002\u0005U\u0005BBAw;\u0001\u0007A*\u0001\u000bbKJ|gnU8ve\u000e,G*\u001b4fGf\u001cG.\u001a\u0005\b\u0003cl\u0002\u0019AA;\u0003%\u0019w.\u001c9mKR,G-A\ttQV$Hm\\<o)J\fgn\u001d9peR$\"!!\u001e\u0002\u001d\u0005,Ho\\*fY\u0016\u001cG\u000fU8siR!\u0011QSA~\u0011\u001d\tip\ba\u0001\u0003{\t\u0001\u0002[8ti:\fW.\u001a")
public class ArteryAeronUdpTransport
extends ArteryTransport {
    private final AtomicReference<Option<MediaDriver>> mediaDriver = new AtomicReference<None$>(None$.MODULE$);
    public volatile Aeron org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$aeron;
    public volatile Cancellable org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$aeronCounterTask;
    public volatile Cancellable org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$aeronErrorLogTask;
    private volatile AeronErrorLog aeronErrorLog;
    private final TaskRunner org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$taskRunner = new TaskRunner(this.system(), this.settings().Advanced().Aeron().IdleCpuLevel());

    public TaskRunner org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$taskRunner() {
        return this.org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$taskRunner;
    }

    private String outboundChannel(Address a) {
        return new StringBuilder(20).append("aeron:udp?endpoint=").append(a.host().get()).append(":").append(a.port().get()).toString();
    }

    @Override
    public void startTransport() {
        this.startMediaDriver();
        this.startAeron();
        this.startAeronErrorLog();
        this.flightRecorder().transportAeronErrorLogStarted();
        if (this.settings().Advanced().Aeron().LogAeronCounters()) {
            this.startAeronCounterLog();
        }
        this.org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$taskRunner().start();
        this.flightRecorder().transportTaskRunnerStarted();
    }

    private void startMediaDriver() {
        if (this.settings().Advanced().Aeron().EmbeddedMediaDriver()) {
            MediaDriver.Context driverContext = new MediaDriver.Context();
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.settings().Advanced().Aeron().AeronDirectoryName()))) {
                driverContext.aeronDirectoryName(this.settings().Advanced().Aeron().AeronDirectoryName());
            } else {
                String uniquePart = UUID.randomUUID().toString();
                String randomName = new StringBuilder(1).append(CommonContext.getAeronDirectoryName()).append(File.separator).append(this.system().name()).append("-").append(uniquePart).toString();
                driverContext.aeronDirectoryName(randomName);
            }
            driverContext.clientLivenessTimeoutNs(this.settings().Advanced().Aeron().ClientLivenessTimeout().toNanos());
            driverContext.publicationUnblockTimeoutNs(this.settings().Advanced().Aeron().PublicationUnblockTimeout().toNanos());
            driverContext.imageLivenessTimeoutNs(this.settings().Advanced().Aeron().ImageLivenessTimeout().toNanos());
            driverContext.driverTimeoutMs(this.settings().Advanced().Aeron().DriverTimeout().toMillis());
            int idleCpuLevel = this.settings().Advanced().Aeron().IdleCpuLevel();
            if (idleCpuLevel == 10) {
                driverContext.threadingMode(ThreadingMode.DEDICATED).conductorIdleStrategy((IdleStrategy)new BackoffIdleStrategy(1L, 1L, 1L, 1L)).receiverIdleStrategy(TaskRunner$.MODULE$.createIdleStrategy(idleCpuLevel)).senderIdleStrategy(TaskRunner$.MODULE$.createIdleStrategy(idleCpuLevel)).conductorThreadFactory(this.system().threadFactory()).receiverThreadFactory(this.system().threadFactory()).senderThreadFactory(this.system().threadFactory());
            } else if (idleCpuLevel == 1) {
                driverContext.threadingMode(ThreadingMode.SHARED).sharedIdleStrategy(TaskRunner$.MODULE$.createIdleStrategy(idleCpuLevel)).sharedThreadFactory(this.system().threadFactory());
            } else if (idleCpuLevel <= 7) {
                driverContext.threadingMode(ThreadingMode.SHARED_NETWORK).sharedNetworkIdleStrategy(TaskRunner$.MODULE$.createIdleStrategy(idleCpuLevel)).sharedNetworkThreadFactory(this.system().threadFactory()).conductorThreadFactory(this.system().threadFactory());
            } else {
                driverContext.threadingMode(ThreadingMode.DEDICATED).receiverIdleStrategy(TaskRunner$.MODULE$.createIdleStrategy(idleCpuLevel)).senderIdleStrategy(TaskRunner$.MODULE$.createIdleStrategy(idleCpuLevel)).receiverThreadFactory(this.system().threadFactory()).senderThreadFactory(this.system().threadFactory()).conductorThreadFactory(this.system().threadFactory());
            }
            MediaDriver driver = MediaDriver.launchEmbedded((MediaDriver.Context)driverContext);
            this.log().info("Started embedded media driver in directory [{}]", (Object)driver.aeronDirectoryName());
            this.flightRecorder().transportMediaDriverStarted(driver.aeronDirectoryName());
            if (!this.mediaDriver.compareAndSet((Option<MediaDriver>)None$.MODULE$, (Option<MediaDriver>)new Some((Object)driver))) {
                throw new IllegalStateException("media driver started more than once");
            }
            return;
        }
    }

    private String aeronDir() {
        Option<MediaDriver> option = this.mediaDriver.get();
        if (option instanceof Some) {
            return ((MediaDriver)((Some)option).value()).aeronDirectoryName();
        }
        if (None$.MODULE$.equals(option)) {
            return this.settings().Advanced().Aeron().AeronDirectoryName();
        }
        throw new MatchError(option);
    }

    private void stopMediaDriver() {
        this.mediaDriver.getAndSet((Option<MediaDriver>)None$.MODULE$).foreach((Function1 & Serializable)driver -> {
            ArteryAeronUdpTransport.$anonfun$stopMediaDriver$1(this, driver);
            return BoxedUnit.UNIT;
        });
    }

    private void startAeron() {
        Aeron.Context ctx = new Aeron.Context();
        ctx.driverTimeoutMs(this.settings().Advanced().Aeron().DriverTimeout().toMillis());
        ctx.threadFactory(this.system().threadFactory());
        ctx.availableImageHandler(new AvailableImageHandler(this){
            private final /* synthetic */ ArteryAeronUdpTransport $outer;

            public void onAvailableImage(Image img) {
                if (this.$outer.log().isDebugEnabled()) {
                    this.$outer.log().debug(new StringBuilder(31).append("onAvailableImage from ").append(img.sourceIdentity()).append(" session ").append(img.sessionId()).toString());
                    return;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        ctx.unavailableImageHandler(new UnavailableImageHandler(this){
            private final /* synthetic */ ArteryAeronUdpTransport $outer;

            public void onUnavailableImage(Image img) {
                if (this.$outer.log().isDebugEnabled()) {
                    this.$outer.log().debug(new StringBuilder(33).append("onUnavailableImage from ").append(img.sourceIdentity()).append(" session ").append(img.sessionId()).toString());
                }
                ((MapOps)this.$outer.streamMatValues().get()).valuesIterator().foreach((Function1 & Serializable)x0$1 -> {
                    $anon$2.$anonfun$onUnavailableImage$1(img, x0$1);
                    return BoxedUnit.UNIT;
                });
            }

            public static final /* synthetic */ void $anonfun$onUnavailableImage$1(Image img$1, ArteryTransport.InboundStreamMatValues x0$1) {
                if (x0$1 != null) {
                    ((AeronSource.AeronLifecycle)x0$1.lifeCycle()).onUnavailableImage(img$1.sessionId());
                    return;
                }
                throw new MatchError(null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onUnavailableImage$1$adapted(io.aeron.Image org.apache.pekko.remote.artery.ArteryTransport$InboundStreamMatValues )}, serializedLambda);
            }
        });
        ctx.errorHandler(new ErrorHandler(this){
            private final AtomicBoolean fatalErrorOccured;
            private final /* synthetic */ ArteryAeronUdpTransport $outer;

            private AtomicBoolean fatalErrorOccured() {
                return this.fatalErrorOccured;
            }

            public void onError(Throwable cause) {
                if (cause instanceof ConductorServiceTimeoutException) {
                    ConductorServiceTimeoutException conductorServiceTimeoutException = (ConductorServiceTimeoutException)cause;
                    this.handleFatalError((Throwable)conductorServiceTimeoutException);
                    return;
                }
                if (cause instanceof DriverTimeoutException) {
                    DriverTimeoutException driverTimeoutException = (DriverTimeoutException)cause;
                    this.handleFatalError(driverTimeoutException);
                    return;
                }
                if (cause instanceof ArteryTransport.AeronTerminated) {
                    return;
                }
                this.$outer.log().error(cause, new StringBuilder(13).append("Aeron error, ").append(cause).toString());
            }

            private void handleFatalError(Throwable cause) {
                if (this.fatalErrorOccured().compareAndSet(false, true)) {
                    if (!this.$outer.isShutdown()) {
                        this.$outer.log().error(cause, "Fatal Aeron error {}. Have to terminate ActorSystem because it lost contact with the {} Aeron media driver. Possible configuration properties to mitigate the problem are 'client-liveness-timeout' or 'driver-timeout'. {}", (Object)Logging$.MODULE$.simpleName((Object)cause), (Object)(this.$outer.settings().Advanced().Aeron().EmbeddedMediaDriver() ? "embedded" : "external"), (Object)cause);
                        this.$outer.org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$taskRunner().stop();
                        this.$outer.org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$aeronErrorLogTask.cancel();
                        if (this.$outer.settings().Advanced().Aeron().LogAeronCounters()) {
                            this.$outer.org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$aeronCounterTask.cancel();
                        }
                        this.$outer.system().terminate();
                        throw new ArteryTransport.AeronTerminated(cause);
                    }
                    return;
                }
                throw new ArteryTransport.AeronTerminated(cause);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.fatalErrorOccured = new AtomicBoolean();
            }
        });
        ctx.aeronDirectoryName(this.aeronDir());
        this.org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$aeron = Aeron.connect((Aeron.Context)ctx);
    }

    private void blockUntilChannelActive() {
        AeronSource.AeronLifecycle aeronLifecyle = (AeronSource.AeronLifecycle)((ArteryTransport.InboundStreamMatValues)((MapOps)this.streamMatValues().get()).apply((Object)BoxesRunTime.boxToInteger((int)ArteryTransport$.MODULE$.ControlStreamId()))).lifeCycle();
        int waitInterval = 200;
        long retries = package$.MODULE$.max(1L, this.settings().Bind().BindTimeout().toMillis() / (long)waitInterval);
        this.retry$1(retries, aeronLifecyle, waitInterval);
    }

    private void startAeronErrorLog() {
        this.aeronErrorLog = new AeronErrorLog(new File(this.aeronDir(), "cnc.dat"), (LoggingAdapter)this.log());
        AtomicLong lastTimestamp = new AtomicLong(0L);
        MessageDispatcher ec = this.system().dispatchers().internalDispatcher();
        this.org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$aeronErrorLogTask = this.system().scheduler().scheduleWithFixedDelay(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(3)).seconds(), new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(5)).seconds(), () -> {
            if (!this.isShutdown()) {
                long newLastTimestamp = $this.aeronErrorLog.logErrors((LoggingAdapter)this.log(), lastTimestamp.get());
                lastTimestamp.set(newLastTimestamp + 1L);
                return;
            }
        }, (ExecutionContext)ec);
    }

    private void startAeronCounterLog() {
        MessageDispatcher ec = this.system().dispatchers().internalDispatcher();
        this.org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$aeronCounterTask = this.system().scheduler().scheduleWithFixedDelay(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(5)).seconds(), new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(5)).seconds(), () -> {
            if (!this.isShutdown() && this.log().isDebugEnabled()) {
                $this.org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$aeron.countersReader().forEach(new CountersReader.MetaData(this){
                    private final /* synthetic */ ArteryAeronUdpTransport $outer;

                    public void accept(int counterId, int typeId, DirectBuffer keyBuffer, String label) {
                        long value = this.$outer.org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$aeron.countersReader().getCounterValue(counterId);
                        this.$outer.log().debug("Aeron Counter {}: {} {}]", (Object)BoxesRunTime.boxToInteger((int)counterId), (Object)BoxesRunTime.boxToLong((long)value), (Object)label);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                return;
            }
        }, (ExecutionContext)ec);
    }

    @Override
    public Sink<EnvelopeBuffer, Future<Done>> outboundTransportSink(OutboundContext outboundContext, int streamId, EnvelopeBufferPool bufferPool) {
        FiniteDuration giveUpAfter = streamId == ArteryTransport$.MODULE$.ControlStreamId() ? this.settings().Advanced().GiveUpSystemMessageAfter() : this.settings().Advanced().Aeron().GiveUpMessageAfter();
        return Sink$.MODULE$.fromGraph((Graph)new AeronSink(this.outboundChannel(outboundContext.remoteAddress()), streamId, this.org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$aeron, this.org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$taskRunner(), bufferPool, (Duration)giveUpAfter, this.flightRecorder()));
    }

    private Source<EnvelopeBuffer, AeronSource.AeronLifecycle> aeronSource(int streamId, EnvelopeBufferPool pool, String inboundChannel) {
        return Source$.MODULE$.fromGraph((Graph)new AeronSource(inboundChannel, streamId, this.org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$aeron, this.org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$taskRunner(), pool, this.flightRecorder(), this.aeronSourceSpinningStrategy()));
    }

    private int aeronSourceSpinningStrategy() {
        if (this.settings().Advanced().InboundLanes() > 1 || this.settings().Advanced().Aeron().IdleCpuLevel() < 5) {
            return 0;
        }
        return 50 * this.settings().Advanced().Aeron().IdleCpuLevel() - 240;
    }

    @Override
    public Tuple2<Object, Object> bindInboundStreams() {
        int n = this.settings().Bind().Port();
        int n2 = this.settings().Canonical().Port();
        if (0 == n2 && 0 == n) {
            int p = this.autoSelectPort(this.settings().Bind().Hostname());
            return new Tuple2.mcII.sp(p, p);
        }
        if (0 == n2) {
            return new Tuple2.mcII.sp(this.settings().Bind().Port(), this.settings().Bind().Port());
        }
        if (0 == n) {
            return new Tuple2.mcII.sp(this.settings().Canonical().Port(), this.autoSelectPort(this.settings().Bind().Hostname()));
        }
        return new Tuple2.mcII.sp(this.settings().Canonical().Port(), this.settings().Bind().Port());
    }

    @Override
    public void runInboundStreams(int port, int bindPort) {
        String inboundChannel = new StringBuilder(20).append("aeron:udp?endpoint=").append(this.settings().Bind().Hostname()).append(":").append(bindPort).toString();
        this.runInboundControlStream(inboundChannel);
        this.runInboundOrdinaryMessagesStream(inboundChannel);
        if (this.largeMessageChannelEnabled()) {
            this.runInboundLargeMessagesStream(inboundChannel);
        }
        this.blockUntilChannelActive();
    }

    /*
     * WARNING - void declaration
     */
    private void runInboundControlStream(String inboundChannel) {
        void var5_10;
        void var3_8;
        void var4_9;
        void run_materializer;
        void toMat_combine;
        void toMat_sink;
        if (this.isShutdown()) {
            throw ArteryTransport$ShuttingDown$.MODULE$;
        }
        Source source = this.aeronSource(ArteryTransport$.MODULE$.ControlStreamId(), this.envelopeBufferPool(), inboundChannel).via(this.inboundFlow(this.settings(), NoInboundCompressions$.MODULE$));
        Function2 & Serializable intersect = (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (x1$1 != null) {
                InboundControlJunction.ControlMessageSubject c = (InboundControlJunction.ControlMessageSubject)x1$1._1();
                Future d = (Future)x1$1._2();
                return new Tuple3(x0$1, (Object)c, (Object)d);
            }
            throw new MatchError((Object)tuple2);
        };
        Sink<InboundEnvelope, Tuple2<InboundControlJunction.ControlMessageSubject, Future<Done>>> sink = this.inboundControlSink();
        if (source == null) {
            throw null;
        }
        Source toMat_this = source;
        if (toMat_sink == null) {
            throw null;
        }
        Object var6_4 = null;
        sink = null;
        intersect = null;
        Materializer materializer = this.controlMaterializer();
        RunnableGraph run_this = new RunnableGraph((TraversalBuilder)toMat_this.traversalBuilder().append((TraversalBuilder)toMat_sink.traversalBuilder(), (Shape)toMat_sink.shape(), (Function2)toMat_combine));
        Object var9_6 = null;
        materializer = null;
        Tuple3 tuple3 = (Tuple3)run_materializer.materialize((Graph)run_this);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        AeronSource.AeronLifecycle resourceLife = (AeronSource.AeronLifecycle)tuple3._1();
        InboundControlJunction.ControlMessageSubject ctrl = (InboundControlJunction.ControlMessageSubject)tuple3._2();
        Future completed = (Future)tuple3._3();
        this.attachControlMessageObserver((InboundControlJunction.ControlMessageSubject)var4_9);
        this.updateStreamMatValues(ArteryTransport$.MODULE$.ControlStreamId(), (AeronSource.AeronLifecycle)var3_8, (Future<Done>)var5_10);
        this.attachInboundStreamRestart("Inbound control stream", (Future<Done>)var5_10, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.runInboundControlStream(inboundChannel));
    }

    /*
     * WARNING - void declaration
     */
    private void runInboundOrdinaryMessagesStream(String inboundChannel) {
        void var15_25;
        void var13_23;
        void var14_24;
        Tuple3 tuple3;
        Tuple3 tuple32;
        if (this.isShutdown()) {
            throw ArteryTransport$ShuttingDown$.MODULE$;
        }
        if (this.inboundLanes() == 1) {
            void run_materializer;
            void toMat_combine;
            void toMat_sink;
            Source source = this.aeronSource(ArteryTransport$.MODULE$.OrdinaryStreamId(), this.envelopeBufferPool(), inboundChannel).viaMat(this.inboundFlow(this.settings(), this._inboundCompressions()), Keep$.MODULE$.both());
            Function2 & Serializable intersect = (Function2 & Serializable)(x0$1, x1$1) -> {
                Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                if (x0$1 != null) {
                    AeronSource.AeronLifecycle a = (AeronSource.AeronLifecycle)x0$1._1();
                    Decoder.InboundCompressionAccess b = (Decoder.InboundCompressionAccess)x0$1._2();
                    return new Tuple3((Object)a, (Object)b, x1$1);
                }
                throw new MatchError((Object)tuple2);
            };
            Sink<InboundEnvelope, Future<Done>> sink = this.inboundSink(this.envelopeBufferPool());
            if (source == null) {
                throw null;
            }
            Source toMat_this = source;
            if (toMat_sink == null) {
                throw null;
            }
            Object var16_4 = null;
            sink = null;
            intersect = null;
            Materializer materializer = this.materializer();
            RunnableGraph run_this = new RunnableGraph((TraversalBuilder)toMat_this.traversalBuilder().append((TraversalBuilder)toMat_sink.traversalBuilder(), (Shape)toMat_sink.shape(), (Function2)toMat_combine));
            Object var22_6 = null;
            materializer = null;
            tuple32 = (Tuple3)run_materializer.materialize((Graph)run_this);
        } else {
            void var7_16;
            void var6_15;
            void var8_17;
            void run_materializer;
            void toMat_combine;
            void toMat_sink;
            String shared_name = "laneKillSwitch";
            Object var21_7 = null;
            SharedKillSwitch laneKillSwitch = new SharedKillSwitch(shared_name);
            Source laneSource = this.aeronSource(ArteryTransport$.MODULE$.OrdinaryStreamId(), this.envelopeBufferPool(), inboundChannel).via(laneKillSwitch.flow()).viaMat(this.inboundFlow(this.settings(), this._inboundCompressions()), Keep$.MODULE$.both()).via((Graph)Flow$.MODULE$.fromGraph((Graph)new DuplicateHandshakeReq(this.inboundLanes(), this, this.system(), this.envelopeBufferPool()))).via((Graph)Flow$.MODULE$.fromGraph((Graph)new DuplicateFlush(this.inboundLanes(), this.system(), this.envelopeBufferPool())));
            Function2 & Serializable intersect = (Function2 & Serializable)(x0$2, x1$2) -> {
                Tuple2 tuple2 = new Tuple2(x0$2, x1$2);
                if (x0$2 != null) {
                    AeronSource.AeronLifecycle a = (AeronSource.AeronLifecycle)x0$2._1();
                    Decoder.InboundCompressionAccess b = (Decoder.InboundCompressionAccess)x0$2._2();
                    return new Tuple3((Object)a, (Object)b, x1$2);
                }
                throw new MatchError((Object)tuple2);
            };
            Sink sink = Sink$.MODULE$.fromGraph(new FixedSizePartitionHub<InboundEnvelope>(this.inboundLanePartitioner(), this.inboundLanes(), this.settings().Advanced().InboundHubBufferSize()));
            if (laneSource == null) {
                throw null;
            }
            if (toMat_sink == null) {
                throw null;
            }
            sink = null;
            intersect = null;
            Materializer materializer = this.materializer();
            RunnableGraph run_this = new RunnableGraph((TraversalBuilder)laneSource.traversalBuilder().append((TraversalBuilder)toMat_sink.traversalBuilder(), (Shape)toMat_sink.shape(), (Function2)toMat_combine));
            Object var24_13 = null;
            materializer = null;
            Tuple3 tuple33 = (Tuple3)run_materializer.materialize((Graph)run_this);
            if (tuple33 == null) {
                throw new MatchError(null);
            }
            AeronSource.AeronLifecycle resourceLife = (AeronSource.AeronLifecycle)tuple33._1();
            Decoder.InboundCompressionAccess compressionAccess = (Decoder.InboundCompressionAccess)tuple33._2();
            Source laneHub = (Source)tuple33._3();
            Sink<InboundEnvelope, Future<Done>> lane = this.inboundSink(this.envelopeBufferPool());
            Vector completedValues = (Vector)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.inboundLanes()).iterator().map(arg_0 -> ArteryAeronUdpTransport.$anonfun$runInboundOrdinaryMessagesStream$3$adapted(this, (Source)var8_17, lane, arg_0)).to(IterableFactory$.MODULE$.toFactory((IterableFactory)Vector$.MODULE$));
            MessageDispatcher ec = this.system().dispatchers().internalDispatcher();
            Future$.MODULE$.firstCompletedOf((IterableOnce)completedValues, (ExecutionContext)ec).failed().foreach((Function1 & Serializable)reason -> {
                laneKillSwitch.abort(reason);
                return BoxedUnit.UNIT;
            }, (ExecutionContext)ec);
            Future allCompleted = Future$.MODULE$.sequence((IterableOnce)completedValues, BuildFrom$.MODULE$.buildFromIterableOps(), (ExecutionContext)ec).map((Function1 & Serializable)x$8 -> Done$.MODULE$, (ExecutionContext)ec);
            tuple32 = tuple3 = new Tuple3((Object)var6_15, (Object)var7_16, (Object)allCompleted);
        }
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        AeronSource.AeronLifecycle resourceLife = (AeronSource.AeronLifecycle)tuple3._1();
        Decoder.InboundCompressionAccess inboundCompressionAccess = (Decoder.InboundCompressionAccess)tuple3._2();
        Future completed = (Future)tuple3._3();
        this.setInboundCompressionAccess((Decoder.InboundCompressionAccess)var14_24);
        this.updateStreamMatValues(ArteryTransport$.MODULE$.OrdinaryStreamId(), (AeronSource.AeronLifecycle)var13_23, (Future<Done>)var15_25);
        this.attachInboundStreamRestart("Inbound message stream", (Future<Done>)var15_25, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.runInboundOrdinaryMessagesStream(inboundChannel));
    }

    /*
     * WARNING - void declaration
     */
    private void runInboundLargeMessagesStream(String inboundChannel) {
        void var4_6;
        void var3_5;
        void run_materializer;
        if (this.isShutdown()) {
            throw ArteryTransport$ShuttingDown$.MODULE$;
        }
        RunnableGraph runnableGraph = this.aeronSource(ArteryTransport$.MODULE$.LargeStreamId(), this.largeEnvelopeBufferPool(), inboundChannel).via(this.inboundLargeFlow(this.settings())).toMat(this.inboundSink(this.largeEnvelopeBufferPool()), Keep$.MODULE$.both());
        Materializer materializer = this.materializer();
        if (runnableGraph == null) {
            throw null;
        }
        RunnableGraph run_this = runnableGraph;
        Object var5_3 = null;
        materializer = null;
        Tuple2 tuple2 = (Tuple2)run_materializer.materialize((Graph)run_this);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        AeronSource.AeronLifecycle resourceLife = (AeronSource.AeronLifecycle)tuple2._1();
        Future completed = (Future)tuple2._2();
        this.updateStreamMatValues(ArteryTransport$.MODULE$.LargeStreamId(), (AeronSource.AeronLifecycle)var3_5, (Future<Done>)var4_6);
        this.attachInboundStreamRestart("Inbound large message stream", (Future<Done>)var4_6, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.runInboundLargeMessagesStream(inboundChannel));
    }

    private void updateStreamMatValues(int streamId, AeronSource.AeronLifecycle aeronSourceLifecycle, Future<Done> completed) {
        ExecutionContextExecutor ec = this.materializer().executionContext();
        this.updateStreamMatValues(streamId, new ArteryTransport.InboundStreamMatValues<Object>(aeronSourceLifecycle, (Future<Done>)completed.recover((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                return (B1)Done$.MODULE$;
            }

            public final boolean isDefinedAt(Throwable x1) {
                return true;
            }
        }, (ExecutionContext)ec)));
    }

    @Override
    public Future<Done> shutdownTransport() {
        return this.org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$taskRunner().stop().map((Function1 & Serializable)x$11 -> {
            this.flightRecorder().transportStopped();
            if ($this.org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$aeronErrorLogTask != null) {
                $this.org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$aeronErrorLogTask.cancel();
                this.flightRecorder().transportAeronErrorLogTaskStopped();
            }
            if ($this.org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$aeron != null) {
                $this.org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$aeron.close();
            }
            if ($this.aeronErrorLog != null) {
                $this.aeronErrorLog.close();
            }
            if ($this.mediaDriver.get().isDefined()) {
                this.stopMediaDriver();
            }
            return Done$.MODULE$;
        }, (ExecutionContext)this.system().dispatchers().internalDispatcher());
    }

    public int autoSelectPort(String hostname) {
        DatagramSocket socket = DatagramChannel.open().socket();
        socket.bind(new InetSocketAddress(hostname, 0));
        int port = socket.getLocalPort();
        socket.close();
        return port;
    }

    public static final /* synthetic */ void $anonfun$stopMediaDriver$1(ArteryAeronUdpTransport $this, MediaDriver driver) {
        $this.log().info("Stopping embedded media driver in directory [{}]", (Object)driver.aeronDirectoryName());
        try {
            driver.close();
        }
        catch (Throwable throwable) {
            if (NonFatal$.MODULE$.apply(throwable)) {
                $this.log().warning("Couldn't close Aeron embedded media driver due to [{}]", (Object)throwable);
            }
            throw throwable;
        }
        try {
            if ($this.settings().Advanced().Aeron().DeleteAeronDirectory()) {
                IoUtil.delete((File)new File(driver.aeronDirectoryName()), (boolean)false);
                $this.flightRecorder().transportMediaFileDeleted();
            }
        }
        catch (Throwable throwable) {
            if (NonFatal$.MODULE$.apply(throwable)) {
                $this.log().warning("Couldn't delete Aeron embedded media driver files in [{}] due to [{}]", (Object)driver.aeronDirectoryName(), (Object)throwable);
                return;
            }
            throw throwable;
        }
    }

    private final void retry$1(long retries, AeronSource.AeronLifecycle aeronLifecyle$1, int waitInterval$1) {
        while (true) {
            long status;
            if ((status = BoxesRunTime.unboxToLong((Object)Await$.MODULE$.result(aeronLifecyle$1.channelEndpointStatus(), (Duration)this.settings().Bind().BindTimeout()))) == 1L) {
                this.log().debug("Inbound channel is now active");
                return;
            }
            if (status == -1L) {
                this.aeronErrorLog.logErrors((LoggingAdapter)this.log(), 0L);
                this.stopMediaDriver();
                throw new RemoteTransportException("Inbound Aeron channel is in errored state. See Aeron logs for details.");
            }
            if (status != 0L || retries <= 0L) break;
            Thread.sleep(waitInterval$1);
            --retries;
        }
        this.aeronErrorLog.logErrors((LoggingAdapter)this.log(), 0L);
        this.stopMediaDriver();
        throw new RemoteTransportException("Timed out waiting for Aeron transport to bind. See Aeoron logs.");
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Future $anonfun$runInboundOrdinaryMessagesStream$3(ArteryAeronUdpTransport $this, Source laneHub$1, Sink lane$1, int x$7) {
        void run_materializer;
        RunnableGraph runnableGraph = laneHub$1.toMat((Graph)lane$1, Keep$.MODULE$.right());
        Materializer materializer = $this.materializer();
        if (runnableGraph == null) {
            throw null;
        }
        RunnableGraph run_this = runnableGraph;
        return (Future)run_materializer.materialize((Graph)run_this);
    }

    public ArteryAeronUdpTransport(ExtendedActorSystem _system, RemoteActorRefProvider _provider) {
        super(_system, _provider);
    }

    public static final /* synthetic */ Future $anonfun$runInboundOrdinaryMessagesStream$3$adapted(ArteryAeronUdpTransport $this, Source laneHub$1, Sink lane$1, Object x$7) {
        return ArteryAeronUdpTransport.$anonfun$runInboundOrdinaryMessagesStream$3($this, laneHub$1, lane$1, BoxesRunTime.unboxToInt((Object)x$7));
    }
}

