/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.Closeable;
import java.io.Serializable;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.pekko.ConfigurationException;
import org.apache.pekko.actor.Actor$;
import org.apache.pekko.actor.ActorPath;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorRefProvider;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.Cancellable;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.actor.Deploy$;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.Extension;
import org.apache.pekko.actor.ExtensionId;
import org.apache.pekko.actor.Props$;
import org.apache.pekko.actor.RootActorPath;
import org.apache.pekko.actor.Scheduler;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.Cluster$;
import org.apache.pekko.cluster.Cluster$ClusterLogger$;
import org.apache.pekko.cluster.ClusterActorRefProvider;
import org.apache.pekko.cluster.ClusterDaemon;
import org.apache.pekko.cluster.ClusterEvent;
import org.apache.pekko.cluster.ClusterEvent$InitialStateAsSnapshot$;
import org.apache.pekko.cluster.ClusterJmx;
import org.apache.pekko.cluster.ClusterLogClass$;
import org.apache.pekko.cluster.ClusterReadView;
import org.apache.pekko.cluster.ClusterSettings;
import org.apache.pekko.cluster.ClusterSettings$;
import org.apache.pekko.cluster.ClusterUserAction;
import org.apache.pekko.cluster.ClusterUserAction$PrepareForShutdown$;
import org.apache.pekko.cluster.DowningProvider;
import org.apache.pekko.cluster.DowningProvider$;
import org.apache.pekko.cluster.InternalClusterAction;
import org.apache.pekko.cluster.InternalClusterAction$GetClusterCoreRef$;
import org.apache.pekko.cluster.JoinConfigCompatChecker;
import org.apache.pekko.cluster.JoinConfigCompatChecker$;
import org.apache.pekko.cluster.Member;
import org.apache.pekko.cluster.UniqueAddress;
import org.apache.pekko.dispatch.MonitorableThreadFactory;
import org.apache.pekko.event.LogMarker;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.event.MarkerLoggingAdapter;
import org.apache.pekko.japi.Util$;
import org.apache.pekko.pattern.AskSupport;
import org.apache.pekko.pattern.AskableActorRef$;
import org.apache.pekko.remote.AddressUidExtension;
import org.apache.pekko.remote.AddressUidExtension$;
import org.apache.pekko.remote.DefaultFailureDetectorRegistry;
import org.apache.pekko.remote.FailureDetectorLoader$;
import org.apache.pekko.remote.FailureDetectorRegistry;
import org.apache.pekko.util.Timeout;
import org.apache.pekko.util.ccompat.package;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.convert.AsJavaExtensions;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0011\u001dw!\u00024h\u0011\u0003\u0001h!\u0002:h\u0011\u0003\u0019\bbBA\f\u0003\u0011\u0005A\u0011\u0015\u0005\b\tG\u000bA\u0011\tCS\u0011\u001d!\u0019+\u0001C!\t_Cq\u0001\"/\u0002\t\u0003\"Y\fC\u0004\u0005>\u0006!\t\u0005b0\t\u0015\u0011\r\u0017A1A\u0005\u0006\u001d\u0014y\u0003\u0003\u0005\u0005F\u0006\u0001\u000bQ\u0002B\u0019\r\u0015\u0011x\rAA\u0002\u0011)\tY!\u0003BC\u0002\u0013\u0005\u0011Q\u0002\u0005\u000b\u0003+I!\u0011!Q\u0001\n\u0005=\u0001bBA\f\u0013\u0011\u0005\u0011\u0011\u0004\u0005\n\u0003;I!\u0019!C\u0001\u0003?A\u0001\"a\n\nA\u0003%\u0011\u0011\u0005\u0005\n\u0003SI!\u0019!C\u0005\u0003WA\u0001\"a\r\nA\u0003%\u0011Q\u0006\u0005\n\u0003kI!\u0019!C\u0001\u0003oA\u0001\"a\u0010\nA\u0003%\u0011\u0011\b\u0005\b\u0003\u0003JA\u0011AA\"\u0011\u001d\tY%\u0003C\u0001\u0003\u001bBq!a\u001a\n\t\u0003\tI\u0007C\u0004\u0002\b&!\t!!#\t\u0013\u0005e\u0015B1A\u0005\n\u0005m\u0005\u0002CAW\u0013\u0001\u0006I!!(\t\u0013\u0005=\u0016B1A\u0005\n\u0005E\u0006\u0002CA`\u0013\u0001\u0006I!a-\t\u0013\u0005\u0005\u0017\u00021A\u0005\n\u0005\r\u0007\"CAi\u0013\u0001\u0007I\u0011BAj\u0011!\ty.\u0003Q!\n\u0005\u0015\u0007\"CAq\u0013\t\u0007I\u0011AAr\u0011!\t\t0\u0003Q\u0001\n\u0005\u0015\b\"CAz\u0013\t\u0007I\u0011AAr\u0011!\t)0\u0003Q\u0001\n\u0005\u0015\bBCA|\u0013!\u0015\r\u0011\"\u0001\u0002z\"9!\u0011A\u0005\u0005\n\t\r\u0001B\u0003B\u0003\u0013\t\u0007I\u0011A4\u0003\b!A!qB\u0005!\u0002\u0013\u0011I\u0001C\u0005\u0003\u0012%\u0011\r\u0011\"\u0003\u0003\u0014!A!1D\u0005!\u0002\u0013\u0011)\u0002\u0003\u0006\u0003\u001e%\u0011\r\u0011\"\u0001h\u0005'A\u0001Ba\b\nA\u0003%!Q\u0003\u0005\u000b\u0005CI!\u0019!C\u0001O\n\r\u0002\u0002\u0003B\u0016\u0013\u0001\u0006IA!\n\t\u000f\t5\u0012\u0002\"\u0001\u00030!9!qG\u0005\u0005\u0002\te\u0002b\u0002B%\u0013\u0011\u0005!1\n\u0005\b\u0005'JA\u0011\u0001B+\u0011\u001d\u0011\u0019&\u0003C\u0001\u0005#CqAa,\n\t\u0003\u0011\t\fC\u0004\u00030&!\tA!.\t\u000f\t\u0015\u0017\u0002\"\u0001\u0003H\"9!QZ\u0005\u0005\u0002\t=\u0007b\u0002Bk\u0013\u0011\u0005!1\u0001\u0005\b\u0005/LA\u0011\u0002Bm\u0011\u001d\u0011i.\u0003C\u0001\u0005?DqA!8\n\t\u0003\u0011)\u0010C\u0004\u0003\u0000&!\ta!\u0001\t\u000f\r\u0015\u0011\u0002\"\u0001\u0004\b!911B\u0005\u0005\u0002\r5\u0001bBB\u0006\u0013\u0011\u00051\u0011\u0005\u0005\b\u0007gIA\u0011AB\u001b\u0011\u001d\u0019\u0019$\u0003C\u0001\u0007\u0003Bqa!\u0012\n\t\u0003\u00199\u0005\u0003\u0005\u0004T%!\ta\u001aB\u0002\u0011\u001d\u0019\t'\u0003C\u0005\u0005\u00079\u0001ba\u0019\n\u0011\u000397Q\r\u0004\t\u0007SJ\u0001\u0012A4\u0004l!9\u0011qC\"\u0005\u0002\u0011eeaBB5\u0013\u000197q\u000e\u0005\u000b\u0003_+%\u0011!Q\u0001\n\u0005M\u0006bBA\f\u000b\u0012\u00051\u0011\u000f\u0005\b\u0007k*E\u0011\u0001B\u0018\u0011\u001d\u00199(\u0012C\u0001\u0007sBqaa\u001eF\t\u0003\u0019y\bC\u0004\u0004x\u0015#\ta!#\t\u000f\r]T\t\"\u0001\u0004\u0014\"91qT#\u0005\u0002\r\u0005\u0006bBBP\u000b\u0012\u00051Q\u0015\u0005\b\u0007?+E\u0011ABZ\u0011\u001d\u0019y*\u0012C\u0001\u0007sCqaa(F\t\u0003\u0019\t\rC\u0004\u0004 \u0016#\ta!3\t\u000f\r}U\t\"\u0001\u0004T\"91qT#\u0005\u0002\ru\u0007bBBu\u000b\u0012\u000511\u001e\u0005\b\u0007S,E\u0011ABx\u0011\u001d\u0019I/\u0012C\u0001\u0007kDqa!;F\t\u0003\u0019i\u0010C\u0004\u0004j\u0016#\t\u0001\"\u0002\t\u000f\r%X\t\"\u0001\u0005\u0010!9A\u0011D#\u0005\u0002\u0011m\u0001b\u0002C\r\u000b\u0012\u0005Aq\u0004\u0005\b\t3)E\u0011\u0001C\u0013\u0011\u001d!I\"\u0012C\u0001\tWAq\u0001\"\u0007F\t\u0003!\u0019\u0004C\u0004\u0005\u001a\u0015#\t\u0001\"\u0010\t\u000f\u0011eQ\t\"\u0001\u0005X!9A\u0011D#\u0005\u0002\u0011}\u0003b\u0002C\r\u000b\u0012\u0005A\u0011\u000e\u0005\b\tk*E\u0011\u0002C<\u0011\u001d!)(\u0012C\u0005\t#\u000bqa\u00117vgR,'O\u0003\u0002iS\u000691\r\\;ti\u0016\u0014(B\u00016l\u0003\u0015\u0001Xm[6p\u0015\taW.\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002]\u0006\u0019qN]4\u0004\u0001A\u0011\u0011/A\u0007\u0002O\n91\t\\;ti\u0016\u00148#B\u0001uu\u0012m\u0005CA;y\u001b\u00051(\"A<\u0002\u000bM\u001c\u0017\r\\1\n\u0005e4(AB!osJ+g\r\u0005\u0003|}\u0006\u0005Q\"\u0001?\u000b\u0005uL\u0017!B1di>\u0014\u0018BA@}\u0005-)\u0005\u0010^3og&|g.\u00133\u0011\u0005EL1\u0003B\u0005u\u0003\u000b\u00012a_A\u0004\u0013\r\tI\u0001 \u0002\n\u000bb$XM\\:j_:\faa]=ti\u0016lWCAA\b!\rY\u0018\u0011C\u0005\u0004\u0003'a(aE#yi\u0016tG-\u001a3BGR|'oU=ti\u0016l\u0017aB:zgR,W\u000eI\u0001\u0007y%t\u0017\u000e\u001e \u0015\t\u0005\u0005\u00111\u0004\u0005\b\u0003\u0017a\u0001\u0019AA\b\u0003!\u0019X\r\u001e;j]\u001e\u001cXCAA\u0011!\r\t\u00181E\u0005\u0004\u0003K9'aD\"mkN$XM]*fiRLgnZ:\u0002\u0013M,G\u000f^5oON\u0004\u0013a\u00066pS:\u001cuN\u001c4jO\u000e{W\u000e]1u\u0007\",7m[3s+\t\ti\u0003E\u0002r\u0003_I1!!\rh\u0005]Qu.\u001b8D_:4\u0017nZ\"p[B\fGo\u00115fG.,'/\u0001\rk_&t7i\u001c8gS\u001e\u001cu.\u001c9bi\u000eCWmY6fe\u0002\n\u0011c]3mMVs\u0017.];f\u0003\u0012$'/Z:t+\t\tI\u0004E\u0002r\u0003wI1!!\u0010h\u00055)f.[9vK\u0006#GM]3tg\u0006\u00112/\u001a7g+:L\u0017/^3BI\u0012\u0014Xm]:!\u0003-\u0019X\r\u001c4BI\u0012\u0014Xm]:\u0016\u0005\u0005\u0015\u0003cA>\u0002H%\u0019\u0011\u0011\n?\u0003\u000f\u0005#GM]3tg\u0006q1/\u001a7g\t\u0006$\u0018mQ3oi\u0016\u0014XCAA(!\u0011\t\t&!\u0019\u000f\t\u0005M\u0013Q\f\b\u0005\u0003+\nYF\u0004\u0003\u0002X\u0005eS\"A6\n\u0005)\\\u0017B\u00015j\u0013\r\tyfZ\u0001\u0010\u00072,8\u000f^3s'\u0016$H/\u001b8hg&!\u00111MA3\u0005)!\u0015\r^1DK:$XM\u001d\u0006\u0004\u0003?:\u0017!C:fY\u001a\u0014v\u000e\\3t+\t\tY\u0007\u0005\u0004\u0002n\u0005m\u0014\u0011\u0011\b\u0005\u0003_\n9\bE\u0002\u0002rYl!!a\u001d\u000b\u0007\u0005Ut.\u0001\u0004=e>|GOP\u0005\u0004\u0003s2\u0018A\u0002)sK\u0012,g-\u0003\u0003\u0002~\u0005}$aA*fi*\u0019\u0011\u0011\u0010<\u0011\t\u00055\u00141Q\u0005\u0005\u0003\u000b\u000byH\u0001\u0004TiJLgnZ\u0001\rO\u0016$8+\u001a7g%>dWm]\u000b\u0003\u0003\u0017\u0003b!!$\u0002\u0018\u0006\u0005UBAAH\u0015\u0011\t\t*a%\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003+\u000bAA[1wC&!\u0011QPAH\u00035y\u0016n\u001d+fe6Lg.\u0019;fIV\u0011\u0011Q\u0014\t\u0005\u0003?\u000bI+\u0004\u0002\u0002\"*!\u00111UAS\u0003\u0019\tGo\\7jG*!\u0011qUAH\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0003W\u000b\tKA\u0007Bi>l\u0017n\u0019\"p_2,\u0017M\\\u0001\u000f?&\u001cH+\u001a:nS:\fG/\u001a3!\u0003\rawnZ\u000b\u0003\u0003g\u0003B!!.\u0002<6\u0011\u0011q\u0017\u0006\u0004\u0003sK\u0017!B3wK:$\u0018\u0002BA_\u0003o\u0013A#T1sW\u0016\u0014Hj\\4hS:<\u0017\tZ1qi\u0016\u0014\u0018\u0001\u00027pO\u0002\n!b\u00197vgR,'OS7y+\t\t)\rE\u0003v\u0003\u000f\fY-C\u0002\u0002JZ\u0014aa\u00149uS>t\u0007cA9\u0002N&\u0019\u0011qZ4\u0003\u0015\rcWo\u001d;fe*k\u00070\u0001\bdYV\u001cH/\u001a:K[b|F%Z9\u0015\t\u0005U\u00171\u001c\t\u0004k\u0006]\u0017bAAmm\n!QK\\5u\u0011%\ti\u000eHA\u0001\u0002\u0004\t)-A\u0002yIE\n1b\u00197vgR,'OS7yA\u0005ya-Y5mkJ,G)\u001a;fGR|'/\u0006\u0002\u0002fB1\u0011q]Aw\u0003\u000bj!!!;\u000b\u0007\u0005-\u0018.\u0001\u0004sK6|G/Z\u0005\u0005\u0003_\fIOA\fGC&dWO]3EKR,7\r^8s%\u0016<\u0017n\u001d;ss\u0006\u0001b-Y5mkJ,G)\u001a;fGR|'\u000fI\u0001\u0017GJ|7o\u001d#d\r\u0006LG.\u001e:f\t\u0016$Xm\u0019;pe\u000692M]8tg\u0012\u001bg)Y5mkJ,G)\u001a;fGR|'\u000fI\u0001\u0010I><h.\u001b8h!J|g/\u001b3feV\u0011\u00111 \t\u0004c\u0006u\u0018bAA\u0000O\nyAi\\<oS:<\u0007K]8wS\u0012,'/\u0001\ndQ\u0016\u001c7.Q;u_\u0012{wO\\+tC\u001e,GCAAk\u0003%\u00198\r[3ek2,'/\u0006\u0002\u0003\nA\u00191Pa\u0003\n\u0007\t5APA\u0005TG\",G-\u001e7fe\u0006Q1o\u00195fIVdWM\u001d\u0011\u0002\u001d\rdWo\u001d;fe\u0012\u000bW-\\8ogV\u0011!Q\u0003\t\u0004w\n]\u0011b\u0001B\ry\nA\u0011i\u0019;peJ+g-A\bdYV\u001cH/\u001a:EC\u0016lwN\\:!\u0003-\u0019G.^:uKJ\u001cuN]3\u0002\u0019\rdWo\u001d;fe\u000e{'/\u001a\u0011\u0002\u0011I,\u0017\r\u001a,jK^,\"A!\n\u0011\u0007E\u00149#C\u0002\u0003*\u001d\u0014qb\u00117vgR,'OU3bIZKWm^\u0001\ne\u0016\fGMV5fo\u0002\nA\"[:UKJl\u0017N\\1uK\u0012,\"A!\r\u0011\u0007U\u0014\u0019$C\u0002\u00036Y\u0014qAQ8pY\u0016\fg.A\u0003ti\u0006$X-\u0006\u0002\u0003<A!!Q\bB\"\u001d\r\t(qH\u0005\u0004\u0005\u0003:\u0017\u0001D\"mkN$XM]#wK:$\u0018\u0002\u0002B#\u0005\u000f\u00121cQ;se\u0016tGo\u00117vgR,'o\u0015;bi\u0016T1A!\u0011h\u0003)\u0019X\r\u001c4NK6\u0014WM]\u000b\u0003\u0005\u001b\u00022!\u001dB(\u0013\r\u0011\tf\u001a\u0002\u0007\u001b\u0016l'-\u001a:\u0002\u0013M,(m]2sS\n,GCBAk\u0005/\u0012Y\u0006C\u0004\u0003Z=\u0002\rA!\u0006\u0002\u0015M,(m]2sS\n,'\u000fC\u0004\u0003^=\u0002\rAa\u0018\u0002\u0005Q|\u0007#B;\u0003b\t\u0015\u0014b\u0001B2m\nQAH]3qK\u0006$X\r\u001a 1\t\t\u001d$\u0011\u000f\t\u0007\u0003[\u0012IG!\u001c\n\t\t-\u0014q\u0010\u0002\u0006\u00072\f7o\u001d\t\u0005\u0005_\u0012\t\b\u0004\u0001\u0005\u0019\tM$1LA\u0001\u0002\u0003\u0015\tA!\u001e\u0003\u0007}#\u0013'\u0005\u0003\u0003x\tu\u0004cA;\u0003z%\u0019!1\u0010<\u0003\u000f9{G\u000f[5oOB\u0019QOa \n\u0007\t\u0005eOA\u0002B]fD3a\fBC!\u0011\u00119I!$\u000e\u0005\t%%b\u0001BFm\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t=%\u0011\u0012\u0002\bm\u0006\u0014\u0018M]4t)!\t)Na%\u0003\u0016\n}\u0005b\u0002B-a\u0001\u0007!Q\u0003\u0005\b\u0005/\u0003\u0004\u0019\u0001BM\u0003AIg.\u001b;jC2\u001cF/\u0019;f\u001b>$W\r\u0005\u0003\u0003>\tm\u0015\u0002\u0002BO\u0005\u000f\u0012AdU;cg\u000e\u0014\u0018\u000e\u001d;j_:Le.\u001b;jC2\u001cF/\u0019;f\u001b>$W\rC\u0004\u0003^A\u0002\rA!)\u0011\u000bU\u0014\tGa)1\t\t\u0015&\u0011\u0016\t\u0007\u0003[\u0012IGa*\u0011\t\t=$\u0011\u0016\u0003\r\u0005W\u0013y*!A\u0001\u0002\u000b\u0005!Q\u000f\u0002\u0004?\u0012\u0012\u0004f\u0001\u0019\u0003\u0006\u0006YQO\\:vEN\u001c'/\u001b2f)\u0011\t)Na-\t\u000f\te\u0013\u00071\u0001\u0003\u0016Q1\u0011Q\u001bB\\\u0005sCqA!\u00173\u0001\u0004\u0011)\u0002C\u0004\u0003^I\u0002\rAa/1\t\tu&\u0011\u0019\t\u0007\u0003[\u0012IGa0\u0011\t\t=$\u0011\u0019\u0003\r\u0005\u0007\u0014I,!A\u0001\u0002\u000b\u0005!Q\u000f\u0002\u0004?\u0012\u001a\u0014aF:f]\u0012\u001cUO\u001d:f]R\u001cE.^:uKJ\u001cF/\u0019;f)\u0011\t)N!3\t\u000f\t-7\u00071\u0001\u0003\u0016\u0005A!/Z2fSZ,'/\u0001\u0003k_&tG\u0003BAk\u0005#DqAa55\u0001\u0004\t)%A\u0004bI\u0012\u0014Xm]:\u0002;A\u0014X\r]1sK\u001a{'OR;mY\u000ecWo\u001d;feNCW\u000f\u001e3po:\f\u0011BZ5mY2{7-\u00197\u0015\t\u0005\u0015#1\u001c\u0005\b\u0005'4\u0004\u0019AA#\u00035Qw.\u001b8TK\u0016$gj\u001c3fgR!\u0011Q\u001bBq\u0011\u001d\u0011\u0019o\u000ea\u0001\u0005K\f\u0011b]3fI:{G-Z:\u0011\r\t\u001d(\u0011_A#\u001b\t\u0011IO\u0003\u0003\u0003l\n5\u0018!C5n[V$\u0018M\u00197f\u0015\r\u0011yO^\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002Bz\u0005S\u00141aU3r)\u0011\t)Na>\t\u000f\t\r\b\b1\u0001\u0003zB1\u0011Q\u0012B~\u0003\u000bJAA!@\u0002\u0010\n!A*[:u\u0003\u0015aW-\u0019<f)\u0011\t)na\u0001\t\u000f\tM\u0017\b1\u0001\u0002F\u0005!Am\\<o)\u0011\t)n!\u0003\t\u000f\tM'\b1\u0001\u0002F\u0005\u0011\"/Z4jgR,'o\u00148NK6\u0014WM]+q+\u0011\u0019ya!\b\u0015\t\u0005U7\u0011\u0003\u0005\t\u0007'YD\u00111\u0001\u0004\u0016\u0005!1m\u001c3f!\u0015)8qCB\u000e\u0013\r\u0019IB\u001e\u0002\ty\tLh.Y7f}A!!qNB\u000f\t\u001d\u0019yb\u000fb\u0001\u0005k\u0012\u0011\u0001\u0016\u000b\u0005\u0003+\u001c\u0019\u0003C\u0004\u0004&q\u0002\raa\n\u0002\u0011\r\fG\u000e\u001c2bG.\u0004Ba!\u000b\u000405\u001111\u0006\u0006\u0005\u0007[\t\u0019*\u0001\u0003mC:<\u0017\u0002BB\u0019\u0007W\u0011\u0001BU;o]\u0006\u0014G.Z\u0001\u0018e\u0016<\u0017n\u001d;fe>sW*Z7cKJ\u0014V-\\8wK\u0012,Baa\u000e\u0004@Q!\u0011Q[B\u001d\u0011!\u0019\u0019\"\u0010CA\u0002\rm\u0002#B;\u0004\u0018\ru\u0002\u0003\u0002B8\u0007\u007f!qaa\b>\u0005\u0004\u0011)\b\u0006\u0003\u0002V\u000e\r\u0003bBB\u0013}\u0001\u00071qE\u0001\re\u0016lw\u000e^3QCRDwJ\u001a\u000b\u0005\u0007\u0013\u001ay\u0005E\u0002|\u0007\u0017J1a!\u0014}\u0005%\t5\r^8s!\u0006$\b\u000eC\u0004\u0004R}\u0002\rA!\u0006\u0002\u0011\u0005\u001cGo\u001c:SK\u001a\f\u0001b\u001d5vi\u0012|wO\u001c\u0015\u0004\u0001\u000e]\u0003\u0003BB-\u0007;j!aa\u0017\u000b\u0007\t-\u0015.\u0003\u0003\u0004`\rm#aC%oi\u0016\u0014h.\u00197Ba&\fab\u00197pg\u0016\u001c6\r[3ek2,'/A\u0007DYV\u001cH/\u001a:M_\u001e<WM\u001d\t\u0004\u0007O\u001aU\"A\u0005\u0003\u001b\rcWo\u001d;fe2{wmZ3s'\r\u00195Q\u000e\t\u0004\u0007O*5CA#u)\u0011\u0019iga\u001d\t\u000f\u0005=v\t1\u0001\u00024\u0006q\u0011n\u001d#fEV<WI\\1cY\u0016$\u0017\u0001\u00037pO\u0012+'-^4\u0015\t\u0005U71\u0010\u0005\b\u0007{J\u0005\u0019AAA\u0003\u001diWm]:bO\u0016$b!!6\u0004\u0002\u000e\u0015\u0005bBBB\u0015\u0002\u0007\u0011\u0011Q\u0001\ti\u0016l\u0007\u000f\\1uK\"91q\u0011&A\u0002\tu\u0014\u0001B1sOF\"\u0002\"!6\u0004\f\u000e55q\u0012\u0005\b\u0007\u0007[\u0005\u0019AAA\u0011\u001d\u00199i\u0013a\u0001\u0005{Bqa!%L\u0001\u0004\u0011i(\u0001\u0003be\u001e\u0014DCCAk\u0007+\u001b9j!'\u0004\u001c\"911\u0011'A\u0002\u0005\u0005\u0005bBBD\u0019\u0002\u0007!Q\u0010\u0005\b\u0007#c\u0005\u0019\u0001B?\u0011\u001d\u0019i\n\u0014a\u0001\u0005{\nA!\u0019:hg\u00059An\\4J]\u001a|G\u0003BAk\u0007GCqa! N\u0001\u0004\t\t\t\u0006\u0004\u0002V\u000e\u001d6\u0011\u0017\u0005\b\u0007Ss\u0005\u0019ABV\u0003\u0019i\u0017M]6feB!\u0011QWBW\u0013\u0011\u0019y+a.\u0003\u00131{w-T1sW\u0016\u0014\bbBB?\u001d\u0002\u0007\u0011\u0011\u0011\u000b\u0007\u0003+\u001c)la.\t\u000f\r\ru\n1\u0001\u0002\u0002\"91qQ(A\u0002\tuD\u0003CAk\u0007w\u001bila0\t\u000f\r%\u0006\u000b1\u0001\u0004,\"911\u0011)A\u0002\u0005\u0005\u0005bBBD!\u0002\u0007!Q\u0010\u000b\t\u0003+\u001c\u0019m!2\u0004H\"911Q)A\u0002\u0005\u0005\u0005bBBD#\u0002\u0007!Q\u0010\u0005\b\u0007#\u000b\u0006\u0019\u0001B?))\t)na3\u0004N\u000e=7\u0011\u001b\u0005\b\u0007S\u0013\u0006\u0019ABV\u0011\u001d\u0019\u0019I\u0015a\u0001\u0003\u0003Cqaa\"S\u0001\u0004\u0011i\bC\u0004\u0004\u0012J\u0003\rA! \u0015\u0015\u0005U7Q[Bl\u00073\u001cY\u000eC\u0004\u0004\u0004N\u0003\r!!!\t\u000f\r\u001d5\u000b1\u0001\u0003~!91\u0011S*A\u0002\tu\u0004bBBO'\u0002\u0007!Q\u0010\u000b\r\u0003+\u001cyn!9\u0004d\u000e\u00158q\u001d\u0005\b\u0007S#\u0006\u0019ABV\u0011\u001d\u0019\u0019\t\u0016a\u0001\u0003\u0003Cqaa\"U\u0001\u0004\u0011i\bC\u0004\u0004\u0012R\u0003\rA! \t\u000f\ruE\u000b1\u0001\u0003~\u0005QAn\\4XCJt\u0017N\\4\u0015\t\u0005U7Q\u001e\u0005\b\u0007{*\u0006\u0019AAA)\u0019\t)n!=\u0004t\"911\u0011,A\u0002\u0005\u0005\u0005bBBD-\u0002\u0007!Q\u0010\u000b\t\u0003+\u001c9p!?\u0004|\"91\u0011V,A\u0002\r-\u0006bBBB/\u0002\u0007\u0011\u0011\u0011\u0005\b\u0007\u000f;\u0006\u0019\u0001B?)!\t)na@\u0005\u0002\u0011\r\u0001bBBB1\u0002\u0007\u0011\u0011\u0011\u0005\b\u0007\u000fC\u0006\u0019\u0001B?\u0011\u001d\u0019\t\n\u0017a\u0001\u0005{\"\"\"!6\u0005\b\u0011%A1\u0002C\u0007\u0011\u001d\u0019I+\u0017a\u0001\u0007WCqaa!Z\u0001\u0004\t\t\tC\u0004\u0004\bf\u0003\rA! \t\u000f\rE\u0015\f1\u0001\u0003~QQ\u0011Q\u001bC\t\t'!)\u0002b\u0006\t\u000f\r\r%\f1\u0001\u0002\u0002\"91q\u0011.A\u0002\tu\u0004bBBI5\u0002\u0007!Q\u0010\u0005\b\u0007;S\u0006\u0019\u0001B?\u0003!awnZ#se>\u0014H\u0003BAk\t;Aqa! \\\u0001\u0004\t\t\t\u0006\u0004\u0002V\u0012\u0005B1\u0005\u0005\b\u0007Sc\u0006\u0019ABV\u0011\u001d\u0019i\b\u0018a\u0001\u0003\u0003#b!!6\u0005(\u0011%\u0002bBBB;\u0002\u0007\u0011\u0011\u0011\u0005\b\u0007\u000fk\u0006\u0019\u0001B?)!\t)\u000e\"\f\u00050\u0011E\u0002bBBB=\u0002\u0007\u0011\u0011\u0011\u0005\b\u0007\u000fs\u0006\u0019\u0001B?\u0011\u001d\u0019\tJ\u0018a\u0001\u0005{\"\"\"!6\u00056\u0011]B\u0011\bC\u001e\u0011\u001d\u0019\u0019i\u0018a\u0001\u0003\u0003Cqaa\"`\u0001\u0004\u0011i\bC\u0004\u0004\u0012~\u0003\rA! \t\u000f\ruu\f1\u0001\u0003~Q1\u0011Q\u001bC \t+Bq\u0001\"\u0011a\u0001\u0004!\u0019%A\u0003dCV\u001cX\r\u0005\u0003\u0005F\u0011=c\u0002\u0002C$\t\u0017rA!!\u001d\u0005J%\tq/C\u0002\u0005NY\fq\u0001]1dW\u0006<W-\u0003\u0003\u0005R\u0011M#!\u0003+ie><\u0018M\u00197f\u0015\r!iE\u001e\u0005\b\u0007{\u0002\u0007\u0019AAA)!\t)\u000e\"\u0017\u0005\\\u0011u\u0003b\u0002C!C\u0002\u0007A1\t\u0005\b\u0007\u0007\u000b\u0007\u0019AAA\u0011\u001d\u00199)\u0019a\u0001\u0005{\"\"\"!6\u0005b\u0011\rDQ\rC4\u0011\u001d!\tE\u0019a\u0001\t\u0007Bqaa!c\u0001\u0004\t\t\tC\u0004\u0004\b\n\u0004\rA! \t\u000f\rE%\r1\u0001\u0003~Qa\u0011Q\u001bC6\t[\"y\u0007\"\u001d\u0005t!9A\u0011I2A\u0002\u0011\r\u0003bBBBG\u0002\u0007\u0011\u0011\u0011\u0005\b\u0007\u000f\u001b\u0007\u0019\u0001B?\u0011\u001d\u0019\tj\u0019a\u0001\u0005{Bqa!(d\u0001\u0004\u0011i(\u0001\u0006m_\u001e\fE\u000fT3wK2$b!!6\u0005z\u0011=\u0005b\u0002C>I\u0002\u0007AQP\u0001\tY><G*\u001a<fYB!Aq\u0010CE\u001d\u0011!\t\t\"\"\u000f\t\u0005UC1Q\u0005\u0004\u0003sK\u0017\u0002\u0002CD\u0003o\u000bq\u0001T8hO&tw-\u0003\u0003\u0005\f\u00125%\u0001\u0003'pO2+g/\u001a7\u000b\t\u0011\u001d\u0015q\u0017\u0005\b\u0007{\"\u0007\u0019AAA)!\t)\u000eb%\u0005\u0016\u0012]\u0005bBBUK\u0002\u000711\u0016\u0005\b\tw*\u0007\u0019\u0001C?\u0011\u001d\u0019i(\u001aa\u0001\u0003\u0003#\"a!\u001a\u0011\u0007m$i*C\u0002\u0005 r\u00141#\u0012=uK:\u001c\u0018n\u001c8JIB\u0013xN^5eKJ$\u0012\u0001]\u0001\u0004O\u0016$H\u0003BA\u0001\tOCq!a\u0003\u0004\u0001\u0004!I\u000bE\u0002|\tWK1\u0001\",}\u0005-\t5\r^8s'f\u001cH/Z7\u0015\t\u0005\u0005A\u0011\u0017\u0005\b\u0003\u0017!\u0001\u0019\u0001CZ!\rYHQW\u0005\u0004\toc(AG\"mCN\u001c\u0018nY!di>\u00148+_:uK6\u0004&o\u001c<jI\u0016\u0014\u0018A\u00027p_.,\b/F\u0001q\u0003=\u0019'/Z1uK\u0016CH/\u001a8tS>tG\u0003BA\u0001\t\u0003Dq!a\u0003\u0007\u0001\u0004\ty!A\rjg\u0006\u001b8/\u001a:u\u0013:4\u0018M]5b]R\u001cXI\\1cY\u0016$\u0017AG5t\u0003N\u001cXM\u001d;J]Z\f'/[1oiN,e.\u00192mK\u0012\u0004\u0003")
public class Cluster
implements Extension {
    private DowningProvider downingProvider;
    private volatile Cluster$ClusterLogger$ ClusterLogger$module;
    private final ExtendedActorSystem system;
    private final ClusterSettings settings;
    private final JoinConfigCompatChecker joinConfigCompatChecker;
    private final UniqueAddress selfUniqueAddress;
    private final AtomicBoolean _isTerminated;
    private final MarkerLoggingAdapter org$apache$pekko$cluster$Cluster$$log;
    private Option<ClusterJmx> clusterJmx;
    private final FailureDetectorRegistry<Address> failureDetector;
    private final FailureDetectorRegistry<Address> crossDcFailureDetector;
    private final Scheduler scheduler;
    private final ActorRef clusterDaemons;
    private final ActorRef clusterCore;
    private final ClusterReadView readView;
    private volatile boolean bitmap$0;

    public static Cluster createExtension(ExtendedActorSystem system) {
        return new Cluster(system);
    }

    public static Cluster$ lookup() {
        return Cluster$.MODULE$;
    }

    public static Cluster get(ClassicActorSystemProvider system) {
        return (Cluster)ExtensionId.get$((ExtensionId)Cluster$.MODULE$, (ClassicActorSystemProvider)system);
    }

    public static Cluster get(ActorSystem system) {
        return (Cluster)ExtensionId.get$((ExtensionId)Cluster$.MODULE$, (ActorSystem)system);
    }

    public static Extension apply(ClassicActorSystemProvider system) {
        return ExtensionId.apply$((ExtensionId)Cluster$.MODULE$, (ClassicActorSystemProvider)system);
    }

    public static Extension apply(ActorSystem system) {
        return ExtensionId.apply$((ExtensionId)Cluster$.MODULE$, (ActorSystem)system);
    }

    public Cluster$ClusterLogger$ ClusterLogger() {
        if (this.ClusterLogger$module == null) {
            this.ClusterLogger$lzycompute$1();
        }
        return this.ClusterLogger$module;
    }

    public void subscribe(ActorRef subscriber, Class<?> ... to) {
        this.subscribe(subscriber, (Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])to));
    }

    public void subscribe(ActorRef subscriber, ClusterEvent.SubscriptionInitialStateMode initialStateMode, Class<?> ... to) {
        this.subscribe(subscriber, initialStateMode, (Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])to));
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public ClusterSettings settings() {
        return this.settings;
    }

    private JoinConfigCompatChecker joinConfigCompatChecker() {
        return this.joinConfigCompatChecker;
    }

    public UniqueAddress selfUniqueAddress() {
        return this.selfUniqueAddress;
    }

    public Address selfAddress() {
        return this.selfUniqueAddress().address();
    }

    public String selfDataCenter() {
        return this.settings().SelfDataCenter();
    }

    public scala.collection.immutable.Set<String> selfRoles() {
        return this.settings().Roles();
    }

    public Set<String> getSelfRoles() {
        return AsJavaExtensions.SetHasAsJava$((AsJavaExtensions)package.JavaConverters$.MODULE$, this.selfRoles()).asJava();
    }

    private AtomicBoolean _isTerminated() {
        return this._isTerminated;
    }

    public MarkerLoggingAdapter org$apache$pekko$cluster$Cluster$$log() {
        return this.org$apache$pekko$cluster$Cluster$$log;
    }

    private Option<ClusterJmx> clusterJmx() {
        return this.clusterJmx;
    }

    private void clusterJmx_$eq(Option<ClusterJmx> x$1) {
        this.clusterJmx = x$1;
    }

    public FailureDetectorRegistry<Address> failureDetector() {
        return this.failureDetector;
    }

    public FailureDetectorRegistry<Address> crossDcFailureDetector() {
        return this.crossDcFailureDetector;
    }

    private DowningProvider downingProvider$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.checkAutoDownUsage();
                this.downingProvider = DowningProvider$.MODULE$.load(this.settings().DowningProviderClassName(), (ActorSystem)this.system());
                this.bitmap$0 = true;
            }
        }
        return this.downingProvider;
    }

    public DowningProvider downingProvider() {
        if (!this.bitmap$0) {
            return this.downingProvider$lzycompute();
        }
        return this.downingProvider;
    }

    private void checkAutoDownUsage() {
        block3: {
            block2: {
                String string = this.settings().DowningProviderClassName();
                String string2 = "org.apache.pekko.cluster.AutoDowning";
                if (string != null && string.equals(string2)) break block2;
                if (!this.settings().config().hasPath("auto-down-unreachable-after")) break block3;
                String string3 = this.settings().config().getString("auto-down-unreachable-after");
                String string4 = "off";
                if (string3 != null && string3.equals(string4)) break block3;
            }
            this.ClusterLogger().logWarning("auto-down has been removed in Akka 2.6.0. See https://pekko.apache.org/docs/pekko/current/typed/cluster.html#downing for alternatives.");
            return;
        }
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    private ActorRef clusterDaemons() {
        return this.clusterDaemons;
    }

    public ActorRef clusterCore() {
        return this.clusterCore;
    }

    public ClusterReadView readView() {
        return this.readView;
    }

    public boolean isTerminated() {
        return this._isTerminated().get();
    }

    public ClusterEvent.CurrentClusterState state() {
        return this.readView().state();
    }

    public Member selfMember() {
        return this.readView().self();
    }

    public void subscribe(ActorRef subscriber, Seq<Class<?>> to) {
        this.subscribe(subscriber, (ClusterEvent.SubscriptionInitialStateMode)ClusterEvent$InitialStateAsSnapshot$.MODULE$, to);
    }

    public void subscribe(ActorRef subscriber, ClusterEvent.SubscriptionInitialStateMode initialStateMode, Seq<Class<?>> to) {
        Predef$.MODULE$.require(to.length() > 0, (Function0 & Serializable)() -> "at least one `ClusterDomainEvent` class is required");
        Predef$.MODULE$.require(to.forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Cluster.$anonfun$subscribe$2(x$1))), (Function0 & Serializable)() -> new StringBuilder(93).append("subscribe to `org.apache.pekko.cluster.ClusterEvent.ClusterDomainEvent` or subclasses, was [").append(((IterableOnceOps)to.map((Function1 & Serializable)x$1 -> x$1.getName())).mkString(", ")).append("]").toString());
        InternalClusterAction.Subscribe x$12 = new InternalClusterAction.Subscribe(subscriber, initialStateMode, to.toSet());
        ActorRef x$2 = this.clusterCore().$bang$default$2((Object)x$12);
        this.clusterCore().$bang((Object)x$12, x$2);
    }

    public void unsubscribe(ActorRef subscriber) {
        InternalClusterAction.Unsubscribe x$1 = new InternalClusterAction.Unsubscribe(subscriber, (Option<Class<?>>)None$.MODULE$);
        ActorRef x$2 = this.clusterCore().$bang$default$2((Object)x$1);
        this.clusterCore().$bang((Object)x$1, x$2);
    }

    public void unsubscribe(ActorRef subscriber, Class<?> to) {
        InternalClusterAction.Unsubscribe x$1 = new InternalClusterAction.Unsubscribe(subscriber, (Option<Class<?>>)new Some(to));
        ActorRef x$2 = this.clusterCore().$bang$default$2((Object)x$1);
        this.clusterCore().$bang((Object)x$1, x$2);
    }

    public void sendCurrentClusterState(ActorRef receiver) {
        InternalClusterAction.SendCurrentClusterState x$1 = new InternalClusterAction.SendCurrentClusterState(receiver);
        ActorRef x$2 = this.clusterCore().$bang$default$2((Object)x$1);
        this.clusterCore().$bang((Object)x$1, x$2);
    }

    public void join(Address address) {
        address.checkHostCharacters();
        ClusterUserAction.JoinTo x$1 = new ClusterUserAction.JoinTo(this.fillLocal(address));
        ActorRef x$2 = this.clusterCore().$bang$default$2((Object)x$1);
        this.clusterCore().$bang((Object)x$1, x$2);
    }

    public void prepareForFullClusterShutdown() {
        ClusterUserAction$PrepareForShutdown$ x$1 = ClusterUserAction$PrepareForShutdown$.MODULE$;
        ActorRef x$2 = this.clusterCore().$bang$default$2((Object)x$1);
        this.clusterCore().$bang((Object)x$1, x$2);
    }

    private Address fillLocal(Address address) {
        if (address.hasLocalScope()) {
            String string = address.system();
            String string2 = this.selfAddress().system();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return this.selfAddress();
            }
        }
        return address;
    }

    public void joinSeedNodes(Seq<Address> seedNodes) {
        seedNodes.foreach((Function1 & Serializable)x$2 -> {
            x$2.checkHostCharacters();
            return BoxedUnit.UNIT;
        });
        InternalClusterAction.JoinSeedNodes x$1 = new InternalClusterAction.JoinSeedNodes((IndexedSeq<Address>)((IndexedSeq)seedNodes.toVector().map((Function1 & Serializable)address -> this.fillLocal((Address)address))));
        ActorRef x$22 = this.clusterCore().$bang$default$2((Object)x$1);
        this.clusterCore().$bang((Object)x$1, x$22);
    }

    public void joinSeedNodes(java.util.List<Address> seedNodes) {
        this.joinSeedNodes((Seq<Address>)Util$.MODULE$.immutableSeq(seedNodes));
    }

    public void leave(Address address) {
        ClusterUserAction.Leave x$1 = new ClusterUserAction.Leave(this.fillLocal(address));
        ActorRef x$2 = this.clusterCore().$bang$default$2((Object)x$1);
        this.clusterCore().$bang((Object)x$1, x$2);
    }

    public void down(Address address) {
        ClusterUserAction.Down x$1 = new ClusterUserAction.Down(this.fillLocal(address));
        ActorRef x$2 = this.clusterCore().$bang$default$2((Object)x$1);
        this.clusterCore().$bang((Object)x$1, x$2);
    }

    public <T> void registerOnMemberUp(Function0<T> code) {
        this.registerOnMemberUp(new Runnable(null, code){
            private final Function0 code$1;

            public void run() {
                this.code$1.apply();
            }
            {
                this.code$1 = code$1;
            }
        });
    }

    public void registerOnMemberUp(Runnable callback) {
        InternalClusterAction.AddOnMemberUpListener x$1 = new InternalClusterAction.AddOnMemberUpListener(callback);
        ActorRef x$2 = this.clusterDaemons().$bang$default$2((Object)x$1);
        this.clusterDaemons().$bang((Object)x$1, x$2);
    }

    public <T> void registerOnMemberRemoved(Function0<T> code) {
        this.registerOnMemberRemoved(new Runnable(null, code){
            private final Function0 code$2;

            public void run() {
                this.code$2.apply();
            }
            {
                this.code$2 = code$2;
            }
        });
    }

    public void registerOnMemberRemoved(Runnable callback) {
        if (this._isTerminated().get()) {
            callback.run();
            return;
        }
        InternalClusterAction.AddOnMemberRemovedListener x$1 = new InternalClusterAction.AddOnMemberRemovedListener(callback);
        ActorRef x$2 = this.clusterDaemons().$bang$default$2((Object)x$1);
        this.clusterDaemons().$bang((Object)x$1, x$2);
    }

    public ActorPath remotePathOf(ActorRef actorRef) {
        ActorPath path = actorRef.path();
        if (path.address().host().isDefined()) {
            return path;
        }
        RootActorPath qual$1 = path.root();
        Address x$1 = this.selfAddress();
        if (qual$1 == null) {
            throw null;
        }
        String x$2 = qual$1.name();
        return ActorPath.$div$((ActorPath)new RootActorPath(x$1, x$2), (Iterable)path.elements()).withUid(path.uid());
    }

    @InternalApi
    public void shutdown() {
        if (this._isTerminated().compareAndSet(false, true)) {
            this.ClusterLogger().logInfo("Shutting down...");
            this.system().stop(this.clusterDaemons());
            if (this.readView() != null) {
                this.readView().close();
            }
            this.closeScheduler();
            this.clusterJmx().foreach((Function1 & Serializable)x$3 -> {
                x$3.unregisterMBean();
                return BoxedUnit.UNIT;
            });
            this.ClusterLogger().logInfo("Successfully shut down");
            return;
        }
    }

    private void closeScheduler() {
        Scheduler scheduler = this.scheduler();
        if (scheduler instanceof Closeable) {
            ((Closeable)scheduler).close();
            return;
        }
    }

    private final void ClusterLogger$lzycompute$1() {
        synchronized (this) {
            if (this.ClusterLogger$module == null) {
                this.ClusterLogger$module = new Cluster$ClusterLogger$(this);
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final /* synthetic */ ActorRef liftedTree1$1(Timeout timeout$1) {
        try {
            void ask_actorRef;
            ActorRef actorRef = this.clusterDaemons();
            org.apache.pekko.pattern.package$ ask_this = org.apache.pekko.pattern.package$.MODULE$;
            Object var6_3 = null;
            actorRef = null;
            ActorRef qual$1 = AskSupport.ask$((AskSupport)ask_this, (ActorRef)ask_actorRef);
            InternalClusterAction$GetClusterCoreRef$ x$1 = InternalClusterAction$GetClusterCoreRef$.MODULE$;
            ActorRef x$3 = Actor$.MODULE$.noSender();
            return (ActorRef)Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.internalAsk$extension(qual$1, (Object)x$1, timeout$1, x$3).mapTo(ClassTag$.MODULE$.apply(ActorRef.class)), (Duration)timeout$1.duration());
        }
        catch (Throwable throwable) {
            if (NonFatal$.MODULE$.apply(throwable)) {
                this.org$apache$pekko$cluster$Cluster$$log().error(throwable, "Failed to startup Cluster. You can try to increase 'pekko.actor.creation-timeout'.");
                this.shutdown();
                return this.system().deadLetters();
            }
            throw throwable;
        }
    }

    public static final /* synthetic */ boolean $anonfun$subscribe$2(Class x$1) {
        return ClusterEvent.ClusterDomainEvent.class.isAssignableFrom(x$1);
    }

    /*
     * WARNING - void declaration
     */
    public Cluster(ExtendedActorSystem system) {
        Scheduler scheduler;
        void apply_longUid;
        this.system = system;
        this.settings = new ClusterSettings(system.settings().config(), system.name());
        this.joinConfigCompatChecker = JoinConfigCompatChecker$.MODULE$.load(system, this.settings());
        ActorRefProvider actorRefProvider = system.provider();
        if (!(actorRefProvider instanceof ClusterActorRefProvider)) {
            throw new ConfigurationException(new StringBuilder(108).append("ActorSystem [").append(system).append("] needs to have 'pekko.actor.provider' set to 'cluster' in the configuration, currently uses [").append(actorRefProvider.getClass().getName()).append("]").toString());
        }
        ClusterActorRefProvider clusterActorRefProvider = (ClusterActorRefProvider)actorRefProvider;
        long l = ((AddressUidExtension)ExtensionId.apply$((ExtensionId)AddressUidExtension$.MODULE$, (ActorSystem)system)).longAddressUid();
        Address apply_address = clusterActorRefProvider.transport().defaultAddress();
        Object var13_5 = null;
        this.selfUniqueAddress = new UniqueAddress(apply_address, (long)apply_longUid);
        this._isTerminated = new AtomicBoolean(false);
        this.org$apache$pekko$cluster$Cluster$$log = Logging$.MODULE$.withMarker((ActorSystem)system, ClusterLogClass$.MODULE$.ClusterCore(), LogSource$.MODULE$.fromClass());
        this.clusterJmx = None$.MODULE$;
        this.ClusterLogger().logInfo("Starting up, Pekko version [{}] ...", (Object)system.settings().ConfigVersion());
        Function0 & Serializable createFailureDetector = (Function0 & Serializable)() -> FailureDetectorLoader$.MODULE$.load(this.settings().FailureDetectorImplementationClass(), this.settings().FailureDetectorConfig(), (ActorSystem)this.system());
        this.failureDetector = new DefaultFailureDetectorRegistry((Function0)createFailureDetector);
        Function0 & Serializable createFailureDetector2 = (Function0 & Serializable)() -> FailureDetectorLoader$.MODULE$.load(this.settings().MultiDataCenter().CrossDcFailureDetectorSettings().ImplementationClass(), this.settings().MultiDataCenter().CrossDcFailureDetectorSettings().config(), (ActorSystem)this.system());
        this.crossDcFailureDetector = new DefaultFailureDetectorRegistry((Function0)createFailureDetector2);
        package.DurationInt durationInt = new package.DurationInt(package$.MODULE$.DurationInt(1));
        if (system.scheduler().maxFrequency() < durationInt.second().$div((Duration)this.settings().SchedulerTickDuration())) {
            ThreadFactory threadFactory;
            this.ClusterLogger().logInfo("Using a dedicated scheduler for cluster. Default scheduler can be used if configured with 'pekko.scheduler.tick-duration' [{} ms] <=  'pekko.cluster.scheduler.tick-duration' [{} ms].", BoxesRunTime.boxToInteger((int)((int)((double)1000 / system.scheduler().maxFrequency()))), (Object)BoxesRunTime.boxToLong((long)this.settings().SchedulerTickDuration().toMillis()));
            Config cfg = ConfigFactory.parseString((String)new StringBuilder(32).append("pekko.scheduler.tick-duration=").append(this.settings().SchedulerTickDuration().toMillis()).append("ms").toString()).withFallback((ConfigMergeable)system.settings().config());
            ThreadFactory threadFactory2 = system.threadFactory();
            if (threadFactory2 instanceof MonitorableThreadFactory) {
                MonitorableThreadFactory monitorableThreadFactory = (MonitorableThreadFactory)threadFactory2;
                threadFactory = monitorableThreadFactory.withName(new StringBuilder(18).append(monitorableThreadFactory.name()).append("-cluster-scheduler").toString());
            } else {
                threadFactory = threadFactory2;
            }
            ThreadFactory threadFactory3 = threadFactory;
            scheduler = (Scheduler)system.dynamicAccess().createInstanceFor(system.settings().SchedulerClass(), (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Config.class), (Object)cfg), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(LoggingAdapter.class), (Object)this.org$apache$pekko$cluster$Cluster$$log()), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(ThreadFactory.class), (Object)threadFactory3), (List)Nil$.MODULE$))), ClassTag$.MODULE$.apply(Scheduler.class)).get();
        } else {
            Scheduler systemScheduler = system.scheduler();
            scheduler = new Scheduler(null, systemScheduler){
                private final Scheduler systemScheduler$1;

                public Cancellable scheduleWithFixedDelay(FiniteDuration initialDelay, FiniteDuration delay, Runnable runnable, ExecutionContext executor) {
                    return Scheduler.scheduleWithFixedDelay$((Scheduler)this, (FiniteDuration)initialDelay, (FiniteDuration)delay, (Runnable)runnable, (ExecutionContext)executor);
                }

                public final Cancellable scheduleWithFixedDelay(java.time.Duration initialDelay, java.time.Duration delay, Runnable runnable, ExecutionContext executor) {
                    return Scheduler.scheduleWithFixedDelay$((Scheduler)this, (java.time.Duration)initialDelay, (java.time.Duration)delay, (Runnable)runnable, (ExecutionContext)executor);
                }

                public final Cancellable scheduleWithFixedDelay(FiniteDuration initialDelay, FiniteDuration delay, ActorRef receiver, Object message, ExecutionContext executor, ActorRef sender) {
                    return Scheduler.scheduleWithFixedDelay$((Scheduler)this, (FiniteDuration)initialDelay, (FiniteDuration)delay, (ActorRef)receiver, (Object)message, (ExecutionContext)executor, (ActorRef)sender);
                }

                public final ActorRef scheduleWithFixedDelay$default$6(FiniteDuration initialDelay, FiniteDuration delay, ActorRef receiver, Object message) {
                    return Scheduler.scheduleWithFixedDelay$default$6$((Scheduler)this, (FiniteDuration)initialDelay, (FiniteDuration)delay, (ActorRef)receiver, (Object)message);
                }

                public final Cancellable scheduleWithFixedDelay(java.time.Duration initialDelay, java.time.Duration delay, ActorRef receiver, Object message, ExecutionContext executor, ActorRef sender) {
                    return Scheduler.scheduleWithFixedDelay$((Scheduler)this, (java.time.Duration)initialDelay, (java.time.Duration)delay, (ActorRef)receiver, (Object)message, (ExecutionContext)executor, (ActorRef)sender);
                }

                public final Cancellable scheduleAtFixedRate(FiniteDuration initialDelay, FiniteDuration interval, Runnable runnable, ExecutionContext executor) {
                    return Scheduler.scheduleAtFixedRate$((Scheduler)this, (FiniteDuration)initialDelay, (FiniteDuration)interval, (Runnable)runnable, (ExecutionContext)executor);
                }

                public final Cancellable scheduleAtFixedRate(java.time.Duration initialDelay, java.time.Duration interval, Runnable runnable, ExecutionContext executor) {
                    return Scheduler.scheduleAtFixedRate$((Scheduler)this, (java.time.Duration)initialDelay, (java.time.Duration)interval, (Runnable)runnable, (ExecutionContext)executor);
                }

                public final Cancellable scheduleAtFixedRate(FiniteDuration initialDelay, FiniteDuration interval, ActorRef receiver, Object message, ExecutionContext executor, ActorRef sender) {
                    return Scheduler.scheduleAtFixedRate$((Scheduler)this, (FiniteDuration)initialDelay, (FiniteDuration)interval, (ActorRef)receiver, (Object)message, (ExecutionContext)executor, (ActorRef)sender);
                }

                public final ActorRef scheduleAtFixedRate$default$6(FiniteDuration initialDelay, FiniteDuration interval, ActorRef receiver, Object message) {
                    return Scheduler.scheduleAtFixedRate$default$6$((Scheduler)this, (FiniteDuration)initialDelay, (FiniteDuration)interval, (ActorRef)receiver, (Object)message);
                }

                public final Cancellable scheduleAtFixedRate(java.time.Duration initialDelay, java.time.Duration interval, ActorRef receiver, Object message, ExecutionContext executor, ActorRef sender) {
                    return Scheduler.scheduleAtFixedRate$((Scheduler)this, (java.time.Duration)initialDelay, (java.time.Duration)interval, (ActorRef)receiver, (Object)message, (ExecutionContext)executor, (ActorRef)sender);
                }

                public final Cancellable schedule(FiniteDuration initialDelay, FiniteDuration interval, ActorRef receiver, Object message, ExecutionContext executor, ActorRef sender) {
                    return Scheduler.schedule$((Scheduler)this, (FiniteDuration)initialDelay, (FiniteDuration)interval, (ActorRef)receiver, (Object)message, (ExecutionContext)executor, (ActorRef)sender);
                }

                public final ActorRef schedule$default$6(FiniteDuration initialDelay, FiniteDuration interval, ActorRef receiver, Object message) {
                    return Scheduler.schedule$default$6$((Scheduler)this, (FiniteDuration)initialDelay, (FiniteDuration)interval, (ActorRef)receiver, (Object)message);
                }

                public final Cancellable schedule(java.time.Duration initialDelay, java.time.Duration interval, ActorRef receiver, Object message, ExecutionContext executor, ActorRef sender) {
                    return Scheduler.schedule$((Scheduler)this, (java.time.Duration)initialDelay, (java.time.Duration)interval, (ActorRef)receiver, (Object)message, (ExecutionContext)executor, (ActorRef)sender);
                }

                public final Cancellable schedule(FiniteDuration initialDelay, FiniteDuration interval, Function0<BoxedUnit> f, ExecutionContext executor) {
                    return Scheduler.schedule$((Scheduler)this, (FiniteDuration)initialDelay, (FiniteDuration)interval, f, (ExecutionContext)executor);
                }

                public Cancellable schedule(java.time.Duration initialDelay, java.time.Duration interval, Runnable runnable, ExecutionContext executor) {
                    return Scheduler.schedule$((Scheduler)this, (java.time.Duration)initialDelay, (java.time.Duration)interval, (Runnable)runnable, (ExecutionContext)executor);
                }

                public final Cancellable scheduleOnce(FiniteDuration delay, ActorRef receiver, Object message, ExecutionContext executor, ActorRef sender) {
                    return Scheduler.scheduleOnce$((Scheduler)this, (FiniteDuration)delay, (ActorRef)receiver, (Object)message, (ExecutionContext)executor, (ActorRef)sender);
                }

                public final ActorRef scheduleOnce$default$5(FiniteDuration delay, ActorRef receiver, Object message) {
                    return Scheduler.scheduleOnce$default$5$((Scheduler)this, (FiniteDuration)delay, (ActorRef)receiver, (Object)message);
                }

                public final Cancellable scheduleOnce(java.time.Duration delay, ActorRef receiver, Object message, ExecutionContext executor, ActorRef sender) {
                    return Scheduler.scheduleOnce$((Scheduler)this, (java.time.Duration)delay, (ActorRef)receiver, (Object)message, (ExecutionContext)executor, (ActorRef)sender);
                }

                public final Cancellable scheduleOnce(FiniteDuration delay, Function0<BoxedUnit> f, ExecutionContext executor) {
                    return Scheduler.scheduleOnce$((Scheduler)this, (FiniteDuration)delay, f, (ExecutionContext)executor);
                }

                public Cancellable scheduleOnce(java.time.Duration delay, Runnable runnable, ExecutionContext executor) {
                    return Scheduler.scheduleOnce$((Scheduler)this, (java.time.Duration)delay, (Runnable)runnable, (ExecutionContext)executor);
                }

                public void close() {
                }

                public double maxFrequency() {
                    return this.systemScheduler$1.maxFrequency();
                }

                public Cancellable schedule(FiniteDuration initialDelay, FiniteDuration interval, Runnable runnable, ExecutionContext executor) {
                    return this.systemScheduler$1.schedule(initialDelay, interval, runnable, executor);
                }

                public Cancellable scheduleOnce(FiniteDuration delay, Runnable runnable, ExecutionContext executor) {
                    return this.systemScheduler$1.scheduleOnce(delay, runnable, executor);
                }
                {
                    this.systemScheduler$1 = systemScheduler$1;
                }
            };
        }
        this.scheduler = scheduler;
        this.clusterDaemons = system.systemActorOf(Props$.MODULE$.apply(ClusterDaemon.class, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.joinConfigCompatChecker()})).withDispatcher(this.settings().UseDispatcher()).withDeploy(Deploy$.MODULE$.local()), "cluster");
        Timeout timeout = system.settings().CreationTimeout();
        this.clusterCore = this.liftedTree1$1(timeout);
        this.readView = new ClusterReadView(this);
        system.registerOnTermination((Function0)(JFunction0.mcV.sp & Serializable)() -> this.shutdown());
        if (this.settings().JmxEnabled()) {
            ClusterJmx jmx = new ClusterJmx(this, (LoggingAdapter)this.org$apache$pekko$cluster$Cluster$$log());
            jmx.createMBean();
            this.clusterJmx_$eq((Option<ClusterJmx>)new Some((Object)jmx));
        }
        this.ClusterLogger().logInfo("Started up successfully");
    }

    public class ClusterLogger {
        private final MarkerLoggingAdapter log;
        public final /* synthetic */ Cluster $outer;

        public boolean isDebugEnabled() {
            return this.log.isDebugEnabled();
        }

        public void logDebug(String message) {
            if (this.org$apache$pekko$cluster$Cluster$ClusterLogger$$$outer().settings().LogInfo() && this.log.isDebugEnabled()) {
                this.logAtLevel(Logging$.MODULE$.DebugLevel(), message);
                return;
            }
        }

        public void logDebug(String template, Object arg1) {
            if (this.org$apache$pekko$cluster$Cluster$ClusterLogger$$$outer().settings().LogInfo() && this.log.isDebugEnabled()) {
                this.logAtLevel(Logging$.MODULE$.DebugLevel(), this.log.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1})));
                return;
            }
        }

        public void logDebug(String template, Object arg1, Object arg2) {
            if (this.org$apache$pekko$cluster$Cluster$ClusterLogger$$$outer().settings().LogInfo() && this.log.isDebugEnabled()) {
                this.logAtLevel(Logging$.MODULE$.DebugLevel(), this.log.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2})));
                return;
            }
        }

        public void logDebug(String template, Object arg1, Object arg2, Object arg3) {
            if (this.org$apache$pekko$cluster$Cluster$ClusterLogger$$$outer().settings().LogInfo() && this.log.isDebugEnabled()) {
                this.logAtLevel(Logging$.MODULE$.DebugLevel(), this.log.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2, arg3})));
                return;
            }
        }

        public void logInfo(String message) {
            if (this.org$apache$pekko$cluster$Cluster$ClusterLogger$$$outer().settings().LogInfo() && this.log.isInfoEnabled()) {
                this.logAtLevel(Logging$.MODULE$.InfoLevel(), message);
                return;
            }
        }

        public void logInfo(LogMarker marker, String message) {
            if (this.org$apache$pekko$cluster$Cluster$ClusterLogger$$$outer().settings().LogInfo() && this.log.isInfoEnabled(marker)) {
                this.logAtLevel(marker, Logging$.MODULE$.InfoLevel(), message);
                return;
            }
        }

        public void logInfo(String template, Object arg1) {
            if (this.org$apache$pekko$cluster$Cluster$ClusterLogger$$$outer().settings().LogInfo() && this.log.isInfoEnabled()) {
                this.logAtLevel(Logging$.MODULE$.InfoLevel(), this.log.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1})));
                return;
            }
        }

        public void logInfo(LogMarker marker, String template, Object arg1) {
            if (this.org$apache$pekko$cluster$Cluster$ClusterLogger$$$outer().settings().LogInfo() && this.log.isInfoEnabled(marker)) {
                this.logAtLevel(marker, Logging$.MODULE$.InfoLevel(), this.log.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1})));
                return;
            }
        }

        public void logInfo(String template, Object arg1, Object arg2) {
            if (this.org$apache$pekko$cluster$Cluster$ClusterLogger$$$outer().settings().LogInfo() && this.log.isInfoEnabled()) {
                this.logAtLevel(Logging$.MODULE$.InfoLevel(), this.log.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2})));
                return;
            }
        }

        public void logInfo(LogMarker marker, String template, Object arg1, Object arg2) {
            if (this.org$apache$pekko$cluster$Cluster$ClusterLogger$$$outer().settings().LogInfo() && this.log.isInfoEnabled(marker)) {
                this.logAtLevel(marker, Logging$.MODULE$.InfoLevel(), this.log.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2})));
                return;
            }
        }

        public void logInfo(String template, Object arg1, Object arg2, Object arg3) {
            if (this.org$apache$pekko$cluster$Cluster$ClusterLogger$$$outer().settings().LogInfo() && this.log.isInfoEnabled()) {
                this.logAtLevel(Logging$.MODULE$.InfoLevel(), this.log.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2, arg3})));
                return;
            }
        }

        public void logInfo(LogMarker marker, String template, Object arg1, Object arg2, Object arg3) {
            if (this.org$apache$pekko$cluster$Cluster$ClusterLogger$$$outer().settings().LogInfo() && this.log.isInfoEnabled(marker)) {
                this.logAtLevel(marker, Logging$.MODULE$.InfoLevel(), this.log.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2, arg3})));
                return;
            }
        }

        public void logWarning(String message) {
            if (this.log.isWarningEnabled()) {
                this.logAtLevel(Logging$.MODULE$.WarningLevel(), message);
                return;
            }
        }

        public void logWarning(String template, Object arg1) {
            if (this.log.isWarningEnabled()) {
                this.logAtLevel(Logging$.MODULE$.WarningLevel(), this.log.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1})));
                return;
            }
        }

        public void logWarning(LogMarker marker, String template, Object arg1) {
            if (this.log.isWarningEnabled(marker)) {
                this.logAtLevel(marker, Logging$.MODULE$.WarningLevel(), this.log.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1})));
                return;
            }
        }

        public void logWarning(String template, Object arg1, Object arg2) {
            if (this.log.isWarningEnabled()) {
                this.logAtLevel(Logging$.MODULE$.WarningLevel(), this.log.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2})));
                return;
            }
        }

        public void logWarning(LogMarker marker, String template, Object arg1, Object arg2) {
            if (this.log.isWarningEnabled(marker)) {
                this.logAtLevel(marker, Logging$.MODULE$.WarningLevel(), this.log.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2})));
                return;
            }
        }

        public void logWarning(String template, Object arg1, Object arg2, Object arg3) {
            if (this.log.isWarningEnabled()) {
                this.logAtLevel(Logging$.MODULE$.WarningLevel(), this.log.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2, arg3})));
                return;
            }
        }

        public void logError(String message) {
            if (this.log.isErrorEnabled()) {
                this.logAtLevel(Logging$.MODULE$.ErrorLevel(), message);
                return;
            }
        }

        public void logError(LogMarker marker, String message) {
            if (this.log.isErrorEnabled(marker)) {
                this.logAtLevel(marker, Logging$.MODULE$.ErrorLevel(), message);
                return;
            }
        }

        public void logError(String template, Object arg1) {
            if (this.log.isErrorEnabled()) {
                this.logAtLevel(Logging$.MODULE$.ErrorLevel(), this.log.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1})));
                return;
            }
        }

        public void logError(String template, Object arg1, Object arg2) {
            if (this.log.isErrorEnabled()) {
                this.logAtLevel(Logging$.MODULE$.ErrorLevel(), this.log.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2})));
                return;
            }
        }

        public void logError(String template, Object arg1, Object arg2, Object arg3) {
            if (this.log.isErrorEnabled()) {
                this.logAtLevel(Logging$.MODULE$.ErrorLevel(), this.log.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2, arg3})));
                return;
            }
        }

        public void logError(Throwable cause, String message) {
            String string = this.org$apache$pekko$cluster$Cluster$ClusterLogger$$$outer().settings().SelfDataCenter();
            String string2 = ClusterSettings$.MODULE$.DefaultDataCenter();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                this.log.error(cause, "Cluster Node [{}] - {}", (Object)this.org$apache$pekko$cluster$Cluster$ClusterLogger$$$outer().selfAddress(), (Object)message);
                return;
            }
            this.log.error(cause, "Cluster Node [{}] dc [{}] - {}", (Object)this.org$apache$pekko$cluster$Cluster$ClusterLogger$$$outer().selfAddress(), (Object)this.org$apache$pekko$cluster$Cluster$ClusterLogger$$$outer().settings().SelfDataCenter(), (Object)message);
        }

        public void logError(Throwable cause, String template, Object arg1) {
            this.logError(cause, this.log.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1})));
        }

        public void logError(Throwable cause, String template, Object arg1, Object arg2) {
            this.logError(cause, this.log.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2})));
        }

        public void logError(Throwable cause, String template, Object arg1, Object arg2, Object arg3) {
            this.logError(cause, this.log.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2, arg3})));
        }

        private void logAtLevel(int logLevel, String message) {
            String string = this.org$apache$pekko$cluster$Cluster$ClusterLogger$$$outer().settings().SelfDataCenter();
            String string2 = ClusterSettings$.MODULE$.DefaultDataCenter();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                this.log.log(logLevel, "Cluster Node [{}] - {}", (Object)this.org$apache$pekko$cluster$Cluster$ClusterLogger$$$outer().selfAddress(), (Object)message);
                return;
            }
            this.log.log(logLevel, "Cluster Node [{}] dc [{}] - {}", (Object)this.org$apache$pekko$cluster$Cluster$ClusterLogger$$$outer().selfAddress(), (Object)this.org$apache$pekko$cluster$Cluster$ClusterLogger$$$outer().settings().SelfDataCenter(), (Object)message);
        }

        private void logAtLevel(LogMarker marker, int logLevel, String message) {
            String string = this.org$apache$pekko$cluster$Cluster$ClusterLogger$$$outer().settings().SelfDataCenter();
            String string2 = ClusterSettings$.MODULE$.DefaultDataCenter();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                this.log.log(marker, logLevel, this.log.format("Cluster Node [{}] - {}", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.org$apache$pekko$cluster$Cluster$ClusterLogger$$$outer().selfAddress(), message})));
                return;
            }
            this.log.log(marker, logLevel, this.log.format("Cluster Node [{}] dc [{}] - {}", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.org$apache$pekko$cluster$Cluster$ClusterLogger$$$outer().selfAddress(), this.org$apache$pekko$cluster$Cluster$ClusterLogger$$$outer().settings().SelfDataCenter(), message})));
        }

        public /* synthetic */ Cluster org$apache$pekko$cluster$Cluster$ClusterLogger$$$outer() {
            return this.$outer;
        }

        public ClusterLogger(Cluster $outer, MarkerLoggingAdapter log) {
            this.log = log;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

