/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.util.HashMap;
import java.util.Map;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.global.AbstractGlobalConfigurationBuilder;
import org.infinispan.configuration.global.GlobalAuthorizationConfiguration;
import org.infinispan.configuration.global.GlobalRoleConfigurationBuilder;
import org.infinispan.configuration.global.GlobalSecurityConfigurationBuilder;
import org.infinispan.configuration.global.PrincipalRoleMapperConfigurationBuilder;
import org.infinispan.configuration.global.RolePermissionMapperConfigurationBuilder;
import org.infinispan.security.AuditLogger;
import org.infinispan.security.PrincipalRoleMapper;
import org.infinispan.security.Role;
import org.infinispan.security.RolePermissionMapper;
import org.infinispan.util.logging.Log;

public class GlobalAuthorizationConfigurationBuilder
extends AbstractGlobalConfigurationBuilder
implements Builder<GlobalAuthorizationConfiguration> {
    private final AttributeSet attributes;
    private final PrincipalRoleMapperConfigurationBuilder roleMapper;
    private final RolePermissionMapperConfigurationBuilder permissionMapper;
    private final Map<String, GlobalRoleConfigurationBuilder> roles = new HashMap<String, GlobalRoleConfigurationBuilder>();

    public GlobalAuthorizationConfigurationBuilder(GlobalSecurityConfigurationBuilder builder) {
        super(builder.getGlobalConfig());
        this.roleMapper = new PrincipalRoleMapperConfigurationBuilder(this.getGlobalConfig());
        this.permissionMapper = new RolePermissionMapperConfigurationBuilder(this.getGlobalConfig());
        this.attributes = GlobalAuthorizationConfiguration.attributeDefinitionSet();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public GlobalAuthorizationConfigurationBuilder enable() {
        return this.enabled(true);
    }

    public GlobalAuthorizationConfigurationBuilder disable() {
        return this.enabled(false);
    }

    public GlobalAuthorizationConfigurationBuilder enabled(boolean enabled) {
        this.attributes.attribute(GlobalAuthorizationConfiguration.ENABLED).set((Object)enabled);
        return this;
    }

    public boolean isEnabled() {
        return (Boolean)this.attributes.attribute(GlobalAuthorizationConfiguration.ENABLED).get();
    }

    public GlobalAuthorizationConfigurationBuilder auditLogger(AuditLogger auditLogger) {
        this.attributes.attribute(GlobalAuthorizationConfiguration.AUDIT_LOGGER).set((Object)auditLogger);
        return this;
    }

    public GlobalAuthorizationConfigurationBuilder principalRoleMapper(PrincipalRoleMapper principalRoleMapper) {
        this.roleMapper.mapper(principalRoleMapper);
        return this;
    }

    public GlobalAuthorizationConfigurationBuilder rolePermissionMapper(RolePermissionMapper rolePermissionMapper) {
        this.permissionMapper.mapper(rolePermissionMapper);
        return this;
    }

    public GlobalRoleConfigurationBuilder role(String name) {
        GlobalRoleConfigurationBuilder role = new GlobalRoleConfigurationBuilder(name, this);
        this.roles.put(name, role);
        return role;
    }

    public void validate() {
        this.roleMapper.validate();
        if (((Boolean)this.attributes.attribute(GlobalAuthorizationConfiguration.ENABLED).get()).booleanValue() && this.roleMapper.mapper() == null) {
            throw Log.CONFIG.invalidPrincipalRoleMapper();
        }
    }

    public GlobalAuthorizationConfiguration create() {
        HashMap<String, Role> rolesCfg = new HashMap<String, Role>();
        for (GlobalRoleConfigurationBuilder role : this.roles.values()) {
            Role roleCfg = role.create();
            rolesCfg.put(roleCfg.getName(), roleCfg);
        }
        if (!rolesCfg.isEmpty()) {
            this.attributes.attribute(GlobalAuthorizationConfiguration.ROLES).set(rolesCfg);
        }
        return new GlobalAuthorizationConfiguration(this.attributes.protect(), this.roleMapper.create(), this.permissionMapper.create());
    }

    public Builder<?> read(GlobalAuthorizationConfiguration template, Combine combine) {
        this.attributes.read(template.attributes(), combine);
        this.roleMapper.read(template.roleMapperConfiguration(), combine);
        this.permissionMapper.read(template.permissionMapperConfiguration(), combine);
        this.roles.clear();
        for (Role role : template.roles().values()) {
            this.role(role.getName()).read(role, combine);
        }
        return this;
    }
}

