/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authorization.method;

import java.lang.reflect.Method;
import org.springframework.expression.Expression;
import org.springframework.lang.NonNull;
import org.springframework.security.access.prepost.PostFilter;
import org.springframework.security.authorization.method.AbstractExpressionAttributeRegistry;
import org.springframework.security.authorization.method.ExpressionAttribute;
import org.springframework.security.core.annotation.AnnotationTemplateExpressionDefaults;
import org.springframework.security.core.annotation.SecurityAnnotationScanner;
import org.springframework.security.core.annotation.SecurityAnnotationScanners;

final class PostFilterExpressionAttributeRegistry
extends AbstractExpressionAttributeRegistry<ExpressionAttribute> {
    private SecurityAnnotationScanner<PostFilter> scanner = SecurityAnnotationScanners.requireUnique(PostFilter.class);

    PostFilterExpressionAttributeRegistry() {
    }

    @Override
    @NonNull
    ExpressionAttribute resolveAttribute(Method method, Class<?> targetClass) {
        PostFilter postFilter = this.findPostFilterAnnotation(method, targetClass);
        if (postFilter == null) {
            return ExpressionAttribute.NULL_ATTRIBUTE;
        }
        Expression postFilterExpression = this.getExpressionHandler().getExpressionParser().parseExpression(postFilter.value());
        return new ExpressionAttribute(postFilterExpression);
    }

    @Override
    void setTemplateDefaults(AnnotationTemplateExpressionDefaults defaults) {
        this.scanner = SecurityAnnotationScanners.requireUnique(PostFilter.class, defaults);
    }

    private PostFilter findPostFilterAnnotation(Method method, Class<?> targetClass) {
        Class<?> targetClassToUse = this.targetClass(method, targetClass);
        return this.scanner.scan(method, targetClassToUse);
    }
}

