/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.oidc.session;

import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.security.core.session.SessionInformation;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;

public class OidcSessionInformation
extends SessionInformation {
    private static final long serialVersionUID = -1703808683027974918L;
    private final Map<String, String> authorities;

    public OidcSessionInformation(String sessionId, Map<String, String> authorities, OidcUser user) {
        super((Object)user, sessionId, new Date());
        this.authorities = authorities != null ? new LinkedHashMap<String, String>(authorities) : Collections.emptyMap();
    }

    public Map<String, String> getAuthorities() {
        return this.authorities;
    }

    public OidcUser getPrincipal() {
        return (OidcUser)super.getPrincipal();
    }

    public OidcSessionInformation withSessionId(String sessionId) {
        return new OidcSessionInformation(sessionId, this.getAuthorities(), this.getPrincipal());
    }
}

