/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.http.client;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.function.Supplier;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.http.client.ClientHttpRequestFactoryBuilder;
import org.springframework.boot.http.client.ClientHttpRequestFactorySettings;
import org.springframework.http.client.AbstractClientHttpRequestFactoryWrapper;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

final class ReflectiveComponentsClientHttpRequestFactoryBuilder<T extends ClientHttpRequestFactory>
implements ClientHttpRequestFactoryBuilder<T> {
    private final Supplier<T> requestFactorySupplier;

    ReflectiveComponentsClientHttpRequestFactoryBuilder(Supplier<T> requestFactorySupplier) {
        Assert.notNull(requestFactorySupplier, (String)"'requestFactorySupplier' must not be null");
        this.requestFactorySupplier = requestFactorySupplier;
    }

    ReflectiveComponentsClientHttpRequestFactoryBuilder(Class<T> requestFactoryType) {
        Assert.notNull(requestFactoryType, (String)"'requestFactoryType' must not be null");
        this.requestFactorySupplier = () -> ReflectiveComponentsClientHttpRequestFactoryBuilder.createRequestFactory(requestFactoryType);
    }

    private static <T extends ClientHttpRequestFactory> T createRequestFactory(Class<T> requestFactory) {
        try {
            Constructor<T> constructor = requestFactory.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return (T)((ClientHttpRequestFactory)constructor.newInstance(new Object[0]));
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public T build(ClientHttpRequestFactorySettings settings) {
        ClientHttpRequestFactory requestFactory = (ClientHttpRequestFactory)this.requestFactorySupplier.get();
        if (settings != null) {
            this.configure(requestFactory, settings);
        }
        return (T)requestFactory;
    }

    private void configure(ClientHttpRequestFactory requestFactory, ClientHttpRequestFactorySettings settings) {
        Assert.state((settings.sslBundle() == null ? 1 : 0) != 0, (String)"Unable to set SSL bundle using reflection");
        Assert.state((settings.redirects() == ClientHttpRequestFactorySettings.Redirects.FOLLOW_WHEN_POSSIBLE ? 1 : 0) != 0, (String)"Unable to set redirect follow using reflection");
        ClientHttpRequestFactory unwrapped = this.unwrapRequestFactoryIfNecessary(requestFactory);
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(settings::connectTimeout).to(connectTimeout -> this.setConnectTimeout(unwrapped, (Duration)connectTimeout));
        map.from(settings::readTimeout).to(readTimeout -> this.setReadTimeout(unwrapped, (Duration)readTimeout));
    }

    private ClientHttpRequestFactory unwrapRequestFactoryIfNecessary(ClientHttpRequestFactory requestFactory) {
        if (!(requestFactory instanceof AbstractClientHttpRequestFactoryWrapper)) {
            return requestFactory;
        }
        Field field = ReflectionUtils.findField(AbstractClientHttpRequestFactoryWrapper.class, (String)"requestFactory");
        ReflectionUtils.makeAccessible((Field)field);
        ClientHttpRequestFactory unwrappedRequestFactory = requestFactory;
        while (unwrappedRequestFactory instanceof AbstractClientHttpRequestFactoryWrapper) {
            unwrappedRequestFactory = (ClientHttpRequestFactory)ReflectionUtils.getField((Field)field, (Object)unwrappedRequestFactory);
        }
        return unwrappedRequestFactory;
    }

    private void setConnectTimeout(ClientHttpRequestFactory factory, Duration connectTimeout) {
        Method method = this.tryFindMethod(factory, "setConnectTimeout", Duration.class);
        if (method != null) {
            this.invoke(factory, method, connectTimeout);
            return;
        }
        method = this.findMethod(factory, "setConnectTimeout", Integer.TYPE);
        int timeout = Math.toIntExact(connectTimeout.toMillis());
        this.invoke(factory, method, timeout);
    }

    private void setReadTimeout(ClientHttpRequestFactory factory, Duration readTimeout) {
        Method method = this.tryFindMethod(factory, "setReadTimeout", Duration.class);
        if (method != null) {
            this.invoke(factory, method, readTimeout);
            return;
        }
        method = this.findMethod(factory, "setReadTimeout", Integer.TYPE);
        int timeout = Math.toIntExact(readTimeout.toMillis());
        this.invoke(factory, method, timeout);
    }

    private Method findMethod(ClientHttpRequestFactory requestFactory, String methodName, Class<?> ... parameters) {
        Method method = ReflectionUtils.findMethod(requestFactory.getClass(), (String)methodName, (Class[])parameters);
        Assert.state((method != null ? 1 : 0) != 0, () -> "Request factory %s does not have a suitable %s method".formatted(requestFactory.getClass().getName(), methodName));
        Assert.state((!method.isAnnotationPresent(Deprecated.class) ? 1 : 0) != 0, () -> "Request factory %s has the %s method marked as deprecated".formatted(requestFactory.getClass().getName(), methodName));
        return method;
    }

    private Method tryFindMethod(ClientHttpRequestFactory requestFactory, String methodName, Class<?> ... parameters) {
        Method method = ReflectionUtils.findMethod(requestFactory.getClass(), (String)methodName, (Class[])parameters);
        if (method == null) {
            return null;
        }
        if (method.isAnnotationPresent(Deprecated.class)) {
            return null;
        }
        return method;
    }

    private void invoke(ClientHttpRequestFactory requestFactory, Method method, Object ... parameters) {
        ReflectionUtils.invokeMethod((Method)method, (Object)requestFactory, (Object[])parameters);
    }
}

