/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl.view;

import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.management.QueueControl;
import org.apache.activemq.artemis.core.management.impl.view.ActiveMQAbstractView;
import org.apache.activemq.artemis.core.management.impl.view.QueueField;
import org.apache.activemq.artemis.core.management.impl.view.predicate.QueueFilterPredicate;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.json.JsonObjectBuilder;
import org.apache.activemq.artemis.utils.JsonLoader;

public class QueueView
extends ActiveMQAbstractView<QueueControl> {
    private static final String defaultSortField = QueueField.NAME.getName();
    private ActiveMQServer server;

    public QueueView(ActiveMQServer server) {
        this.predicate = new QueueFilterPredicate(server);
        this.server = server;
    }

    @Override
    public Class getClassT() {
        return QueueControl.class;
    }

    @Override
    public JsonObjectBuilder toJson(QueueControl queue) {
        Queue q = this.server.locateQueue(SimpleString.of((String)queue.getName()));
        JsonObjectBuilder obj = JsonLoader.createObjectBuilder().add(QueueField.ID.getName(), this.toString(queue.getID())).add(QueueField.NAME.getName(), this.toString(queue.getName())).add(QueueField.ADDRESS.getName(), this.toString(queue.getAddress())).add(QueueField.FILTER.getName(), this.toString(queue.getFilter())).add(QueueField.DURABLE.getName(), this.toString(queue.isDurable())).add(QueueField.PAUSED.getName(), this.toString(q.isPaused())).add(QueueField.TEMPORARY.getName(), this.toString(queue.isTemporary())).add(QueueField.PURGE_ON_NO_CONSUMERS.getName(), this.toString(queue.isPurgeOnNoConsumers())).add(QueueField.CONSUMER_COUNT.getName(), this.toString(queue.getConsumerCount())).add(QueueField.MAX_CONSUMERS.getName(), this.toString(queue.getMaxConsumers())).add(QueueField.AUTO_CREATED.getName(), this.toString(q.isAutoCreated())).add(QueueField.USER.getName(), this.toString(q.getUser())).add(QueueField.ROUTING_TYPE.getName(), this.toString(queue.getRoutingType())).add(QueueField.MESSAGES_ADDED.getName(), this.toString(queue.getMessagesAdded())).add(QueueField.MESSAGE_COUNT.getName(), this.toString(queue.getMessageCount())).add(QueueField.MESSAGES_ACKED.getName(), this.toString(queue.getMessagesAcknowledged())).add(QueueField.MESSAGES_EXPIRED.getName(), this.toString(queue.getMessagesExpired())).add(QueueField.DELIVERING_COUNT.getName(), this.toString(queue.getDeliveringCount())).add(QueueField.MESSAGES_KILLED.getName(), this.toString(queue.getMessagesKilled())).add(QueueField.DIRECT_DELIVER.getName(), this.toString(q.isDirectDeliver())).add(QueueField.EXCLUSIVE.getName(), this.toString(queue.isExclusive())).add(QueueField.LAST_VALUE.getName(), this.toString(queue.isLastValue())).add(QueueField.LAST_VALUE_KEY.getName(), this.toString(queue.getLastValueKey())).add(QueueField.SCHEDULED_COUNT.getName(), this.toString(queue.getScheduledCount())).add(QueueField.GROUP_REBALANCE.getName(), this.toString(queue.isGroupRebalance())).add(QueueField.GROUP_REBALANCE_PAUSE_DISPATCH.getName(), this.toString(queue.isGroupRebalancePauseDispatch())).add(QueueField.GROUP_BUCKETS.getName(), this.toString(queue.getGroupBuckets())).add(QueueField.GROUP_FIRST_KEY.getName(), this.toString(queue.getGroupFirstKey())).add(QueueField.ENABLED.getName(), this.toString(queue.isEnabled())).add(QueueField.RING_SIZE.getName(), this.toString(queue.getRingSize())).add(QueueField.CONSUMERS_BEFORE_DISPATCH.getName(), this.toString(queue.getConsumersBeforeDispatch())).add(QueueField.DELAY_BEFORE_DISPATCH.getName(), this.toString(queue.getDelayBeforeDispatch())).add(QueueField.AUTO_DELETE.getName(), this.toString(q.isAutoDelete())).add(QueueField.INTERNAL_QUEUE.getName(), this.toString(q.isInternalQueue()));
        return obj;
    }

    @Override
    public Object getField(QueueControl queue, String fieldName) {
        Queue q = this.server.locateQueue(SimpleString.of((String)queue.getName()));
        QueueField field = QueueField.valueOfName(fieldName);
        return switch (field) {
            case QueueField.ID -> queue.getID();
            case QueueField.NAME -> queue.getName();
            case QueueField.ADDRESS -> queue.getAddress();
            case QueueField.FILTER -> queue.getFilter();
            case QueueField.DURABLE -> queue.isDurable();
            case QueueField.PAUSED -> q.isPaused();
            case QueueField.TEMPORARY -> queue.isTemporary();
            case QueueField.PURGE_ON_NO_CONSUMERS -> queue.isPurgeOnNoConsumers();
            case QueueField.CONSUMER_COUNT -> queue.getConsumerCount();
            case QueueField.MAX_CONSUMERS -> queue.getMaxConsumers();
            case QueueField.AUTO_CREATED -> q.isAutoCreated();
            case QueueField.USER -> q.getUser();
            case QueueField.ROUTING_TYPE -> queue.getRoutingType();
            case QueueField.MESSAGES_ADDED -> queue.getMessagesAdded();
            case QueueField.MESSAGE_COUNT -> queue.getMessageCount();
            case QueueField.MESSAGES_ACKED -> queue.getMessagesAcknowledged();
            case QueueField.MESSAGES_EXPIRED -> queue.getMessagesExpired();
            case QueueField.DELIVERING_COUNT -> queue.getDeliveringCount();
            case QueueField.MESSAGES_KILLED -> queue.getMessagesKilled();
            case QueueField.DIRECT_DELIVER -> q.isDirectDeliver();
            case QueueField.EXCLUSIVE -> q.isExclusive();
            case QueueField.LAST_VALUE -> q.isLastValue();
            case QueueField.LAST_VALUE_KEY -> q.getLastValueKey();
            case QueueField.SCHEDULED_COUNT -> q.getScheduledCount();
            case QueueField.GROUP_REBALANCE -> queue.isGroupRebalance();
            case QueueField.GROUP_REBALANCE_PAUSE_DISPATCH -> queue.isGroupRebalancePauseDispatch();
            case QueueField.GROUP_BUCKETS -> queue.getGroupBuckets();
            case QueueField.GROUP_FIRST_KEY -> queue.getGroupFirstKey();
            case QueueField.ENABLED -> q.isEnabled();
            case QueueField.RING_SIZE -> q.getRingSize();
            case QueueField.CONSUMERS_BEFORE_DISPATCH -> q.getConsumersBeforeDispatch();
            case QueueField.DELAY_BEFORE_DISPATCH -> q.getDelayBeforeDispatch();
            case QueueField.INTERNAL_QUEUE -> q.isInternalQueue();
            default -> throw new IllegalArgumentException("Unsupported field, " + fieldName);
        };
    }

    @Override
    public String getDefaultOrderColumn() {
        return defaultSortField;
    }
}

