/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.connections.spi;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Context;
import javax.sql.DataSource;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.jdbc.connections.internal.DatabaseConnectionInfoImpl;
import org.hibernate.engine.jdbc.connections.spi.AbstractDataSourceBasedMultiTenantConnectionProviderImpl;
import org.hibernate.engine.jdbc.connections.spi.DatabaseConnectionInfo;
import org.hibernate.engine.jndi.spi.JndiService;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.Stoppable;

public class DataSourceBasedMultiTenantConnectionProviderImpl<T>
extends AbstractDataSourceBasedMultiTenantConnectionProviderImpl<T>
implements ServiceRegistryAwareService,
Stoppable {
    private Map<T, DataSource> dataSourceMap;
    private JndiService jndiService;
    private T tenantIdentifierForAny;
    private String baseJndiNamespace;

    @Override
    protected DataSource selectAnyDataSource() {
        return this.selectDataSource(this.tenantIdentifierForAny);
    }

    @Override
    protected DataSource selectDataSource(T tenantIdentifier) {
        DataSource dataSource = this.dataSourceMap().get(tenantIdentifier);
        if (dataSource == null) {
            dataSource = (DataSource)this.jndiService.locate(this.baseJndiNamespace + "/" + String.valueOf(tenantIdentifier));
            this.dataSourceMap().put(tenantIdentifier, dataSource);
        }
        return dataSource;
    }

    private Map<T, DataSource> dataSourceMap() {
        if (this.dataSourceMap == null) {
            this.dataSourceMap = new ConcurrentHashMap<T, DataSource>();
        }
        return this.dataSourceMap;
    }

    @Override
    public void injectServices(ServiceRegistryImplementor serviceRegistry) {
        Object dataSourceConfigValue = serviceRegistry.requireService(ConfigurationService.class).getSettings().get("hibernate.connection.datasource");
        if (!(dataSourceConfigValue instanceof String)) {
            throw new HibernateException("Improper set up of DataSourceBasedMultiTenantConnectionProviderImpl");
        }
        String jndiName = (String)dataSourceConfigValue;
        this.jndiService = serviceRegistry.getService(JndiService.class);
        if (this.jndiService == null) {
            throw new HibernateException("Could not locate JndiService from DataSourceBasedMultiTenantConnectionProviderImpl");
        }
        Object namedObject = this.jndiService.locate(jndiName);
        if (namedObject == null) {
            throw new HibernateException("JNDI name [" + jndiName + "] could not be resolved");
        }
        if (namedObject instanceof DataSource) {
            int loc = jndiName.lastIndexOf(47);
            this.baseJndiNamespace = jndiName.substring(0, loc);
            this.tenantIdentifierForAny = jndiName.substring(loc + 1);
            this.dataSourceMap().put(this.tenantIdentifierForAny, (DataSource)namedObject);
        } else if (namedObject instanceof Context) {
            this.baseJndiNamespace = jndiName;
            this.tenantIdentifierForAny = serviceRegistry.requireService(ConfigurationService.class).getSettings().get("hibernate.multi_tenant.datasource.identifier_for_any");
            if (this.tenantIdentifierForAny == null) {
                throw new HibernateException("JNDI name named a Context, but tenant identifier to use for ANY was not specified");
            }
        } else {
            throw new HibernateException("Unknown object type [" + namedObject.getClass().getName() + "] found in JNDI location [" + jndiName + "]");
        }
    }

    @Override
    public void stop() {
        if (this.dataSourceMap != null) {
            this.dataSourceMap.clear();
            this.dataSourceMap = null;
        }
    }

    @Override
    public DatabaseConnectionInfo getDatabaseConnectionInfo(Dialect dialect) {
        return new DatabaseConnectionInfoImpl("Multi-tenant - " + String.valueOf(this.tenantIdentifierForAny), null, dialect.getVersion(), null, null, null, null);
    }
}

