/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks.cs;

import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.jgroups.Address;
import org.jgroups.Version;
import org.jgroups.blocks.cs.Connection;
import org.jgroups.blocks.cs.NioBaseServer;
import org.jgroups.blocks.cs.Receiver;
import org.jgroups.nio.Buffers;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.ByteArrayDataInputStream;
import org.jgroups.util.ByteArrayDataOutputStream;
import org.jgroups.util.Util;

public class NioConnection
extends Connection {
    protected SocketChannel channel;
    protected SelectionKey key;
    protected final Buffers send_buf;
    protected final ByteBuffer length_buf = ByteBuffer.allocate(4);
    protected boolean copy_on_partial_write = true;
    protected int partial_writes;
    protected Buffers recv_buf = new Buffers(4).add(ByteBuffer.allocate(cookie.length));

    public NioConnection(Address peer_addr, NioBaseServer server) throws Exception {
        this.server = server;
        if (peer_addr == null) {
            throw new IllegalArgumentException("Invalid parameter peer_addr=" + String.valueOf(peer_addr));
        }
        this.peer_addr = peer_addr;
        this.send_buf = new Buffers(server.maxSendBuffers() * 2);
        this.channel = server.socketFactory().createSocketChannel("jgroups.nio.client");
        this.channel.configureBlocking(false);
        this.setSocketParameters(this.channel.socket());
        this.last_access = this.getTimestamp();
        this.recv_buf.maxLength(server.getMaxLength());
    }

    public NioConnection(SocketChannel channel, NioBaseServer server) throws Exception {
        this.channel = channel;
        this.server = server;
        this.setSocketParameters(this.channel.socket());
        channel.configureBlocking(false);
        this.send_buf = new Buffers(server.maxSendBuffers() * 2);
        this.peer_addr = server.usePeerConnections() ? null : new IpAddress((InetSocketAddress)channel.getRemoteAddress());
        this.last_access = this.getTimestamp();
        this.recv_buf.maxLength(server.getMaxLength());
    }

    @Override
    public boolean isConnected() {
        return this.channel != null && this.channel.isConnected();
    }

    @Override
    public boolean isConnectionPending() {
        return this.channel != null && this.channel.isConnectionPending();
    }

    @Override
    public boolean isClosed() {
        return this.channel == null || !this.channel.isOpen();
    }

    @Override
    public Address localAddress() {
        InetSocketAddress local_addr = null;
        if (this.channel != null) {
            try {
                local_addr = (InetSocketAddress)this.channel.getLocalAddress();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return local_addr != null ? new IpAddress(local_addr) : null;
    }

    public SelectionKey key() {
        return this.key;
    }

    public NioConnection key(SelectionKey k) {
        this.key = k;
        return this;
    }

    public NioConnection copyOnPartialWrite(boolean b) {
        this.copy_on_partial_write = b;
        return this;
    }

    public boolean copyOnPartialWrite() {
        return this.copy_on_partial_write;
    }

    public int numPartialWrites() {
        return this.partial_writes;
    }

    public synchronized void registerSelectionKey(int interest_ops) {
        if (this.key != null && this.key.isValid()) {
            this.key.interestOps(this.key.interestOps() | interest_ops);
        }
    }

    public synchronized void clearSelectionKey(int interest_ops) {
        if (this.key != null && this.key.isValid()) {
            this.key.interestOps(this.key.interestOps() & ~interest_ops);
        }
    }

    @Override
    public void connect(Address dest) throws Exception {
        this.connect(dest, this.server.usePeerConnections());
    }

    protected void connect(Address dest, boolean send_local_addr) throws Exception {
        SocketAddress destAddr = ((IpAddress)dest).getSocketAddress();
        try {
            if (!this.server.deferClientBinding()) {
                this.channel.bind(new InetSocketAddress(this.server.clientBindAddress(), this.server.clientBindPort()));
            }
            this.key = ((NioBaseServer)this.server).register(this.channel, 9, this);
            boolean success = Util.connect(this.channel, destAddr);
            if (success || this.channel.finishConnect()) {
                this.clearSelectionKey(8);
            }
            if (this.channel.getLocalAddress() != null && this.channel.getLocalAddress().equals(destAddr)) {
                throw new IllegalStateException("socket's bind and connect address are the same: " + String.valueOf(destAddr));
            }
            if (send_local_addr) {
                this.sendLocalAddress(this.server.localAddress());
            }
        }
        catch (Exception t) {
            this.close();
            throw t;
        }
    }

    @Override
    public void start() throws Exception {
    }

    @Override
    public void send(byte[] buf, int offset, int length) throws Exception {
        this.send(ByteBuffer.wrap(buf, offset, length));
    }

    @Override
    public void send(ByteBuffer buf) throws Exception {
        this.send(buf, true);
    }

    protected void send(ByteBuffer buf, boolean send_length) throws Exception {
        this.send_lock.lock();
        try {
            if (send_length) {
                this.send_buf.add(this.makeLengthBuffer(buf.remaining()), buf);
            } else {
                this.send_buf.add(buf);
            }
            boolean success = this.send_buf.write(this.channel);
            if (!success) {
                this.registerSelectionKey(4);
                if (this.copy_on_partial_write) {
                    this.send_buf.copy();
                }
                ++this.partial_writes;
            }
        }
        catch (Exception ex) {
            if (!(ex instanceof SocketException || ex instanceof EOFException || ex instanceof ClosedChannelException)) {
                this.server.log.error("%s: failed sending message to %s: %s", this.server.localAddress(), this.peerAddress(), ex);
            }
            throw ex;
        }
        finally {
            this.send_lock.unlock();
        }
    }

    public void send() throws Exception {
        this.send_lock.lock();
        try {
            boolean success = this.send_buf.write(this.channel);
            if (success) {
                this.clearSelectionKey(4);
            } else {
                if (this.copy_on_partial_write) {
                    this.send_buf.copy();
                }
                ++this.partial_writes;
            }
        }
        finally {
            this.send_lock.unlock();
        }
    }

    public void read() throws Exception {
        try {
            while (this._read()) {
                this.updateLastAccessed();
            }
        }
        catch (Exception ex) {
            if (!(ex instanceof SocketException || ex instanceof EOFException || ex instanceof ClosedChannelException)) {
                this.server.log.warn("%s: failed handling message from %s: %s", this.server.localAddress(), this.peerAddress(), ex);
            }
            this.server.closeConnection(this);
            return;
        }
    }

    protected boolean _read() throws Exception {
        Receiver receiver = this.server.receiver();
        if (this.peer_addr == null && this.server.usePeerConnections() && (this.peer_addr = this.readPeerAddress()) != null) {
            this.recv_buf = new Buffers(2).add(ByteBuffer.allocate(4), null).maxLength(this.server.max_length);
            this.server.addConnection(this.peer_addr, this);
            return true;
        }
        ByteBuffer msg = this.recv_buf.readLengthAndData(this.channel);
        if (msg == null) {
            return false;
        }
        if (receiver != null) {
            receiver.receive(this.peer_addr, msg);
        }
        return true;
    }

    @Override
    public void close() throws IOException {
        this.send_lock.lock();
        try {
            if (this.send_buf.remaining() > 0) {
                try {
                    this.send();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.server.socketFactory().close(this.channel);
        }
        finally {
            this.send_lock.unlock();
        }
    }

    @Override
    public void flush() {
        this.send_lock.lock();
        try {
            if (this.send_buf.remaining() > 0) {
                try {
                    this.send();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        finally {
            this.send_lock.unlock();
        }
    }

    public String toString() {
        InetSocketAddress local = null;
        InetSocketAddress remote = null;
        try {
            local = this.channel != null ? (InetSocketAddress)this.channel.getLocalAddress() : null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            remote = this.channel != null ? (InetSocketAddress)this.channel.getRemoteAddress() : null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String loc = local == null ? "n/a" : local.getHostString() + ":" + local.getPort();
        String rem = remote == null ? "n/a" : remote.getHostString() + ":" + remote.getPort();
        return String.format("<%s --> %s> (%d secs old) [%s] [recv_buf: %d]", loc, rem, TimeUnit.SECONDS.convert(this.getTimestamp() - this.last_access, TimeUnit.NANOSECONDS), this.status(), this.recv_buf.get(1) != null ? this.recv_buf.get(1).capacity() : 0);
    }

    @Override
    public String status() {
        if (this.channel == null) {
            return "n/a";
        }
        if (this.isClosed()) {
            return "closed";
        }
        if (this.isConnected()) {
            return "connected";
        }
        if (this.isConnectionPending()) {
            return "connection pending";
        }
        return "open";
    }

    protected void setSocketParameters(Socket client_sock) throws SocketException {
        try {
            if (this.server.sendBufferSize() > 0) {
                client_sock.setSendBufferSize(this.server.sendBufferSize());
            }
        }
        catch (IllegalArgumentException ex) {
            this.server.log.error("%s: exception setting send buffer to %d bytes: %s", this.server.localAddress(), this.server.sendBufferSize(), ex);
        }
        try {
            if (this.server.receiveBufferSize() > 0) {
                client_sock.setReceiveBufferSize(this.server.receiveBufferSize());
            }
        }
        catch (IllegalArgumentException ex) {
            this.server.log.error("%s: exception setting receive buffer to %d bytes: %s", this.server.localAddress(), this.server.receiveBufferSize(), ex);
        }
        client_sock.setKeepAlive(true);
        client_sock.setTcpNoDelay(this.server.tcpNodelay());
        if (this.server.linger() >= 0) {
            client_sock.setSoLinger(true, this.server.linger());
        } else {
            client_sock.setSoLinger(false, -1);
        }
    }

    protected void sendLocalAddress(Address local_addr) throws Exception {
        try {
            int addr_size = local_addr.serializedSize();
            int expected_size = cookie.length + 4 + addr_size;
            ByteArrayDataOutputStream out = new ByteArrayDataOutputStream(expected_size + 2);
            out.write(cookie, 0, cookie.length);
            out.writeShort(Version.version);
            out.writeShort(addr_size);
            local_addr.writeTo(out);
            ByteBuffer buf = ByteBuffer.wrap(out.buffer(), 0, out.position());
            this.send(buf, false);
        }
        catch (Exception ex) {
            this.close();
            throw ex;
        }
    }

    protected Address readPeerAddress() throws Exception {
        block6: while (this.recv_buf.read(this.channel)) {
            int current_position = this.recv_buf.position() - 1;
            ByteBuffer buf = this.recv_buf.get(current_position);
            if (buf == null) {
                return null;
            }
            buf.flip();
            switch (current_position) {
                case 0: {
                    byte[] cookie_buf = NioConnection.getBuffer(buf);
                    if (!Arrays.equals(cookie, cookie_buf)) {
                        throw new IOException(String.format("%s: readPeerAddress(): cookie %s sent by %s does not match own cookie; terminating connection", this.server.localAddress(), Util.byteArrayToHexString(cookie_buf), this.channel.getRemoteAddress()));
                    }
                    this.recv_buf.add(ByteBuffer.allocate(2));
                    continue block6;
                }
                case 1: {
                    short version = buf.getShort();
                    if (!Version.isBinaryCompatible(version)) {
                        throw new IOException(String.format("%s: readPeerAddress(): packet from %s has different version (%s) from ours (%s); discarding it", this.server.localAddress(), this.channel.getRemoteAddress(), Version.print(version), Version.printVersion()));
                    }
                    this.recv_buf.add(ByteBuffer.allocate(2));
                    continue block6;
                }
                case 2: {
                    short addr_len = buf.getShort();
                    this.recv_buf.add(ByteBuffer.allocate(addr_len));
                    continue block6;
                }
                case 3: {
                    byte[] addr_buf = NioConnection.getBuffer(buf);
                    ByteArrayDataInputStream in = new ByteArrayDataInputStream(addr_buf);
                    IpAddress addr = new IpAddress();
                    addr.readFrom(in);
                    return addr;
                }
            }
            throw new IllegalStateException(String.format("position %d is invalid", this.recv_buf.position()));
        }
        return null;
    }

    protected static byte[] getBuffer(ByteBuffer buf) {
        byte[] retval = new byte[buf.limit()];
        buf.get(retval, buf.position(), buf.limit());
        return retval;
    }

    protected ByteBuffer makeLengthBuffer(int length) {
        ((Buffer)this.length_buf).clear();
        this.length_buf.putInt(0, length);
        return this.length_buf;
    }
}

