/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

public record ByteArray(byte[] array, int offset, int length) {
    public ByteArray(byte[] array) {
        this(array, 0, array.length);
    }

    public ByteArray copy() {
        int new_length;
        byte[] new_buf = this.array != null ? new byte[this.length] : null;
        int n = new_length = new_buf != null ? new_buf.length : 0;
        if (new_buf != null) {
            System.arraycopy(this.array, this.offset, new_buf, 0, this.length);
        }
        return new ByteArray(new_buf, 0, new_length);
    }

    public byte[] bytes() {
        if (this.array == null) {
            return null;
        }
        if (this.offset == 0 && this.length == this.array.length) {
            return this.array;
        }
        byte[] tmp = new byte[this.length];
        System.arraycopy(this.array, this.offset, tmp, 0, this.length);
        return tmp;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.length).append(" bytes");
        if (this.offset > 0) {
            sb.append(" (offset=").append(this.offset).append(")");
        }
        return sb.toString();
    }
}

