/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.protocols.TP;
import org.jgroups.util.AsciiString;
import org.jgroups.util.FastArray;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.SubmitToThreadPool;

public class MaxOneThreadPerSender
extends SubmitToThreadPool {
    protected final MessageTable mcasts = new MessageTable();
    protected final MessageTable ucasts = new MessageTable();
    @Property(description="Max number of messages buffered for consumption of the delivery thread in MaxOneThreadPerSender. 0 creates an unbounded buffer")
    protected int max_buffer_size;

    @ManagedOperation(description="Dumps unicast and multicast tables")
    public String dump() {
        return String.format("\nmcasts:\n%s\nucasts:\n%s", this.mcasts, this.ucasts);
    }

    @Override
    public void reset() {
        this.mcasts.map.values().forEach(Entry::reset);
        this.ucasts.map.values().forEach(Entry::reset);
    }

    @Override
    public void init(TP transport) {
        super.init(transport);
    }

    @Override
    public void destroy() {
        this.mcasts.clear();
        this.ucasts.clear();
    }

    @Override
    public boolean loopback(Message msg, boolean oob) {
        if (oob) {
            return super.loopback(msg, oob);
        }
        MessageTable table = msg.getDest() == null ? this.mcasts : this.ucasts;
        return table.process(msg, true);
    }

    @Override
    public boolean loopback(MessageBatch batch, boolean oob) {
        if (oob) {
            return super.loopback(batch, oob);
        }
        MessageTable table = batch.dest() == null ? this.mcasts : this.ucasts;
        return table.process(batch, true);
    }

    @Override
    public boolean process(Message msg, boolean oob) {
        if (oob) {
            return super.process(msg, oob);
        }
        MessageTable table = msg.getDest() == null ? this.mcasts : this.ucasts;
        return table.process(msg, false);
    }

    @Override
    public boolean process(MessageBatch batch, boolean oob) {
        if (oob) {
            return super.process(batch, oob);
        }
        MessageTable table = batch.dest() == null ? this.mcasts : this.ucasts;
        return table.process(batch, false);
    }

    public void viewChange(List<Address> members) {
        this.mcasts.viewChange(members);
        this.ucasts.viewChange(members);
    }

    protected class MessageTable {
        protected final ConcurrentMap<Address, Entry> map = new ConcurrentHashMap<Address, Entry>();

        protected Entry get(Address sender, boolean multicast) {
            Entry e = (Entry)this.map.get(sender);
            if (e != null) {
                return e;
            }
            e = new Entry(sender, multicast, MaxOneThreadPerSender.this.tp.getClusterNameAscii());
            Entry tmp = this.map.putIfAbsent(sender, e);
            return tmp != null ? tmp : e;
        }

        protected void clear() {
            this.map.values().forEach(Entry::trimToInitialCapacity);
            this.map.clear();
        }

        protected boolean process(Message msg, boolean loopback) {
            Address dest = msg.getDest();
            Address sender = msg.getSrc();
            return sender != null && this.get(sender, dest == null).process(msg, loopback);
        }

        protected boolean process(MessageBatch batch, boolean loopback) {
            Address dest = batch.dest();
            Address sender = batch.sender();
            return this.get(sender, dest == null).process(batch, loopback);
        }

        protected void viewChange(List<Address> mbrs) {
            this.map.keySet().retainAll(mbrs);
            this.map.values().forEach(Entry::trimToInitialCapacity);
        }

        public String toString() {
            return this.map.entrySet().stream().map(e -> String.format("%s: %s", e.getKey(), e.getValue())).collect(Collectors.joining("\n"));
        }
    }

    protected class BatchHandlerLoop
    extends SubmitToThreadPool.BatchHandler {
        protected final Entry entry;

        protected BatchHandlerLoop(Entry entry, boolean loopback) {
            super(MaxOneThreadPerSender.this, null, loopback);
            this.entry = entry;
            this.loopback = loopback;
        }

        @Override
        public void run() {
            while (this.entry.workAvailable() || this.entry.adders.decrementAndGet() != 0) {
                try {
                    Address dest;
                    MessageBatch mb = this.entry.batch;
                    if (mb.isEmpty()) continue;
                    if (!mb.multicast() && MaxOneThreadPerSender.this.tp.unicastDestMismatch(mb.dest()) && (dest = MaxOneThreadPerSender.this.tp.addr()) != null) {
                        mb.dest(dest);
                    }
                    MaxOneThreadPerSender.this.tp.passBatchUp(mb, !this.loopback, !this.loopback);
                }
                catch (Throwable t) {
                    MaxOneThreadPerSender.this.log.error("failed processing batch", t);
                }
            }
        }
    }

    protected class Entry {
        protected final Lock lock = new ReentrantLock();
        protected final boolean mcast;
        protected final MessageBatch batch;
        protected final FastArray<Message> msg_queue;
        protected final Address sender;
        protected final AsciiString cluster_name;
        protected final AtomicInteger adders = new AtomicInteger(0);
        protected final LongAdder submitted_batches = new LongAdder();
        protected final LongAdder queued_msgs = new LongAdder();
        protected static final int DEFAULT_INITIAL_CAPACITY = 128;
        protected static final int DEFAULT_INCREMENT = 128;

        protected Entry(Address sender, boolean mcast2, AsciiString cluster_name) {
            this.mcast = mcast2;
            this.sender = sender;
            this.cluster_name = cluster_name;
            int cap = MaxOneThreadPerSender.this.max_buffer_size > 0 ? MaxOneThreadPerSender.this.max_buffer_size : 128;
            Address dest = mcast2 ? null : MaxOneThreadPerSender.this.tp.getAddress();
            this.batch = new MessageBatch(cap).dest(dest).sender(sender).clusterName(cluster_name).multicast(mcast2).mode(MessageBatch.Mode.REG);
            this.batch.array().increment(128);
            this.msg_queue = MaxOneThreadPerSender.this.max_buffer_size > 0 ? new FastArray(MaxOneThreadPerSender.this.max_buffer_size) : new FastArray(128);
            this.msg_queue.increment(128);
        }

        public Entry reset() {
            Stream.of(this.submitted_batches, this.queued_msgs).forEach(LongAdder::reset);
            return this;
        }

        public Entry trimToInitialCapacity() {
            this.lock.lock();
            try {
                this.msg_queue.trimTo(MaxOneThreadPerSender.this.max_buffer_size > 0 ? MaxOneThreadPerSender.this.max_buffer_size : 128);
                this.batch.array().trimTo(MaxOneThreadPerSender.this.max_buffer_size > 0 ? MaxOneThreadPerSender.this.max_buffer_size : 128);
            }
            finally {
                this.lock.unlock();
            }
            return this;
        }

        protected boolean process(Message msg, boolean loopback) {
            this.lock.lock();
            try {
                this.msg_queue.add(msg, MaxOneThreadPerSender.this.max_buffer_size == 0);
            }
            finally {
                this.lock.unlock();
            }
            this.queued_msgs.increment();
            if (this.adders.getAndIncrement() != 0) {
                return false;
            }
            return this.submit(loopback);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean process(MessageBatch batch, boolean loopback) {
            FastArray<Message> fa = batch.array();
            this.lock.lock();
            try {
                this.msg_queue.addAll(fa, MaxOneThreadPerSender.this.max_buffer_size == 0);
            }
            finally {
                this.lock.unlock();
            }
            this.queued_msgs.add(batch.size());
            if (this.adders.getAndIncrement() != 0) {
                return false;
            }
            return this.submit(loopback);
        }

        protected boolean submit(boolean loopback) {
            this.submitted_batches.increment();
            BatchHandlerLoop handler = new BatchHandlerLoop(this, loopback);
            if (!MaxOneThreadPerSender.this.tp.getThreadPool().execute(handler)) {
                this.adders.set(0);
                return false;
            }
            return true;
        }

        protected boolean workAvailable() {
            this.lock.lock();
            try {
                this.batch.clear();
                int num_msgs = this.batch.array().transferFrom(this.msg_queue, true);
                boolean bl = num_msgs > 0;
                return bl;
            }
            catch (Throwable t) {
                boolean bl = false;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        public String toString() {
            return String.format("msg_queue.size=%,d msg_queue.cap: %,d batch.cap=%,d queued msgs=%,d submitted batches=%,d", this.msg_queue.size(), this.msg_queue.capacity(), this.batch.capacity(), this.queued_msgs.sum(), this.submitted_batches.sum());
        }
    }
}

