/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.configuration.global.AbstractGlobalConfigurationBuilder;
import org.infinispan.configuration.global.AllowListConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.SerializationConfiguration;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.protostream.config.Configuration;

public class SerializationConfigurationBuilder
extends AbstractGlobalConfigurationBuilder
implements Builder<SerializationConfiguration> {
    private final AttributeSet attributes;
    private final AllowListConfigurationBuilder allowListBuilder;

    SerializationConfigurationBuilder(GlobalConfigurationBuilder globalConfig) {
        super(globalConfig);
        this.allowListBuilder = new AllowListConfigurationBuilder(globalConfig);
        this.attributes = SerializationConfiguration.attributeDefinitionSet();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public SerializationConfigurationBuilder marshaller(Marshaller marshaller) {
        this.attributes.attribute(SerializationConfiguration.MARSHALLER).set((Object)marshaller);
        return this;
    }

    public Marshaller getMarshaller() {
        return (Marshaller)this.attributes.attribute(SerializationConfiguration.MARSHALLER).get();
    }

    public SerializationConfigurationBuilder addContextInitializer(SerializationContextInitializer sci) {
        if (sci == null) {
            throw new CacheConfigurationException("SerializationContextInitializer cannot be null");
        }
        ((List)this.attributes.attribute(SerializationConfiguration.SERIALIZATION_CONTEXT_INITIALIZERS).computeIfAbsent(ArrayList::new)).add(sci);
        return this;
    }

    public SerializationConfigurationBuilder addContextInitializers(SerializationContextInitializer ... scis) {
        return this.addContextInitializers(Arrays.asList(scis));
    }

    public SerializationConfigurationBuilder addContextInitializers(List<SerializationContextInitializer> scis) {
        ((List)this.attributes.attribute(SerializationConfiguration.SERIALIZATION_CONTEXT_INITIALIZERS).computeIfAbsent(ArrayList::new)).addAll(scis);
        return this;
    }

    public AllowListConfigurationBuilder allowList() {
        return this.allowListBuilder;
    }

    public SerializationConfigurationBuilder schemaCompatibilityValidation(Configuration.SchemaValidation schemaValidation) {
        this.attributes.attribute(SerializationConfiguration.SCHEMA_COMPATIBILITY).set((Object)schemaValidation);
        return this;
    }

    public void validate() {
    }

    public SerializationConfiguration create() {
        return new SerializationConfiguration(this.attributes.protect(), this.allowListBuilder.create());
    }

    public SerializationConfigurationBuilder read(SerializationConfiguration template, Combine combine) {
        this.attributes.read(template.attributes(), combine);
        this.allowListBuilder.read(template.allowList(), combine);
        return this;
    }

    public String toString() {
        return "SerializationConfigurationBuilder [attributes=" + String.valueOf(this.attributes) + "]";
    }
}

