/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.statetransfer;

import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.XSiteStateTransferConfiguration;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.XSiteBackup;
import org.infinispan.xsite.commands.remote.XSiteStatePushRequest;
import org.infinispan.xsite.statetransfer.BaseXSiteStateProviderState;
import org.infinispan.xsite.statetransfer.XSiteState;
import org.infinispan.xsite.statetransfer.XSiteStateProvider;

public class SyncProviderState
extends BaseXSiteStateProviderState<SyncOutboundTask> {
    private static final Log log = LogFactory.getLog(SyncProviderState.class);

    private SyncProviderState(XSiteBackup backup, XSiteStateTransferConfiguration configuration) {
        super(backup, configuration);
    }

    public static SyncProviderState create(BackupConfiguration config) {
        XSiteBackup backup = new XSiteBackup(config.site(), true, config.stateTransfer().timeout());
        return new SyncProviderState(backup, config.stateTransfer());
    }

    @Override
    public boolean isSync() {
        return true;
    }

    @Override
    SyncOutboundTask createTask(Address originator, XSiteStateProvider provider) {
        return new SyncOutboundTask(originator, provider, this);
    }

    static class SyncOutboundTask
    extends BaseXSiteStateProviderState.OutboundTask {
        SyncOutboundTask(Address coordinator, XSiteStateProvider provider, SyncProviderState state) {
            super(coordinator, provider, state);
        }

        public CompletableSource apply(List<XSiteState> xSiteStates) {
            XSiteBackup backup = this.state.getBackup();
            if (log.isDebugEnabled()) {
                log.debugf("Sending chunk to site '%s'. Chunk has %s keys.", backup.getSiteName(), xSiteStates.size());
            }
            XSiteStatePushRequest command = this.provider.getCommandsFactory().buildXSiteStatePushRequest(xSiteStates, backup.getTimeout());
            return Completable.fromCompletionStage(new CommandRetry(backup, command, this.provider, this.state.getWaitTimeMillis(), this.state.getMaxRetries()).send());
        }
    }

    private static class CommandRetry
    extends CompletableFuture<Void>
    implements BiConsumer<Void, Throwable> {
        private final XSiteBackup backup;
        private final XSiteStatePushRequest cmd;
        private final XSiteStateProvider provider;
        private final long waitTimeMillis;
        @GuardedBy(value="this")
        private int maxRetries;

        private CommandRetry(XSiteBackup backup, XSiteStatePushRequest cmd, XSiteStateProvider provider, long waitTimeMillis, int maxRetries) {
            this.backup = backup;
            this.cmd = cmd;
            this.provider = provider;
            this.waitTimeMillis = waitTimeMillis;
            this.maxRetries = maxRetries;
        }

        CompletionStage<Void> send() {
            this.doSend();
            return this;
        }

        void nonBlockingSend() {
            this.provider.getExecutor().execute(this::doSend);
        }

        private void doSend() {
            this.provider.getRpcManager().invokeXSite(this.backup, this.cmd).whenComplete(this);
        }

        @Override
        public void accept(Void o, Throwable throwable) {
            if (throwable != null) {
                if (this.canRetry()) {
                    if (log.isTraceEnabled()) {
                        log.tracef("Command %s is going to be retried.", this.cmd);
                    }
                    if (this.waitTimeMillis <= 0L) {
                        this.send();
                    } else {
                        this.provider.getScheduledExecutorService().schedule(this::nonBlockingSend, this.waitTimeMillis, TimeUnit.MILLISECONDS);
                    }
                } else {
                    if (log.isTraceEnabled()) {
                        log.tracef("Command %s failed.", this.cmd);
                    }
                    Throwable cause = CompletableFutures.extractException((Throwable)throwable);
                    Log.XSITE.unableToSendXSiteState(this.backup.getSiteName(), cause);
                    this.completeExceptionally(cause);
                }
            } else {
                if (log.isTraceEnabled()) {
                    log.tracef("Command %s successful.", this.cmd);
                }
                this.complete(null);
            }
        }

        private synchronized boolean canRetry() {
            return this.maxRetries-- > 0;
        }
    }
}

