/*
 * Decompiled with CFR 0.152.
 */
package com.sun.codemodel;

import com.sun.codemodel.ClassType;
import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JAnonymousClass;
import com.sun.codemodel.JArrayClass;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JDeclaration;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDirectClass;
import com.sun.codemodel.JFormatter;
import com.sun.codemodel.JModule;
import com.sun.codemodel.JNullType;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JPrimitiveType;
import com.sun.codemodel.JType;
import com.sun.codemodel.JTypeVar;
import com.sun.codemodel.SecureLoader;
import com.sun.codemodel.writer.FileCodeWriter;
import com.sun.codemodel.writer.ProgressCodeWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class JCodeModel {
    private final HashMap<String, JPackage> packages = new HashMap();
    private JModule module;
    private final HashMap<Class<?>, JReferencedClass> refClasses = new HashMap();
    private final Map<String, String> classNameReplacer = new HashMap<String, String>();
    public final JNullType NULL = new JNullType(this);
    public final JPrimitiveType VOID = new JPrimitiveType(this, "void", Void.class);
    public final JPrimitiveType BOOLEAN = new JPrimitiveType(this, "boolean", Boolean.class);
    public final JPrimitiveType BYTE = new JPrimitiveType(this, "byte", Byte.class);
    public final JPrimitiveType SHORT = new JPrimitiveType(this, "short", Short.class);
    public final JPrimitiveType CHAR = new JPrimitiveType(this, "char", Character.class);
    public final JPrimitiveType INT = new JPrimitiveType(this, "int", Integer.class);
    public final JPrimitiveType FLOAT = new JPrimitiveType(this, "float", Float.class);
    public final JPrimitiveType LONG = new JPrimitiveType(this, "long", Long.class);
    public final JPrimitiveType DOUBLE = new JPrimitiveType(this, "double", Double.class);
    static final boolean isCaseSensitiveFileSystem = JCodeModel.getFileSystemCaseSensitivity();
    private JClass wildcard;
    public static final Map<Class<?>, Class<?>> primitiveToBox;
    public static final Map<Class<?>, Class<?>> boxToPrimitive;

    private static boolean getFileSystemCaseSensitivity() {
        try {
            if (System.getProperty("com.sun.codemodel.FileSystemCaseSensitive") != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return File.separatorChar == '/';
    }

    public JPackage _package(String name) {
        JPackage p = this.packages.get(name);
        if (p == null) {
            p = new JPackage(name, this);
            this.packages.put(name, p);
        }
        return p;
    }

    public JModule _moduleInfo(String name) {
        this.module = new JModule(name);
        return this.module;
    }

    public JModule _getModuleInfo() {
        return this.module;
    }

    public void _prepareModuleInfo(String name, String ... requires) {
        this._moduleInfo(name);
        this._updateModuleInfo(requires);
    }

    public void _updateModuleInfo(String ... requires) {
        if (this.module == null) {
            throw new IllegalStateException("Java module instance was not initialized yet.");
        }
        this.module._exports(this.packages.values(), false);
        this.module._requires(requires);
    }

    public JPackage rootPackage() {
        return this._package("");
    }

    public Iterator<JPackage> packages() {
        return this.packages.values().iterator();
    }

    public JDefinedClass _class(String fullyqualifiedName) throws JClassAlreadyExistsException {
        return this._class(fullyqualifiedName, ClassType.CLASS);
    }

    public JClass directClass(String name) {
        return new JDirectClass(this, name);
    }

    public JDefinedClass _class(int mods, String fullyqualifiedName, ClassType t) throws JClassAlreadyExistsException {
        int idx = fullyqualifiedName.lastIndexOf(46);
        if (idx < 0) {
            return this.rootPackage()._class(fullyqualifiedName);
        }
        return this._package(fullyqualifiedName.substring(0, idx))._class(mods, fullyqualifiedName.substring(idx + 1), t);
    }

    public JDefinedClass _class(String fullyqualifiedName, ClassType t) throws JClassAlreadyExistsException {
        return this._class(1, fullyqualifiedName, t);
    }

    public JDefinedClass _getClass(String fullyQualifiedName) {
        int idx = fullyQualifiedName.lastIndexOf(46);
        if (idx < 0) {
            return this.rootPackage()._getClass(fullyQualifiedName);
        }
        return this._package(fullyQualifiedName.substring(0, idx))._getClass(fullyQualifiedName.substring(idx + 1));
    }

    @Deprecated
    public JDefinedClass newAnonymousClass(JClass baseType) {
        return new JAnonymousClass(baseType);
    }

    public JDefinedClass anonymousClass(JClass baseType) {
        return new JAnonymousClass(baseType);
    }

    public JDefinedClass anonymousClass(Class<?> baseType) {
        return this.anonymousClass(this.ref(baseType));
    }

    public void build(File destDir, PrintStream status) throws IOException {
        this.build(destDir, destDir, status);
    }

    public void build(File srcDir, File resourceDir, PrintStream status) throws IOException {
        CodeWriter src = new FileCodeWriter(srcDir);
        CodeWriter res = new FileCodeWriter(resourceDir);
        if (status != null) {
            src = new ProgressCodeWriter(src, status);
            res = new ProgressCodeWriter(res, status);
        }
        this.build(src, res);
    }

    public void build(File destDir) throws IOException {
        this.build(destDir, System.out);
    }

    public void build(File srcDir, File resourceDir) throws IOException {
        this.build(srcDir, resourceDir, System.out);
    }

    public void build(CodeWriter out) throws IOException {
        this.build(out, out);
    }

    public void build(CodeWriter source, CodeWriter resource) throws IOException {
        JPackage[] pkgs;
        for (JPackage pkg : pkgs = this.packages.values().toArray(new JPackage[0])) {
            pkg.build(source, resource);
        }
        if (this.module != null) {
            this.module.build(source);
        }
        source.close();
        resource.close();
    }

    public int countArtifacts() {
        JPackage[] pkgs;
        int r = 0;
        for (JPackage pkg : pkgs = this.packages.values().toArray(new JPackage[0])) {
            r += pkg.countArtifacts();
        }
        return r;
    }

    public void addClassNameReplacer(String c1, String c2) {
        this.classNameReplacer.put(c1, c2);
    }

    public Map<String, String> classNameReplacer() {
        return Collections.unmodifiableMap(this.classNameReplacer);
    }

    public JClass ref(Class<?> clazz) {
        JReferencedClass jrc = this.refClasses.get(clazz);
        if (jrc == null) {
            if (clazz.isPrimitive()) {
                throw new IllegalArgumentException(clazz + " is a primitive");
            }
            if (clazz.isArray()) {
                return new JArrayClass(this, this._ref(clazz.getComponentType()));
            }
            jrc = new JReferencedClass(clazz);
            this.refClasses.put(clazz, jrc);
        }
        return jrc;
    }

    public JType _ref(Class<?> c) {
        if (c.isPrimitive()) {
            return JType.parse(this, c.getName());
        }
        return this.ref(c);
    }

    public JClass ref(String fullyQualifiedClassName) {
        try {
            return this.ref(SecureLoader.getContextClassLoader().loadClass(fullyQualifiedClassName));
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                return this.ref(Class.forName(fullyQualifiedClassName));
            }
            catch (ClassNotFoundException classNotFoundException2) {
                return new JDirectClass(this, fullyQualifiedClassName);
            }
        }
    }

    public JClass wildcard() {
        if (this.wildcard == null) {
            this.wildcard = this.ref(Object.class).wildcard();
        }
        return this.wildcard;
    }

    public JType parseType(String name) {
        if (name.endsWith("[]")) {
            return this.parseType(name.substring(0, name.length() - 2)).array();
        }
        try {
            return JType.parse(this, name);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new TreeParser().parseTypeName(name);
        }
    }

    static {
        HashMap<Class<Void>, Class<Object>> m1 = new HashMap<Class<Void>, Class<Object>>();
        HashMap<Class, Class> m2 = new HashMap<Class, Class>();
        m1.put(Boolean.class, Boolean.TYPE);
        m1.put(Byte.class, Byte.TYPE);
        m1.put(Character.class, Character.TYPE);
        m1.put(Double.class, Double.TYPE);
        m1.put(Float.class, Float.TYPE);
        m1.put(Integer.class, Integer.TYPE);
        m1.put(Long.class, Long.TYPE);
        m1.put(Short.class, Short.TYPE);
        m1.put(Void.class, Void.TYPE);
        for (Map.Entry e : m1.entrySet()) {
            m2.put((Class)e.getValue(), (Class)e.getKey());
        }
        boxToPrimitive = Collections.unmodifiableMap(m1);
        primitiveToBox = Collections.unmodifiableMap(m2);
    }

    private class JReferencedClass
    extends JClass
    implements JDeclaration {
        private final Class<?> _class;

        JReferencedClass(Class<?> _clazz) {
            super(JCodeModel.this);
            this._class = _clazz;
            assert (!this._class.isArray());
        }

        @Override
        public String name() {
            return this._class.getSimpleName().replace('$', '.');
        }

        @Override
        public String fullName() {
            return this._class.getName().replace('$', '.');
        }

        @Override
        public String binaryName() {
            return this._class.getName();
        }

        @Override
        public JClass outer() {
            Class<?> p = this._class.getDeclaringClass();
            if (p == null) {
                return null;
            }
            return JCodeModel.this.ref(p);
        }

        @Override
        public JPackage _package() {
            String name = this.fullName();
            if (name.indexOf(91) != -1) {
                return JCodeModel.this._package("");
            }
            int idx = name.lastIndexOf(46);
            if (idx < 0) {
                return JCodeModel.this._package("");
            }
            return JCodeModel.this._package(name.substring(0, idx));
        }

        @Override
        public JClass _extends() {
            Class<?> sp = this._class.getSuperclass();
            if (sp == null) {
                if (this.isInterface()) {
                    return this.owner().ref(Object.class);
                }
                return null;
            }
            return JCodeModel.this.ref(sp);
        }

        @Override
        public Iterator<JClass> _implements() {
            final Class[] interfaces = this._class.getInterfaces();
            return new Iterator<JClass>(){
                private int idx = 0;

                @Override
                public boolean hasNext() {
                    return this.idx < interfaces.length;
                }

                @Override
                public JClass next() {
                    return JCodeModel.this.ref(interfaces[this.idx++]);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public boolean isInterface() {
            return this._class.isInterface();
        }

        @Override
        public boolean isAbstract() {
            return Modifier.isAbstract(this._class.getModifiers());
        }

        @Override
        public JPrimitiveType getPrimitiveType() {
            Class<?> v = boxToPrimitive.get(this._class);
            if (v != null) {
                return JType.parse(JCodeModel.this, v.getName());
            }
            return null;
        }

        @Override
        public boolean isArray() {
            return false;
        }

        @Override
        public void declare(JFormatter f) {
        }

        @Override
        public JTypeVar[] typeParams() {
            return super.typeParams();
        }

        @Override
        protected JClass substituteParams(JTypeVar[] variables, List<JClass> bindings) {
            return this;
        }
    }

    private final class TypeNameParser {
        private final String s;
        private int idx;

        public TypeNameParser(String s) {
            this.s = s;
        }

        JClass parseTypeName() {
            char ch;
            int start = this.idx;
            if (this.s.charAt(this.idx) == '?') {
                ++this.idx;
                this.ws();
                String head = this.s.substring(this.idx);
                if (head.startsWith("extends")) {
                    this.idx += 7;
                    this.ws();
                    return this.parseTypeName().wildcard();
                }
                if (head.startsWith("super")) {
                    throw new UnsupportedOperationException("? super T not implemented");
                }
                throw new IllegalArgumentException("only extends/super can follow ?, but found " + this.s.substring(this.idx));
            }
            while (this.idx < this.s.length() && (Character.isJavaIdentifierStart(ch = this.s.charAt(this.idx)) || Character.isJavaIdentifierPart(ch) || ch == '.')) {
                ++this.idx;
            }
            JClass clazz = JCodeModel.this.ref(this.s.substring(start, this.idx));
            return this.parseSuffix(clazz);
        }

        private JClass parseSuffix(JClass clazz) {
            if (this.idx == this.s.length()) {
                return clazz;
            }
            char ch = this.s.charAt(this.idx);
            if (ch == '<') {
                return this.parseSuffix(this.parseArguments(clazz));
            }
            if (ch == '[') {
                if (this.s.charAt(this.idx + 1) == ']') {
                    this.idx += 2;
                    return this.parseSuffix(clazz.array());
                }
                throw new IllegalArgumentException("Expected ']' but found " + this.s.substring(this.idx + 1));
            }
            return clazz;
        }

        private void ws() {
            while (Character.isWhitespace(this.s.charAt(this.idx)) && this.idx < this.s.length()) {
                ++this.idx;
            }
        }

        private JClass parseArguments(JClass rawType) {
            if (this.s.charAt(this.idx) != '<') {
                throw new IllegalArgumentException();
            }
            ++this.idx;
            ArrayList<JClass> args = new ArrayList<JClass>();
            while (true) {
                args.add(this.parseTypeName());
                if (this.idx == this.s.length()) {
                    throw new IllegalArgumentException("Missing '>' in " + this.s);
                }
                char ch = this.s.charAt(this.idx);
                if (ch == '>') {
                    return rawType.narrow(args.toArray(new JClass[0]));
                }
                if (ch != ',') {
                    throw new IllegalArgumentException(this.s);
                }
                ++this.idx;
            }
        }
    }

    private static class Node {
        private String value;
        private JClass jClass;
        private final Node parent;
        private final List<Node> childs = new LinkedList<Node>();

        public Node(Node parent) {
            this.parent = parent;
        }

        public String toString() {
            boolean hasChilds;
            StringBuilder builder = new StringBuilder(this.value);
            boolean bl = hasChilds = !this.childs.isEmpty();
            if (hasChilds) {
                builder.append("<");
            }
            for (Node child : this.childs) {
                builder.append(child.toString()).append(",");
            }
            if (hasChilds) {
                builder.deleteCharAt(builder.length() - 1);
                builder.append(">");
            }
            return builder.toString();
        }
    }

    private class TreeParser {
        private TreeParser() {
        }

        private Node buildTree(String str) {
            StringBuilder content = new StringBuilder();
            Node root = new Node(null);
            root.value = str;
            Node current = root;
            for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                if (c == '<') {
                    Node child = new Node(current);
                    current.value = content.toString();
                    current.childs.add(child);
                    current = child;
                    content = new StringBuilder();
                    continue;
                }
                if (c == '>') {
                    if (current.value == null) {
                        current.value = content.toString();
                    }
                    current = current.parent;
                    content = new StringBuilder();
                    continue;
                }
                if (c == ',') {
                    if (current.value == null) {
                        current.value = content.toString();
                    }
                    Node brother = new Node(current.parent);
                    brother.parent.childs.add(brother);
                    current = brother;
                    content = new StringBuilder();
                    continue;
                }
                content.append(c);
            }
            return root;
        }

        private void postOrderCreateJClass(Node node) {
            if (node != null) {
                for (Node child : node.childs) {
                    this.postOrderCreateJClass(child);
                }
                node.jClass = new TypeNameParser(node.value).parseTypeName();
                if (!node.childs.isEmpty()) {
                    JClass[] argsA = (JClass[])node.childs.stream().map(n -> n.jClass).toArray(JClass[]::new);
                    node.jClass = node.jClass.narrow(argsA);
                }
            }
        }

        private JClass parseTypeName(String str) {
            Node root = this.buildTree(str);
            this.postOrderCreateJClass(root);
            return root.jClass;
        }
    }
}

