/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.EncryptedStringValue;
import com.xebialabs.deployit.core.StringValue;
import com.xebialabs.deployit.util.PasswordEncrypter;
import java.util.function.Function;

public class StringValueConverter {
    public static final String ENCRYPTED_PREFIX = "e{";
    public static final String PLAIN_PREFIX = "u{";
    public static final String SUFFIX = "}";
    private final PasswordEncrypter passwordEncrypter;

    public StringValueConverter(PasswordEncrypter passwordEncrypter) {
        this.passwordEncrypter = (PasswordEncrypter)Checks.checkNotNull((Object)passwordEncrypter, (String)"passwordEncrypter");
    }

    public static final Function<StringValue, String> valueToString(PasswordEncrypter passwordEncrypter) {
        return StringValueConverter.valueToString(passwordEncrypter, false);
    }

    public static final Function<StringValue, String> valueToString(PasswordEncrypter passwordEncrypter, boolean fallbackEncrypted) {
        StringValueConverter converter = new StringValueConverter(passwordEncrypter);
        return input -> converter.convert((StringValue)input, fallbackEncrypted);
    }

    public static final Function<String, StringValue> stringToValue(PasswordEncrypter passwordEncrypter) {
        StringValueConverter converter = new StringValueConverter(passwordEncrypter);
        return input -> converter.convert((String)input);
    }

    public String convert(StringValue v, boolean keepPlainAsIs) {
        if (v instanceof EncryptedStringValue) {
            return ENCRYPTED_PREFIX + this.passwordEncrypter.ensureEncrypted(v.toString()) + SUFFIX;
        }
        if (!keepPlainAsIs) {
            return PLAIN_PREFIX + v.toString() + SUFFIX;
        }
        return v.toString();
    }

    String convert(StringValue v) {
        return this.convert(v, false);
    }

    public StringValue convert(String s) {
        return this.convert(s, false);
    }

    public StringValue convert(String s, boolean fallbackEncrypted) {
        if (s.startsWith(ENCRYPTED_PREFIX)) {
            String substring = s.substring(ENCRYPTED_PREFIX.length(), s.length() - SUFFIX.length());
            return new EncryptedStringValue(this.passwordEncrypter.ensureDecrypted(substring));
        }
        if (s.startsWith(PLAIN_PREFIX)) {
            String substring = s.substring(PLAIN_PREFIX.length(), s.length() - SUFFIX.length());
            return new StringValue(substring);
        }
        if (fallbackEncrypted) {
            return new EncryptedStringValue(s);
        }
        return new StringValue(s);
    }
}

