/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import jakarta.persistence.Converter;
import org.hibernate.type.CharBooleanConverter;

@Converter
public class TrueFalseConverter
extends CharBooleanConverter {
    public static final TrueFalseConverter INSTANCE = new TrueFalseConverter();
    private static final String[] VALUES = new String[]{"F", "T"};

    @Override
    protected String[] getValues() {
        return VALUES;
    }

    @Override
    public Boolean toDomainValue(Character relationalForm) {
        if (relationalForm == null) {
            return null;
        }
        switch (relationalForm.charValue()) {
            case 'T': {
                return true;
            }
            case 'F': {
                return false;
            }
        }
        return null;
    }

    @Override
    public Character toRelationalValue(Boolean domainForm) {
        if (domainForm == null) {
            return null;
        }
        return Character.valueOf(domainForm != false ? (char)'T' : 'F');
    }
}

