/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.format.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.format.FormatMapper;
import org.hibernate.type.format.FormatMapperCreationContext;
import org.hibernate.type.format.jackson.JacksonIntegration;

public final class JacksonXmlFormatMapper
implements FormatMapper {
    public static final String SHORT_NAME = "jackson-xml";
    private final ObjectMapper objectMapper;

    public JacksonXmlFormatMapper() {
        this((ObjectMapper)JacksonXmlFormatMapper.createXmlMapper(ObjectMapper.findModules((ClassLoader)JacksonXmlFormatMapper.class.getClassLoader())));
    }

    public JacksonXmlFormatMapper(FormatMapperCreationContext creationContext) {
        this((ObjectMapper)JacksonXmlFormatMapper.createXmlMapper(JacksonIntegration.loadModules(creationContext)));
    }

    public JacksonXmlFormatMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    private static XmlMapper createXmlMapper(List<Module> modules) {
        XmlMapper xmlMapper = new XmlMapper();
        xmlMapper.registerModules(modules);
        xmlMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        xmlMapper.enable(ToXmlGenerator.Feature.WRITE_NULLS_AS_XSI_NIL);
        SimpleModule module = new SimpleModule();
        module.addDeserializer(String[].class, (JsonDeserializer)new StringArrayDeserializer());
        xmlMapper.registerModule((Module)module);
        return xmlMapper;
    }

    @Override
    public <T> T fromString(CharSequence charSequence, JavaType<T> javaType, WrapperOptions wrapperOptions) {
        if (javaType.getJavaType() == String.class || javaType.getJavaType() == Object.class) {
            return (T)charSequence.toString();
        }
        try {
            return (T)this.objectMapper.readValue(charSequence.toString(), this.objectMapper.constructType(javaType.getJavaType()));
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Could not deserialize string to java type: " + String.valueOf(javaType), e);
        }
    }

    @Override
    public <T> String toString(T value, JavaType<T> javaType, WrapperOptions wrapperOptions) {
        if (javaType.getJavaType() == String.class || javaType.getJavaType() == Object.class) {
            return (String)value;
        }
        return this.writeValueAsString(value, javaType, javaType.getJavaType());
    }

    private <T> String writeValueAsString(Object value, JavaType<T> javaType, Type type) {
        try {
            return this.objectMapper.writerFor(this.objectMapper.constructType(type)).writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Could not serialize object of java type: " + String.valueOf(javaType), e);
        }
    }

    private static class StringArrayDeserializer
    extends JsonDeserializer<String[]> {
        private StringArrayDeserializer() {
        }

        public String[] deserialize(JsonParser jp, DeserializationContext deserializationContext) throws IOException {
            JsonToken token;
            ArrayList<String> result = new ArrayList<String>();
            while ((token = jp.nextValue()) != JsonToken.END_OBJECT) {
                if (!token.isScalarValue()) continue;
                result.add(jp.getValueAsString());
            }
            return (String[])result.toArray(String[]::new);
        }
    }
}

