/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.impl;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.MalformedProtobufException;
import org.infinispan.protostream.ProtobufTagMarshaller;
import org.infinispan.protostream.TagReader;
import org.infinispan.protostream.descriptors.WireType;
import org.infinispan.protostream.impl.Log;
import org.infinispan.protostream.impl.ProtoStreamReaderImpl;
import org.infinispan.protostream.impl.SerializationContextImpl;
import org.infinispan.protostream.impl.VarHandlesUtil;

public final class TagReaderImpl
implements TagReader,
ProtobufTagMarshaller.ReadContext {
    private static final Log log = Log.LogFactory.getLog(TagReaderImpl.class);
    private static final Charset UTF8 = StandardCharsets.UTF_8;
    private static final byte[] EMPTY = new byte[0];
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.wrap(EMPTY);
    private final SerializationContextImpl serCtx;
    private final Decoder decoder;
    private final TagReaderImpl parent;
    private Map<Object, Object> params = null;
    @Deprecated
    private ProtoStreamReaderImpl reader = null;
    private int startingPos;

    private TagReaderImpl(TagReaderImpl parent, Decoder decoder) {
        this.parent = parent;
        this.serCtx = parent.serCtx;
        this.decoder = decoder;
        this.startingPos = decoder.getPos();
    }

    private TagReaderImpl(SerializationContextImpl serCtx, Decoder decoder) {
        this.parent = null;
        this.serCtx = serCtx;
        this.decoder = decoder;
        this.startingPos = decoder.getPos();
    }

    public static TagReaderImpl newNestedInstance(ProtobufTagMarshaller.ReadContext parent, InputStream input) {
        return new TagReaderImpl((TagReaderImpl)parent, (Decoder)new InputStreamDecoder(input));
    }

    public static TagReaderImpl newNestedInstance(ProtobufTagMarshaller.ReadContext parent, byte[] buf) {
        return new TagReaderImpl((TagReaderImpl)parent, (Decoder)new ByteArrayDecoder(buf, 0, buf.length));
    }

    public static TagReaderImpl newNestedInstance(ProtobufTagMarshaller.ReadContext parent, ByteBuffer buf) {
        Decoder decoder = buf.hasArray() ? new ByteArrayDecoder(buf.array(), buf.arrayOffset() + buf.position(), buf.remaining()) : new ByteBufferDecoder(buf);
        return new TagReaderImpl((TagReaderImpl)parent, decoder);
    }

    public static TagReaderImpl newInstance(ImmutableSerializationContext serCtx, InputStream input) throws IOException {
        return new TagReaderImpl((SerializationContextImpl)serCtx, (Decoder)new InputStreamDecoder(input));
    }

    public static TagReaderImpl newInstance(ImmutableSerializationContext serCtx, InputStream input, int length) throws IOException {
        Decoder decoder;
        if (length < 512) {
            byte[] bytes = input.readNBytes(length);
            if (bytes.length != length) {
                throw log.messageTruncated();
            }
            decoder = new ByteArrayDecoder(bytes, 0, length);
        } else {
            decoder = new LimitedInputStreamDecoder(input, length);
        }
        return new TagReaderImpl((SerializationContextImpl)serCtx, decoder);
    }

    public static TagReaderImpl newInstance(ImmutableSerializationContext serCtx, ByteBuffer buf) {
        Decoder decoder = buf.hasArray() ? new ByteArrayDecoder(buf.array(), buf.arrayOffset() + buf.position(), buf.remaining()) : new ByteBufferDecoder(buf);
        return new TagReaderImpl((SerializationContextImpl)serCtx, decoder);
    }

    public static TagReaderImpl newInstance(ImmutableSerializationContext serCtx, byte[] buf) {
        return new TagReaderImpl((SerializationContextImpl)serCtx, (Decoder)new ByteArrayDecoder(buf, 0, buf.length));
    }

    public static TagReaderImpl newInstance(ImmutableSerializationContext serCtx, byte[] buf, int offset, int length) {
        return new TagReaderImpl((SerializationContextImpl)serCtx, (Decoder)new ByteArrayDecoder(buf, offset, length));
    }

    @Override
    public boolean isAtEnd() throws IOException {
        return this.decoder.isAtEnd();
    }

    @Override
    public int readTag() throws IOException {
        return this.decoder.readTag();
    }

    @Override
    public byte readByteTag() throws IOException {
        return this.decoder.readByteTag();
    }

    @Override
    public void checkLastTagWas(int tag) throws IOException {
        this.decoder.checkLastTagWas(tag);
    }

    @Override
    public boolean skipField(int tag) throws IOException {
        return this.decoder.skipField(tag);
    }

    @Override
    public long readUInt64() throws IOException {
        return this.decoder.readVarint64();
    }

    @Override
    public long readInt64() throws IOException {
        return this.decoder.readVarint64();
    }

    @Override
    public int readInt32() throws IOException {
        return this.decoder.readVarint32();
    }

    @Override
    public long readFixed64() throws IOException {
        return this.decoder.readFixed64();
    }

    @Override
    public int readFixed32() throws IOException {
        return this.decoder.readFixed32();
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.decoder.readFixed64());
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.decoder.readFixed32());
    }

    @Override
    public boolean readBool() throws IOException {
        byte val = this.decoder.readRawByte();
        if ((val & 0xFE) != 0) {
            throw new MalformedProtobufException("Boolean byte contained a bit other than least significant set, was " + val);
        }
        return (long)val != 0L;
    }

    @Override
    public String readString() throws IOException {
        return this.decoder.readString();
    }

    @Override
    public byte[] readByteArray() throws IOException {
        int length = this.decoder.readVarint32();
        return this.decoder.readRawByteArray(length);
    }

    @Override
    public ByteBuffer readByteBuffer() throws IOException {
        int length = this.decoder.readVarint32();
        return this.decoder.readRawByteBuffer(length);
    }

    @Override
    public int readUInt32() throws IOException {
        return this.decoder.readVarint32();
    }

    @Override
    public int readEnum() throws IOException {
        return this.decoder.readVarint32();
    }

    @Override
    public int readSFixed32() throws IOException {
        return this.decoder.readFixed32();
    }

    @Override
    public long readSFixed64() throws IOException {
        return this.decoder.readFixed64();
    }

    @Override
    public int readSInt32() throws IOException {
        int value = this.decoder.readVarint32();
        return value >>> 1 ^ -(value & 1);
    }

    @Override
    public long readSInt64() throws IOException {
        long value = this.decoder.readVarint64();
        return value >>> 1 ^ -(value & 1L);
    }

    @Override
    public int pushLimit(int limit) throws IOException {
        this.startingPos = this.decoder.getPos();
        return this.decoder.pushLimit(limit);
    }

    @Override
    public void popLimit(int oldLimit) {
        this.decoder.popLimit(oldLimit);
    }

    @Override
    public SerializationContextImpl getSerializationContext() {
        return this.serCtx;
    }

    @Override
    public Object getParam(Object key) {
        if (this.parent != null) {
            return this.parent.getParam(key);
        }
        if (this.params == null) {
            return null;
        }
        return this.params.get(key);
    }

    @Override
    public void setParam(Object key, Object value) {
        if (this.parent != null) {
            this.parent.setParam(key, value);
        } else {
            if (this.params == null) {
                this.params = new HashMap<Object, Object>();
            }
            this.params.put(key, value);
        }
    }

    @Override
    public TagReader getReader() {
        return this;
    }

    @Override
    public byte[] fullBufferArray() throws IOException {
        this.checkBufferUnused("fullBufferArray");
        return this.decoder.getBufferArray(this.startingPos);
    }

    @Override
    public InputStream fullBufferInputStream() throws IOException {
        this.checkBufferUnused("fullBufferInputStream");
        if (this.isInputStream()) {
            return ((InputStreamDecoder)this.decoder).getInputStream();
        }
        return new ByteArrayInputStream(this.decoder.getBufferArray(this.startingPos));
    }

    private void checkBufferUnused(String methodName) {
        if (this.decoder.getPos() > this.startingPos) {
            throw new IllegalStateException(methodName + " in marshaller can only be used on an unprocessed buffer");
        }
    }

    @Override
    public boolean isInputStream() {
        return this.decoder instanceof InputStreamDecoder;
    }

    public ProtoStreamReaderImpl getProtoStreamReader() {
        if (this.parent != null) {
            return this.parent.getProtoStreamReader();
        }
        if (this.reader == null) {
            this.reader = new ProtoStreamReaderImpl(this, this.serCtx);
        }
        return this.reader;
    }

    private static abstract class Decoder {
        protected int globalLimit = Integer.MAX_VALUE;
        protected int lastTag;

        private Decoder() {
        }

        abstract int getEnd();

        abstract int getPos();

        abstract byte[] getBufferArray(int var1) throws IOException;

        abstract boolean isAtEnd() throws IOException;

        final int readTag() throws IOException {
            if (this.isAtEnd()) {
                this.lastTag = 0;
                return 0;
            }
            long tag = this.readVarint64();
            this.lastTag = (int)tag;
            if ((long)this.lastTag != tag) {
                throw new MalformedProtobufException("Found a protobuf tag (" + tag + ") greater than the largest allowed value");
            }
            WireType.fromTag(this.lastTag);
            if (WireType.getTagFieldNumber(this.lastTag) >= 1) {
                return this.lastTag;
            }
            throw new MalformedProtobufException("Found an invalid protobuf tag (" + this.lastTag + ") having a field number smaller than 1");
        }

        final byte readByteTag() throws IOException {
            if (this.isAtEnd()) {
                this.lastTag = 0;
                return 0;
            }
            byte tag = this.readRawByte();
            this.lastTag = tag;
            WireType.fromTag(this.lastTag);
            return tag;
        }

        final void checkLastTagWas(int expectedTag) throws IOException {
            if (this.lastTag == expectedTag || expectedTag == 0 && this.isAtEnd()) {
                return;
            }
            if (expectedTag == 0) {
                throw new MalformedProtobufException("Expected end of message but found tag " + this.lastTag);
            }
            throw new MalformedProtobufException("Protobuf message end group tag expected but found " + this.lastTag);
        }

        final boolean skipField(int tag) throws IOException {
            switch (WireType.getTagWireType(tag)) {
                case 0: {
                    this.skipVarint();
                    return true;
                }
                case 5: {
                    this.skipRawBytes(4);
                    return true;
                }
                case 1: {
                    this.skipRawBytes(8);
                    return true;
                }
                case 2: {
                    this.skipRawBytes(this.readVarint32());
                    return true;
                }
                case 3: {
                    int t;
                    while ((t = this.readTag()) != 0 && this.skipField(t)) {
                    }
                    this.checkLastTagWas(WireType.makeTag(WireType.getTagFieldNumber(tag), 4));
                    return true;
                }
                case 4: {
                    return false;
                }
            }
            throw new MalformedProtobufException("Found a protobuf tag with invalid wire type : " + tag);
        }

        abstract void skipVarint() throws IOException;

        abstract void skipRawBytes(int var1) throws IOException;

        abstract String readString() throws IOException;

        abstract byte readRawByte() throws IOException;

        abstract byte[] readRawByteArray(int var1) throws IOException;

        abstract ByteBuffer readRawByteBuffer(int var1) throws IOException;

        final int readVarint32() throws IOException {
            return (int)this.readVarint64();
        }

        abstract long readVarint64() throws IOException;

        abstract int readFixed32() throws IOException;

        abstract long readFixed64() throws IOException;

        abstract int pushLimit(int var1) throws IOException;

        abstract void popLimit(int var1);

        abstract int setGlobalLimit(int var1);
    }

    private static final class InputStreamDecoder
    extends Decoder {
        private final InputStream in;
        private int pos;
        private int limit = Integer.MAX_VALUE;

        private InputStreamDecoder(InputStream in) {
            if (in == null) {
                throw new IllegalArgumentException("input stream cannot be null");
            }
            this.in = in.markSupported() ? in : new PushbackInputStream(in);
        }

        @Override
        String readString() throws IOException {
            int length = this.readVarint32();
            if (length > 0 && length <= this.limit - this.pos) {
                byte[] bytes = this.readRawByteArray(length);
                return new String(bytes, 0, length, UTF8);
            }
            if (length == 0) {
                return "";
            }
            if (length < 0) {
                throw log.negativeLength();
            }
            throw log.messageTruncated();
        }

        @Override
        ByteBuffer readRawByteBuffer(int length) throws IOException {
            if (length == 0) {
                return EMPTY_BUFFER;
            }
            byte[] bytes = this.readRawByteArray(length);
            return ByteBuffer.wrap(bytes);
        }

        @Override
        protected void skipVarint() throws IOException {
            for (int i = 0; i < 10; ++i) {
                if (this.readRawByte() < 0) continue;
                return;
            }
            throw log.malformedVarint();
        }

        @Override
        long readVarint64() throws IOException {
            long value = 0L;
            for (int i = 0; i < 64; i += 7) {
                byte b = this.readRawByte();
                value |= (long)(b & 0x7F) << i;
                if (b < 0) continue;
                return value;
            }
            throw log.malformedVarint();
        }

        @Override
        int readFixed32() throws IOException {
            if (this.limit - this.pos < 4) {
                throw log.messageTruncated();
            }
            return this.readRawByte() & 0xFF | (this.readRawByte() & 0xFF) << 8 | (this.readRawByte() & 0xFF) << 16 | (this.readRawByte() & 0xFF) << 24;
        }

        @Override
        long readFixed64() throws IOException {
            if (this.limit - this.pos < 8) {
                throw log.messageTruncated();
            }
            return (long)this.readRawByte() & 0xFFL | ((long)this.readRawByte() & 0xFFL) << 8 | ((long)this.readRawByte() & 0xFFL) << 16 | ((long)this.readRawByte() & 0xFFL) << 24 | ((long)this.readRawByte() & 0xFFL) << 32 | ((long)this.readRawByte() & 0xFFL) << 40 | ((long)this.readRawByte() & 0xFFL) << 48 | ((long)this.readRawByte() & 0xFFL) << 56;
        }

        @Override
        int setGlobalLimit(int globalLimit) {
            if (globalLimit < 0) {
                throw new IllegalArgumentException("Global limit cannot be negative: " + globalLimit);
            }
            int oldGlobalLimit = this.globalLimit;
            this.globalLimit = globalLimit;
            return oldGlobalLimit;
        }

        @Override
        int pushLimit(int limit) throws IOException {
            if (limit < 0) {
                throw log.negativeLength();
            }
            int oldLimit = this.limit;
            if ((limit = this.pos + limit) > oldLimit) {
                throw log.messageTruncated();
            }
            this.limit = limit;
            return oldLimit;
        }

        @Override
        void popLimit(int oldLimit) {
            this.limit = oldLimit;
        }

        @Override
        int getEnd() {
            return this.limit;
        }

        @Override
        int getPos() {
            return this.pos;
        }

        @Override
        byte[] getBufferArray(int offset) throws IOException {
            if (offset != 0) {
                throw new IllegalArgumentException("getBufferArray not supported with a non 0 offset, received " + offset);
            }
            if (this.globalLimit == Integer.MAX_VALUE) {
                this.pos = Integer.MAX_VALUE;
                return this.in.readAllBytes();
            }
            int length = this.globalLimit - this.pos;
            return this.readRawByteArray(length);
        }

        InputStream getInputStream() {
            return this.in;
        }

        @Override
        boolean isAtEnd() throws IOException {
            return this.pos == this.limit || this.in.available() <= 0;
        }

        @Override
        byte readRawByte() throws IOException {
            if (this.pos >= this.limit) {
                throw log.messageTruncated();
            }
            int byteValue = this.in.read();
            if (byteValue < 0) {
                throw log.messageTruncated();
            }
            ++this.pos;
            return (byte)byteValue;
        }

        @Override
        byte[] readRawByteArray(int length) throws IOException {
            if (length > 0 && length <= this.limit - this.pos) {
                int readAmount;
                this.pos += length;
                if (this.pos > this.globalLimit) {
                    throw log.globalLimitExceeded();
                }
                int readTotal = 0;
                byte[] array = new byte[length];
                while ((readAmount = this.in.read(array, readTotal, length - readTotal)) != -1 && (readTotal += readAmount) != length) {
                }
                if (readTotal != length) {
                    throw log.messageTruncated();
                }
                return array;
            }
            if (length == 0) {
                return EMPTY;
            }
            if (length < 0) {
                throw log.negativeLength();
            }
            throw log.messageTruncated();
        }

        @Override
        protected void skipRawBytes(int length) throws IOException {
            if (length <= this.limit - this.pos && length >= 0) {
                this.pos += length;
            } else {
                if (length < 0) {
                    throw log.negativeLength();
                }
                throw log.messageTruncated();
            }
            this.skipNBytes(length);
        }

        private void skipNBytes(long n) throws IOException {
            while (n > 0L) {
                long ns = this.in.skip(n);
                if (ns > 0L && ns <= n) {
                    n -= ns;
                    continue;
                }
                if (ns == 0L) {
                    if (this.in.read() == -1) {
                        throw log.messageTruncated();
                    }
                    --n;
                    continue;
                }
                throw new IOException("Unable to skip exactly");
            }
        }
    }

    private static final class ByteArrayDecoder
    extends Decoder {
        private final byte[] array;
        private final int start;
        private final int stop;
        private int pos;
        private int end;
        private int limit;

        private ByteArrayDecoder(byte[] array, int offset, int length) {
            if (array == null) {
                throw new IllegalArgumentException("array cannot be null");
            }
            if (offset < 0) {
                throw new IllegalArgumentException("offset cannot be negative");
            }
            if (length < 0) {
                throw new IllegalArgumentException("length cannot be negative");
            }
            if (offset > array.length) {
                throw new IllegalArgumentException("start position is outside array bounds");
            }
            if (offset + length > array.length) {
                throw new IllegalArgumentException("end position is outside array bounds");
            }
            this.array = array;
            this.start = this.pos = offset;
            this.limit = length;
            this.stop = this.end = offset + length;
            this.adjustEnd();
        }

        @Override
        int pushLimit(int limit) throws IOException {
            if (limit < 0) {
                throw log.negativeLength();
            }
            int oldLimit = this.limit;
            if ((limit += this.pos - this.start) > oldLimit) {
                throw log.messageTruncated();
            }
            this.limit = limit;
            this.adjustEnd();
            return oldLimit;
        }

        @Override
        void popLimit(int oldLimit) {
            this.limit = oldLimit;
            this.adjustEnd();
        }

        private void adjustEnd() {
            this.end = this.stop - this.start > this.limit ? this.start + this.limit : this.stop;
        }

        @Override
        int getEnd() {
            return this.end;
        }

        @Override
        int getPos() {
            return this.pos;
        }

        @Override
        byte[] getBufferArray(int offset) {
            this.pos = this.end;
            if (offset == 0 && this.end == this.limit) {
                return this.array;
            }
            return Arrays.copyOfRange(this.array, offset, this.end);
        }

        @Override
        boolean isAtEnd() {
            return this.pos == this.end;
        }

        @Override
        String readString() throws IOException {
            int length = this.readVarint32();
            if (length > 0 && length <= this.end - this.pos) {
                String value = new String(this.array, this.pos, length, UTF8);
                this.pos += length;
                return value;
            }
            if (length == 0) {
                return "";
            }
            if (length < 0) {
                throw log.negativeLength();
            }
            throw log.messageTruncated();
        }

        @Override
        ByteBuffer readRawByteBuffer(int length) throws IOException {
            if (length > 0 && length <= this.end - this.pos) {
                int from = this.pos;
                this.pos += length;
                return ByteBuffer.wrap(this.array, from, length).slice();
            }
            if (length == 0) {
                return EMPTY_BUFFER;
            }
            if (length < 0) {
                throw log.negativeLength();
            }
            throw log.messageTruncated();
        }

        @Override
        protected void skipVarint() throws IOException {
            if (this.end - this.pos >= 10) {
                for (int i = 0; i < 10; ++i) {
                    if (this.array[this.pos++] < 0) continue;
                    return;
                }
            } else {
                for (int i = 0; i < 10; ++i) {
                    if (this.readRawByte() < 0) continue;
                    return;
                }
            }
            throw log.malformedVarint();
        }

        @Override
        long readVarint64() throws IOException {
            long value = 0L;
            if (this.end - this.pos >= 10) {
                for (int i = 0; i < 64; i += 7) {
                    byte b = this.array[this.pos++];
                    value |= (long)(b & 0x7F) << i;
                    if (b < 0) continue;
                    return value;
                }
            } else {
                for (int i = 0; i < 64; i += 7) {
                    byte b = this.readRawByte();
                    value |= (long)(b & 0x7F) << i;
                    if (b < 0) continue;
                    return value;
                }
            }
            throw log.malformedVarint();
        }

        @Override
        int readFixed32() throws IOException {
            try {
                int value = VarHandlesUtil.INT.get(this.array, this.pos);
                this.pos += 4;
                return value;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw log.messageTruncated(e);
            }
        }

        @Override
        long readFixed64() throws IOException {
            try {
                long value = VarHandlesUtil.LONG.get(this.array, this.pos);
                this.pos += 8;
                return value;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw log.messageTruncated(e);
            }
        }

        @Override
        byte readRawByte() throws IOException {
            try {
                return this.array[this.pos++];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw log.messageTruncated(e);
            }
        }

        @Override
        byte[] readRawByteArray(int length) throws IOException {
            if (length > 0 && length <= this.end - this.pos) {
                int from = this.pos;
                this.pos += length;
                return Arrays.copyOfRange(this.array, from, this.pos);
            }
            if (length == 0) {
                return EMPTY;
            }
            if (length < 0) {
                throw log.negativeLength();
            }
            throw log.messageTruncated();
        }

        @Override
        protected void skipRawBytes(int length) throws IOException {
            if (length < 0) {
                throw log.negativeLength();
            }
            if (length <= this.end - this.pos) {
                this.pos += length;
                return;
            }
            throw log.messageTruncated();
        }

        @Override
        int setGlobalLimit(int globalLimit) {
            return Integer.MAX_VALUE;
        }
    }

    private static final class ByteBufferDecoder
    extends Decoder {
        private final ByteBuffer buf;
        private final int start;
        private final int stop;
        private int end;
        private int limit;

        private ByteBufferDecoder(ByteBuffer buf) {
            this.buf = buf;
            this.start = buf.position();
            this.limit = buf.remaining();
            this.stop = this.end = this.start + this.limit;
        }

        @Override
        int pushLimit(int limit) throws IOException {
            int oldLimit;
            if (limit < 0) {
                throw log.negativeLength();
            }
            if ((limit += this.buf.position() - this.start) > (oldLimit = this.limit)) {
                throw log.messageTruncated();
            }
            this.limit = limit;
            this.adjustEnd();
            return oldLimit;
        }

        @Override
        void popLimit(int oldLimit) {
            this.limit = oldLimit;
            this.adjustEnd();
        }

        private void adjustEnd() {
            this.end = this.stop - this.start > this.limit ? this.start + this.limit : this.stop;
        }

        @Override
        int getEnd() {
            return this.end;
        }

        @Override
        int getPos() {
            return this.buf.position() - this.start;
        }

        @Override
        byte[] getBufferArray(int offset) {
            byte[] array = this.buf.array();
            if (offset == 0) {
                return array;
            }
            return Arrays.copyOfRange(array, offset, array.length);
        }

        @Override
        boolean isAtEnd() {
            return this.buf.position() == this.end;
        }

        @Override
        String readString() throws IOException {
            int length = this.readVarint32();
            if (length > 0 && length <= this.end - this.buf.position()) {
                byte[] bytes = new byte[length];
                this.buf.get(bytes);
                return new String(bytes, 0, length, UTF8);
            }
            if (length == 0) {
                return "";
            }
            if (length < 0) {
                throw log.negativeLength();
            }
            throw log.messageTruncated();
        }

        @Override
        ByteBuffer readRawByteBuffer(int length) throws IOException {
            if (length > 0 && length <= this.end - this.buf.position()) {
                ByteBuffer byteBuffer = this.buf.slice().limit(length);
                this.buf.position(this.buf.position() + length);
                return byteBuffer;
            }
            if (length == 0) {
                return EMPTY_BUFFER;
            }
            if (length < 0) {
                throw log.negativeLength();
            }
            throw log.messageTruncated();
        }

        @Override
        protected void skipVarint() throws IOException {
            if (this.end - this.buf.position() >= 10) {
                for (int i = 0; i < 10; ++i) {
                    if (this.buf.get() < 0) continue;
                    return;
                }
            } else {
                for (int i = 0; i < 10; ++i) {
                    if (this.readRawByte() < 0) continue;
                    return;
                }
            }
            throw log.malformedVarint();
        }

        @Override
        long readVarint64() throws IOException {
            long value = 0L;
            if (this.end - this.buf.position() >= 10) {
                for (int i = 0; i < 64; i += 7) {
                    byte b = this.buf.get();
                    value |= (long)(b & 0x7F) << i;
                    if (b < 0) continue;
                    return value;
                }
            } else {
                for (int i = 0; i < 64; i += 7) {
                    byte b = this.readRawByte();
                    value |= (long)(b & 0x7F) << i;
                    if (b < 0) continue;
                    return value;
                }
            }
            throw log.malformedVarint();
        }

        @Override
        int readFixed32() throws IOException {
            try {
                return this.buf.getInt();
            }
            catch (BufferUnderflowException e) {
                throw log.messageTruncated(e);
            }
        }

        @Override
        long readFixed64() throws IOException {
            try {
                return this.buf.getLong();
            }
            catch (BufferUnderflowException e) {
                throw log.messageTruncated(e);
            }
        }

        @Override
        byte readRawByte() throws IOException {
            try {
                return this.buf.get();
            }
            catch (BufferUnderflowException e) {
                throw log.messageTruncated(e);
            }
        }

        @Override
        byte[] readRawByteArray(int length) throws IOException {
            if (length > 0 && length <= this.end - this.buf.position()) {
                byte[] bytes = new byte[length];
                this.buf.get(bytes);
                return bytes;
            }
            if (length == 0) {
                return EMPTY;
            }
            if (length < 0) {
                throw log.negativeLength();
            }
            throw log.messageTruncated();
        }

        @Override
        protected void skipRawBytes(int length) throws IOException {
            if (length < 0) {
                throw log.negativeLength();
            }
            if (length <= this.end - this.buf.position()) {
                this.buf.position(this.buf.position() + length);
                return;
            }
            throw log.messageTruncated();
        }

        @Override
        int setGlobalLimit(int globalLimit) {
            return Integer.MAX_VALUE;
        }
    }

    private static final class LimitedInputStreamDecoder
    extends Decoder {
        private final InputStream in;
        private final byte[] buffer;
        private final int fullLimit;
        private int bufferPos = 0;
        private int bufferSize = 0;
        private int pos;
        private int limit;

        private LimitedInputStreamDecoder(InputStream in, int length) {
            if (in == null) {
                throw new IllegalArgumentException("input stream cannot be null");
            }
            this.in = in;
            this.fullLimit = length;
            this.limit = length;
            this.buffer = new byte[Math.min(1024, length)];
        }

        private void ensureAvailable(int required) throws IOException {
            int bufferRemaining = this.bufferSize - this.bufferPos;
            if (bufferRemaining < required) {
                int bytesRead;
                byte[] buffer = this.buffer;
                if (bufferRemaining > 0) {
                    System.arraycopy(buffer, this.bufferPos, buffer, 0, bufferRemaining);
                }
                this.bufferPos = 0;
                for (int toRead = Math.min(buffer.length - bufferRemaining, this.fullLimit - (this.pos + bufferRemaining)); toRead > 0 && (bytesRead = this.in.read(buffer, bufferRemaining, toRead)) != -1; toRead -= bytesRead) {
                    bufferRemaining += bytesRead;
                }
                this.bufferSize = bufferRemaining;
            }
        }

        @Override
        String readString() throws IOException {
            int length = this.readVarint32();
            if (length > 0 && length <= this.limit - this.pos) {
                if (length > this.buffer.length) {
                    byte[] bytes = this.readRawByteArray(length);
                    return new String(bytes, 0, length, UTF8);
                }
                this.ensureAvailable(length);
                if (this.bufferPos + length > this.bufferSize) {
                    throw log.messageTruncated();
                }
                String s = new String(this.buffer, this.bufferPos, length, UTF8);
                this.bufferPos += length;
                this.pos += length;
                return s;
            }
            if (length == 0) {
                return "";
            }
            if (length < 0) {
                throw log.negativeLength();
            }
            throw log.messageTruncated();
        }

        @Override
        ByteBuffer readRawByteBuffer(int length) throws IOException {
            if (length == 0) {
                return EMPTY_BUFFER;
            }
            byte[] bytes = this.readRawByteArray(length);
            return ByteBuffer.wrap(bytes);
        }

        @Override
        protected void skipVarint() throws IOException {
            for (int i = 0; i < 10; ++i) {
                if (this.readRawByte() < 0) continue;
                return;
            }
            throw log.malformedVarint();
        }

        @Override
        long readVarint64() throws IOException {
            this.ensureAvailable(10);
            long value = 0L;
            int pos = this.pos;
            int bufferPos = this.bufferPos;
            for (int i = 0; i < 64; i += 7) {
                if (pos >= this.limit) {
                    throw log.messageTruncated();
                }
                if (bufferPos == this.bufferSize) {
                    throw log.messageTruncated();
                }
                ++pos;
                byte b = this.buffer[bufferPos++];
                value |= (long)(b & 0x7F) << i;
                if (b < 0) continue;
                this.pos = pos;
                this.bufferPos = bufferPos;
                return value;
            }
            throw log.malformedVarint();
        }

        @Override
        int readFixed32() throws IOException {
            if (this.limit - this.pos < 4) {
                throw log.messageTruncated();
            }
            this.ensureAvailable(4);
            int value = VarHandlesUtil.INT.get(this.buffer, this.bufferPos);
            this.bufferPos += 4;
            this.pos += 4;
            return value;
        }

        @Override
        long readFixed64() throws IOException {
            if (this.limit - this.pos < 8) {
                throw log.messageTruncated();
            }
            this.ensureAvailable(8);
            long value = VarHandlesUtil.LONG.get(this.buffer, this.bufferPos);
            this.bufferPos += 8;
            this.pos += 8;
            return value;
        }

        @Override
        int setGlobalLimit(int globalLimit) {
            if (globalLimit < 0) {
                throw new IllegalArgumentException("Global limit cannot be negative: " + globalLimit);
            }
            int oldGlobalLimit = this.globalLimit;
            this.globalLimit = globalLimit;
            return oldGlobalLimit;
        }

        @Override
        int pushLimit(int limit) throws IOException {
            if (limit < 0) {
                throw log.negativeLength();
            }
            int oldLimit = this.limit;
            if ((limit = this.pos + limit) > oldLimit) {
                throw log.messageTruncated();
            }
            this.limit = limit;
            return oldLimit;
        }

        @Override
        void popLimit(int oldLimit) {
            this.limit = oldLimit;
        }

        @Override
        int getEnd() {
            return this.limit;
        }

        @Override
        int getPos() {
            return this.pos;
        }

        @Override
        byte[] getBufferArray(int offset) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        boolean isAtEnd() {
            return this.pos == this.limit;
        }

        @Override
        byte readRawByte() throws IOException {
            if (this.pos >= this.limit) {
                throw log.messageTruncated();
            }
            this.ensureAvailable(1);
            if (this.bufferPos == this.bufferSize) {
                throw log.messageTruncated();
            }
            ++this.pos;
            return this.buffer[this.bufferPos++];
        }

        @Override
        byte[] readRawByteArray(int length) throws IOException {
            if (length > 0 && length <= this.limit - this.pos) {
                int read;
                byte[] array = new byte[length];
                int bytesRead = 0;
                int bufferRemaining = this.bufferSize - this.bufferPos;
                if (bufferRemaining > 0) {
                    int toCopy = Math.min(length, bufferRemaining);
                    System.arraycopy(this.buffer, this.bufferPos, array, 0, toCopy);
                    this.bufferPos += toCopy;
                    bytesRead += toCopy;
                }
                if (bytesRead < length && (read = this.in.readNBytes(array, bytesRead, length - bytesRead)) != length - bytesRead) {
                    throw log.messageTruncated();
                }
                this.pos += length;
                if (this.pos > this.globalLimit) {
                    throw log.globalLimitExceeded();
                }
                return array;
            }
            if (length == 0) {
                return EMPTY;
            }
            if (length < 0) {
                throw log.negativeLength();
            }
            throw log.messageTruncated();
        }

        @Override
        protected void skipRawBytes(int length) throws IOException {
            if (length <= this.limit - this.pos && length >= 0) {
                int bufferRemaining = this.bufferSize - this.bufferPos;
                if (length <= bufferRemaining) {
                    this.bufferPos += length;
                } else {
                    this.bufferPos = 0;
                    this.bufferSize = 0;
                    long toSkip = length - bufferRemaining;
                    try {
                        this.in.skipNBytes(toSkip);
                    }
                    catch (EOFException e) {
                        throw log.messageTruncated();
                    }
                }
                this.pos += length;
            } else {
                if (length < 0) {
                    throw log.negativeLength();
                }
                throw log.messageTruncated();
            }
        }
    }
}

