/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.impl.json;

import java.io.IOException;
import java.util.List;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.ProtobufParser;
import org.infinispan.protostream.TagHandler;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.impl.json.JsonToken;
import org.infinispan.protostream.impl.json.JsonTokenWriter;
import org.infinispan.protostream.impl.json.RootJsonWriter;

public final class JsonWriter {
    private JsonWriter() {
    }

    public static String toJson(ImmutableSerializationContext ctx, byte[] bytes, boolean pretty) throws IOException {
        Descriptor descriptor = ctx.getMessageDescriptor("org.infinispan.protostream.WrappedMessage");
        RootJsonWriter handler = new RootJsonWriter(ctx);
        ProtobufParser.INSTANCE.parse((TagHandler)handler, descriptor, bytes);
        return JsonWriter.astToString(handler.ast, pretty);
    }

    private static String astToString(List<JsonTokenWriter> ast, boolean pretty) {
        if (pretty) {
            return JsonWriter.astToPrettyString(ast);
        }
        StringBuilder out = new StringBuilder();
        for (JsonTokenWriter writer : ast) {
            writer.append(out);
        }
        return out.toString();
    }

    private static String astToPrettyString(List<JsonTokenWriter> ast) {
        StringBuilder out = new StringBuilder();
        int level = 0;
        JsonToken last = null;
        for (JsonTokenWriter writer : ast) {
            JsonToken token = writer.token();
            if (token.isEnd()) {
                --level;
                out.append(System.lineSeparator());
            }
            if ((token == JsonToken.STRING || token == JsonToken.VALUE || token.isEnd() || token == JsonToken.LEFT_BRACE) && last != JsonToken.COLON) {
                out.append(JsonWriter.indentation(level));
            }
            writer.append(out);
            if (token == JsonToken.COLON) {
                out.append(" ");
            }
            if (token.isOpen()) {
                ++level;
            }
            if (token.isOpen() || token == JsonToken.COMMA) {
                out.append(System.lineSeparator());
            }
            last = token;
        }
        return out.toString();
    }

    private static String indentation(int level) {
        return "   ".repeat(level);
    }
}

