/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.http;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.web.authentication.rememberme.JdbcTokenRepositoryImpl;
import org.springframework.security.web.authentication.rememberme.PersistentTokenBasedRememberMeServices;
import org.springframework.security.web.authentication.rememberme.RememberMeAuthenticationFilter;
import org.springframework.security.web.authentication.rememberme.TokenBasedRememberMeServices;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

class RememberMeBeanDefinitionParser
implements BeanDefinitionParser {
    static final String ATT_DATA_SOURCE = "data-source-ref";
    static final String ATT_SERVICES_REF = "services-ref";
    static final String ATT_SERVICES_ALIAS = "services-alias";
    static final String ATT_TOKEN_REPOSITORY = "token-repository-ref";
    static final String ATT_USER_SERVICE_REF = "user-service-ref";
    static final String ATT_SUCCESS_HANDLER_REF = "authentication-success-handler-ref";
    static final String ATT_TOKEN_VALIDITY = "token-validity-seconds";
    static final String ATT_SECURE_COOKIE = "use-secure-cookie";
    static final String ATT_FORM_REMEMBERME_PARAMETER = "remember-me-parameter";
    static final String ATT_REMEMBERME_COOKIE = "remember-me-cookie";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final String key;
    private final BeanReference authenticationManager;
    private final BeanMetadataElement authenticationFilterSecurityContextHolderStrategyRef;
    private String rememberMeServicesId;

    RememberMeBeanDefinitionParser(String key, BeanReference authenticationManager, BeanMetadataElement authenticationFilterSecurityContextHolderStrategyRef) {
        this.key = key;
        this.authenticationManager = authenticationManager;
        this.authenticationFilterSecurityContextHolderStrategyRef = authenticationFilterSecurityContextHolderStrategyRef;
    }

    public BeanDefinition parse(Element element, ParserContext pc) {
        String servicesName;
        boolean isPersistent;
        CompositeComponentDefinition compositeDef = new CompositeComponentDefinition(element.getTagName(), pc.extractSource((Object)element));
        pc.pushContainingComponent(compositeDef);
        String tokenRepository = element.getAttribute(ATT_TOKEN_REPOSITORY);
        String dataSource = element.getAttribute(ATT_DATA_SOURCE);
        String userServiceRef = element.getAttribute(ATT_USER_SERVICE_REF);
        String successHandlerRef = element.getAttribute(ATT_SUCCESS_HANDLER_REF);
        String rememberMeServicesRef = element.getAttribute(ATT_SERVICES_REF);
        String tokenValiditySeconds = element.getAttribute(ATT_TOKEN_VALIDITY);
        String useSecureCookie = element.getAttribute(ATT_SECURE_COOKIE);
        String remembermeParameter = element.getAttribute(ATT_FORM_REMEMBERME_PARAMETER);
        String remembermeCookie = element.getAttribute(ATT_REMEMBERME_COOKIE);
        Object source = pc.extractSource((Object)element);
        RootBeanDefinition services = null;
        boolean dataSourceSet = StringUtils.hasText((String)dataSource);
        boolean tokenRepoSet = StringUtils.hasText((String)tokenRepository);
        boolean servicesRefSet = StringUtils.hasText((String)rememberMeServicesRef);
        boolean userServiceSet = StringUtils.hasText((String)userServiceRef);
        boolean useSecureCookieSet = StringUtils.hasText((String)useSecureCookie);
        boolean tokenValiditySet = StringUtils.hasText((String)tokenValiditySeconds);
        boolean remembermeParameterSet = StringUtils.hasText((String)remembermeParameter);
        boolean remembermeCookieSet = StringUtils.hasText((String)remembermeCookie);
        if (servicesRefSet && (dataSourceSet || tokenRepoSet || userServiceSet || tokenValiditySet || useSecureCookieSet || remembermeParameterSet || remembermeCookieSet)) {
            pc.getReaderContext().error("services-ref can't be used in combination with attributes token-repository-ref,data-source-ref, user-service-ref, token-validity-seconds, use-secure-cookie, remember-me-parameter or remember-me-cookie", source);
        }
        if (dataSourceSet && tokenRepoSet) {
            pc.getReaderContext().error("Specify token-repository-ref or data-source-ref but not both", source);
        }
        if (isPersistent = dataSourceSet | tokenRepoSet) {
            RuntimeBeanReference tokenRepo;
            services = new RootBeanDefinition(PersistentTokenBasedRememberMeServices.class);
            if (tokenRepoSet) {
                tokenRepo = new RuntimeBeanReference(tokenRepository);
            } else {
                tokenRepo = new RootBeanDefinition(JdbcTokenRepositoryImpl.class);
                ((BeanDefinition)tokenRepo).getPropertyValues().addPropertyValue("dataSource", (Object)new RuntimeBeanReference(dataSource));
            }
            services.getConstructorArgumentValues().addIndexedArgumentValue(2, (Object)tokenRepo);
        } else if (!servicesRefSet) {
            services = new RootBeanDefinition(TokenBasedRememberMeServices.class);
        }
        if (services != null) {
            RootBeanDefinition uds = new RootBeanDefinition();
            uds.setFactoryBeanName("org.springframework.security.userDetailsServiceFactory");
            uds.setFactoryMethodName("cachingUserDetailsService");
            uds.getConstructorArgumentValues().addGenericArgumentValue((Object)userServiceRef);
            services.getConstructorArgumentValues().addGenericArgumentValue((Object)this.key);
            services.getConstructorArgumentValues().addGenericArgumentValue((Object)uds);
            if (useSecureCookieSet) {
                services.getPropertyValues().addPropertyValue("useSecureCookie", (Object)Boolean.valueOf(useSecureCookie));
            }
            if (tokenValiditySet) {
                boolean isTokenValidityNegative = tokenValiditySeconds.startsWith("-");
                if (isTokenValidityNegative && isPersistent) {
                    pc.getReaderContext().error("token-validity-seconds cannot be negative if using a persistent remember-me token repository", source);
                }
                services.getPropertyValues().addPropertyValue("tokenValiditySeconds", (Object)tokenValiditySeconds);
            }
            if (remembermeParameterSet) {
                services.getPropertyValues().addPropertyValue("parameter", (Object)remembermeParameter);
            }
            if (remembermeCookieSet) {
                services.getPropertyValues().addPropertyValue("cookieName", (Object)remembermeCookie);
            }
            services.setSource(source);
            servicesName = pc.getReaderContext().generateBeanName((BeanDefinition)services);
            pc.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)services, servicesName));
        } else {
            servicesName = rememberMeServicesRef;
        }
        if (StringUtils.hasText((String)element.getAttribute(ATT_SERVICES_ALIAS))) {
            pc.getRegistry().registerAlias(servicesName, element.getAttribute(ATT_SERVICES_ALIAS));
        }
        this.rememberMeServicesId = servicesName;
        BeanDefinitionBuilder filter = BeanDefinitionBuilder.rootBeanDefinition(RememberMeAuthenticationFilter.class);
        filter.getRawBeanDefinition().setSource(source);
        if (StringUtils.hasText((String)successHandlerRef)) {
            filter.addPropertyReference("authenticationSuccessHandler", successHandlerRef);
        }
        filter.addConstructorArgValue((Object)this.authenticationManager);
        filter.addConstructorArgReference(servicesName);
        filter.addPropertyValue("securityContextHolderStrategy", (Object)this.authenticationFilterSecurityContextHolderStrategyRef);
        pc.popAndRegisterContainingComponent();
        return filter.getBeanDefinition();
    }

    String getRememberMeServicesId() {
        return this.rememberMeServicesId;
    }
}

