/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.core.http.converter;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.GenericHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.security.oauth2.core.endpoint.OAuth2DeviceAuthorizationResponse;
import org.springframework.security.oauth2.core.http.converter.HttpMessageConverters;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class OAuth2DeviceAuthorizationResponseHttpMessageConverter
extends AbstractHttpMessageConverter<OAuth2DeviceAuthorizationResponse> {
    private static final ParameterizedTypeReference<Map<String, Object>> STRING_OBJECT_MAP = new ParameterizedTypeReference<Map<String, Object>>(){};
    private final GenericHttpMessageConverter<Object> jsonMessageConverter = HttpMessageConverters.getJsonMessageConverter();
    private Converter<Map<String, Object>, OAuth2DeviceAuthorizationResponse> deviceAuthorizationResponseConverter = new DefaultMapOAuth2DeviceAuthorizationResponseConverter();
    private Converter<OAuth2DeviceAuthorizationResponse, Map<String, Object>> deviceAuthorizationResponseParametersConverter = new DefaultOAuth2DeviceAuthorizationResponseMapConverter();

    protected boolean supports(Class<?> clazz) {
        return OAuth2DeviceAuthorizationResponse.class.isAssignableFrom(clazz);
    }

    protected OAuth2DeviceAuthorizationResponse readInternal(Class<? extends OAuth2DeviceAuthorizationResponse> clazz, HttpInputMessage inputMessage) throws HttpMessageNotReadableException {
        try {
            Map deviceAuthorizationResponseParameters = (Map)this.jsonMessageConverter.read(STRING_OBJECT_MAP.getType(), null, inputMessage);
            return (OAuth2DeviceAuthorizationResponse)this.deviceAuthorizationResponseConverter.convert((Object)deviceAuthorizationResponseParameters);
        }
        catch (Exception ex) {
            throw new HttpMessageNotReadableException("An error occurred reading the OAuth 2.0 Device Authorization Response: " + ex.getMessage(), (Throwable)ex, inputMessage);
        }
    }

    protected void writeInternal(OAuth2DeviceAuthorizationResponse deviceAuthorizationResponse, HttpOutputMessage outputMessage) throws HttpMessageNotWritableException {
        try {
            Map deviceAuthorizationResponseParameters = (Map)this.deviceAuthorizationResponseParametersConverter.convert((Object)deviceAuthorizationResponse);
            this.jsonMessageConverter.write((Object)deviceAuthorizationResponseParameters, STRING_OBJECT_MAP.getType(), MediaType.APPLICATION_JSON, outputMessage);
        }
        catch (Exception ex) {
            throw new HttpMessageNotWritableException("An error occurred writing the OAuth 2.0 Device Authorization Response: " + ex.getMessage(), (Throwable)ex);
        }
    }

    public final void setDeviceAuthorizationResponseConverter(Converter<Map<String, Object>, OAuth2DeviceAuthorizationResponse> deviceAuthorizationResponseConverter) {
        Assert.notNull(deviceAuthorizationResponseConverter, (String)"deviceAuthorizationResponseConverter cannot be null");
        this.deviceAuthorizationResponseConverter = deviceAuthorizationResponseConverter;
    }

    public final void setDeviceAuthorizationResponseParametersConverter(Converter<OAuth2DeviceAuthorizationResponse, Map<String, Object>> deviceAuthorizationResponseParametersConverter) {
        Assert.notNull(deviceAuthorizationResponseParametersConverter, (String)"deviceAuthorizationResponseParametersConverter cannot be null");
        this.deviceAuthorizationResponseParametersConverter = deviceAuthorizationResponseParametersConverter;
    }

    private static final class DefaultMapOAuth2DeviceAuthorizationResponseConverter
    implements Converter<Map<String, Object>, OAuth2DeviceAuthorizationResponse> {
        private static final Set<String> DEVICE_AUTHORIZATION_RESPONSE_PARAMETER_NAMES = new HashSet<String>(Arrays.asList("device_code", "user_code", "verification_uri", "verification_uri_complete", "expires_in", "interval"));

        private DefaultMapOAuth2DeviceAuthorizationResponseConverter() {
        }

        public OAuth2DeviceAuthorizationResponse convert(Map<String, Object> parameters) {
            String deviceCode = DefaultMapOAuth2DeviceAuthorizationResponseConverter.getParameterValue(parameters, "device_code");
            String userCode = DefaultMapOAuth2DeviceAuthorizationResponseConverter.getParameterValue(parameters, "user_code");
            String verificationUri = DefaultMapOAuth2DeviceAuthorizationResponseConverter.getParameterValue(parameters, "verification_uri");
            String verificationUriComplete = DefaultMapOAuth2DeviceAuthorizationResponseConverter.getParameterValue(parameters, "verification_uri_complete");
            long expiresIn = DefaultMapOAuth2DeviceAuthorizationResponseConverter.getParameterValue(parameters, "expires_in", 0L);
            long interval = DefaultMapOAuth2DeviceAuthorizationResponseConverter.getParameterValue(parameters, "interval", 0L);
            LinkedHashMap<String, Object> additionalParameters = new LinkedHashMap<String, Object>();
            parameters.forEach((key, value) -> {
                if (!DEVICE_AUTHORIZATION_RESPONSE_PARAMETER_NAMES.contains(key)) {
                    additionalParameters.put((String)key, value);
                }
            });
            return OAuth2DeviceAuthorizationResponse.with(deviceCode, userCode).verificationUri(verificationUri).verificationUriComplete(verificationUriComplete).expiresIn(expiresIn).interval(interval).additionalParameters(additionalParameters).build();
        }

        private static String getParameterValue(Map<String, Object> parameters, String parameterName) {
            Object obj = parameters.get(parameterName);
            return obj != null ? obj.toString() : null;
        }

        private static long getParameterValue(Map<String, Object> parameters, String parameterName, long defaultValue) {
            long parameterValue = defaultValue;
            Object obj = parameters.get(parameterName);
            if (obj != null) {
                if (obj.getClass() == Long.class) {
                    parameterValue = (Long)obj;
                } else if (obj.getClass() == Integer.class) {
                    parameterValue = ((Integer)obj).intValue();
                } else {
                    try {
                        parameterValue = Long.parseLong(obj.toString());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            return parameterValue;
        }
    }

    private static final class DefaultOAuth2DeviceAuthorizationResponseMapConverter
    implements Converter<OAuth2DeviceAuthorizationResponse, Map<String, Object>> {
        private DefaultOAuth2DeviceAuthorizationResponseMapConverter() {
        }

        public Map<String, Object> convert(OAuth2DeviceAuthorizationResponse deviceAuthorizationResponse) {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("device_code", deviceAuthorizationResponse.getDeviceCode().getTokenValue());
            parameters.put("user_code", deviceAuthorizationResponse.getUserCode().getTokenValue());
            parameters.put("verification_uri", deviceAuthorizationResponse.getVerificationUri());
            if (StringUtils.hasText((String)deviceAuthorizationResponse.getVerificationUriComplete())) {
                parameters.put("verification_uri_complete", deviceAuthorizationResponse.getVerificationUriComplete());
            }
            parameters.put("expires_in", DefaultOAuth2DeviceAuthorizationResponseMapConverter.getExpiresIn(deviceAuthorizationResponse));
            if (deviceAuthorizationResponse.getInterval() > 0L) {
                parameters.put("interval", deviceAuthorizationResponse.getInterval());
            }
            if (!CollectionUtils.isEmpty(deviceAuthorizationResponse.getAdditionalParameters())) {
                parameters.putAll(deviceAuthorizationResponse.getAdditionalParameters());
            }
            return parameters;
        }

        private static long getExpiresIn(OAuth2DeviceAuthorizationResponse deviceAuthorizationResponse) {
            if (deviceAuthorizationResponse.getDeviceCode().getExpiresAt() != null) {
                Instant issuedAt = deviceAuthorizationResponse.getDeviceCode().getIssuedAt() != null ? deviceAuthorizationResponse.getDeviceCode().getIssuedAt() : Instant.now();
                return ChronoUnit.SECONDS.between(issuedAt, deviceAuthorizationResponse.getDeviceCode().getExpiresAt());
            }
            return -1L;
        }
    }
}

