/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.read;

import java.util.Objects;
import org.infinispan.commands.DataCommand;
import org.infinispan.commands.SegmentSpecificCommand;
import org.infinispan.commons.util.EnumUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.context.Flag;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.marshall.protostream.impl.MarshallableObject;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.remoting.transport.Address;
import org.infinispan.telemetry.InfinispanSpanAttributes;
import org.infinispan.util.ByteString;

public abstract class AbstractDataCommand
implements DataCommand,
SegmentSpecificCommand {
    protected final ByteString cacheName;
    protected Address origin;
    protected Object key;
    private long flags;
    protected int topologyId = -1;
    protected int segment;
    protected InfinispanSpanAttributes spanAttributes;

    protected AbstractDataCommand(ByteString cacheName, MarshallableObject<?> wrappedKey, long flagsWithoutRemote, int topologyId, int segment) {
        this(cacheName, MarshallableObject.unwrap(wrappedKey), segment, flagsWithoutRemote);
        this.topologyId = topologyId;
    }

    protected AbstractDataCommand(ByteString cacheName, Object key, int segment, long flagsBitSet) {
        this.cacheName = cacheName;
        this.key = key;
        if (segment < 0) {
            throw new IllegalArgumentException("Segment must be 0 or greater");
        }
        this.segment = segment;
        this.flags = flagsBitSet;
    }

    @Override
    @ProtoField(value=1)
    public ByteString getCacheName() {
        return this.cacheName;
    }

    @ProtoField(number=2, name="key")
    public MarshallableObject<?> getWrappedKey() {
        return MarshallableObject.create(this.key);
    }

    @Override
    @ProtoField(value=3)
    public int getSegment() {
        return this.segment;
    }

    @Override
    @ProtoField(value=4)
    public int getTopologyId() {
        return this.topologyId;
    }

    @Override
    public void setTopologyId(int topologyId) {
        this.topologyId = topologyId;
    }

    @ProtoField(number=5, name="flags")
    public long getFlagsWithoutRemote() {
        return FlagBitSets.copyWithoutRemotableFlags(this.getFlagsBitSet());
    }

    @Override
    public long getFlagsBitSet() {
        return this.flags;
    }

    @Override
    public void setFlagsBitSet(long bitSet) {
        this.flags = bitSet;
    }

    @Override
    public Address getOrigin() {
        return this.origin;
    }

    @Override
    public void setOrigin(Address origin) {
        this.origin = origin;
    }

    @Override
    public Object getKey() {
        return this.key;
    }

    public void setKey(Object key) {
        this.key = key;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractDataCommand other = (AbstractDataCommand)obj;
        return this.flags == other.flags && Objects.equals(this.key, other.key);
    }

    public int hashCode() {
        return this.key != null ? this.key.hashCode() : 0;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " {key=" + Util.toStr((Object)this.key) + ", flags=" + this.printFlags() + "}";
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    protected final String printFlags() {
        return EnumUtil.prettyPrintBitSet((long)this.flags, Flag.class);
    }

    @Override
    public void setSpanAttributes(InfinispanSpanAttributes attributes) {
        this.spanAttributes = attributes;
    }

    @Override
    public InfinispanSpanAttributes getSpanAttributes() {
        return this.spanAttributes;
    }
}

