/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.remote.recovery;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.tx.XidImpl;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.transport.NodeVersion;
import org.infinispan.transaction.xa.recovery.RecoveryManager;
import org.infinispan.util.ByteString;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@ProtoTypeId(value=1082)
public class GetInDoubtTransactionsCommand
extends BaseRpcCommand {
    private static final Log log = LogFactory.getLog(GetInDoubtTransactionsCommand.class);

    @ProtoFactory
    public GetInDoubtTransactionsCommand(ByteString cacheName) {
        super(cacheName);
    }

    @Override
    public CompletionStage<?> invokeAsync(ComponentRegistry componentRegistry) throws Throwable {
        RecoveryManager recoveryManager = componentRegistry.getRecoveryManager().running();
        List<XidImpl> localInDoubtTransactions = recoveryManager.getInDoubtTransactions();
        log.tracef("Returning result %s", localInDoubtTransactions);
        return CompletableFuture.completedFuture(localInDoubtTransactions);
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public NodeVersion supportedSince() {
        return NodeVersion.SIXTEEN;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " { cacheName = " + String.valueOf(this.cacheName) + "}";
    }
}

