/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.versioning;

import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.IncrementableEntryVersion;
import org.infinispan.container.versioning.InequalVersionComparisonResult;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=8)
public class NumericVersion
implements IncrementableEntryVersion {
    private final long version;

    @ProtoFactory
    public NumericVersion(long version) {
        this.version = version;
    }

    @ProtoField(number=1, defaultValue="-1")
    public long getVersion() {
        return this.version;
    }

    @Override
    public InequalVersionComparisonResult compareTo(EntryVersion other) {
        if (other instanceof NumericVersion) {
            NumericVersion otherVersion = (NumericVersion)other;
            if (this.version < otherVersion.version) {
                return InequalVersionComparisonResult.BEFORE;
            }
            if (this.version > otherVersion.version) {
                return InequalVersionComparisonResult.AFTER;
            }
            return InequalVersionComparisonResult.EQUAL;
        }
        throw new IllegalArgumentException("Unable to compare other types: " + other.getClass().getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NumericVersion that = (NumericVersion)o;
        return this.version == that.version;
    }

    public int hashCode() {
        return (int)(this.version ^ this.version >>> 32);
    }

    public String toString() {
        return "NumericVersion{version=" + this.version + "}";
    }
}

