/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Supplier;
import org.jgroups.Address;
import org.jgroups.BytesMessage;
import org.jgroups.EmptyMessage;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.conf.AttributeType;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.StateTransferInfo;
import org.jgroups.util.Digest;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.ProcessingQueue;
import org.jgroups.util.ShutdownRejectedExecutionHandler;
import org.jgroups.util.StateTransferResult;
import org.jgroups.util.Tuple;
import org.jgroups.util.Util;

@MBean(description="Streaming state transfer protocol base class")
public abstract class StreamingStateTransfer
extends Protocol
implements ProcessingQueue.Handler<Address> {
    @Property(description="Size (in bytes) of the state transfer buffer", type=AttributeType.BYTES)
    protected int buffer_size = 8192;
    @Property(description="Maximum number of pool threads serving state requests")
    protected int max_pool = 5;
    @Property(description="Keep alive for pool threads serving state requests", type=AttributeType.TIME)
    protected long pool_thread_keep_alive = 20000L;
    protected final LongAdder num_state_reqs = new LongAdder();
    protected final LongAdder num_bytes_sent = new LongAdder();
    protected double avg_state_size;
    protected volatile Address state_provider;
    protected final List<Address> members = new ArrayList<Address>();
    protected ThreadPoolExecutor thread_pool;
    protected final ProcessingQueue<Address> state_requesters = new ProcessingQueue<Address>().setHandler(this);

    @ManagedAttribute
    public long getNumberOfStateRequests() {
        return this.num_state_reqs.sum();
    }

    @ManagedAttribute(type=AttributeType.BYTES)
    public long getNumberOfStateBytesSent() {
        return this.num_bytes_sent.sum();
    }

    @ManagedAttribute(type=AttributeType.BYTES)
    public double getAverageStateSize() {
        return this.avg_state_size;
    }

    @ManagedAttribute
    public int getThreadPoolSize() {
        return this.thread_pool.getPoolSize();
    }

    @ManagedAttribute
    public long getThreadPoolCompletedTasks() {
        return this.thread_pool.getCompletedTaskCount();
    }

    @Override
    public List<Integer> requiredDownServices() {
        ArrayList<Integer> retval = new ArrayList<Integer>(2);
        retval.add(39);
        retval.add(42);
        return retval;
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.num_state_reqs.reset();
        this.num_bytes_sent.reset();
        this.avg_state_size = 0.0;
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.thread_pool = this.createThreadPool();
    }

    @Override
    public void destroy() {
        if (this.thread_pool != null) {
            this.thread_pool.shutdown();
        }
        super.destroy();
    }

    @Override
    public void start() throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("state_transfer", true);
        map.put("protocol_class", this.getClass().getName());
        this.up_prot.up(new Event(56, map));
        if (this.buffer_size <= 0) {
            throw new IllegalArgumentException("buffer_size has to be > 0");
        }
    }

    @Override
    public void stop() {
        super.stop();
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 6: {
                this.handleViewChange((View)evt.getArg());
                break;
            }
            case 19: {
                StateTransferInfo info = (StateTransferInfo)evt.getArg();
                Address target = info.target;
                if (Objects.equals(target, this.local_addr)) {
                    this.log.error("%s: cannot fetch state from myself", this.local_addr);
                    target = null;
                }
                if (target == null) {
                    target = this.determineCoordinator();
                }
                if (target == null) {
                    this.log.debug("%s: first member (no state)", this.local_addr);
                    this.up_prot.up(new Event(73, new StateTransferResult()));
                } else {
                    this.state_provider = target;
                    Message state_req = new EmptyMessage(target).putHeader(this.id, new StateHeader(1)).setFlag(Message.Flag.SKIP_BARRIER, Message.Flag.DONT_BUNDLE, Message.Flag.OOB);
                    this.log.debug("%s: asking %s for state", this.local_addr, target);
                    this.down_prot.down(state_req);
                }
                return null;
            }
            case 56: {
                this.handleConfig((Map)evt.getArg());
            }
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 6: 
            case 15: {
                this.handleViewChange((View)evt.getArg());
                break;
            }
            case 56: {
                this.handleConfig((Map)evt.getArg());
            }
        }
        return this.up_prot.up(evt);
    }

    @Override
    public Object up(Message msg) {
        StateHeader hdr = (StateHeader)msg.getHeader(this.id);
        if (hdr != null) {
            return this.handle(hdr, msg);
        }
        return this.up_prot.up(msg);
    }

    @Override
    public void up(MessageBatch batch) {
        Iterator<Message> it = batch.iterator();
        while (it.hasNext()) {
            Message msg = it.next();
            StateHeader hdr = (StateHeader)msg.getHeader(this.id);
            if (hdr == null) continue;
            it.remove();
            this.handle(hdr, msg);
        }
        if (!batch.isEmpty()) {
            this.up_prot.up(batch);
        }
    }

    protected Object handle(StateHeader hdr, Message msg) {
        Address sender = msg.getSrc();
        switch (hdr.type) {
            case 1: {
                this.state_requesters.add(msg.getSrc());
                break;
            }
            case 2: {
                this.handleStateRsp(sender, hdr);
                break;
            }
            case 3: {
                this.handleStateChunk(sender, msg.getArray(), msg.getOffset(), msg.getLength());
                break;
            }
            case 4: {
                this.log.trace("%s <-- EOF <-- %s", this.local_addr, sender);
                this.handleEOF(sender);
                break;
            }
            case 5: {
                try {
                    this.handleException(Util.exceptionFromBuffer(msg.getArray(), msg.getOffset(), msg.getLength()));
                }
                catch (Throwable t) {
                    this.log.error("failed deserializaing state exception", t);
                }
                break;
            }
            default: {
                this.log.error("%s: type %d not known in StateHeader", this.local_addr, hdr.type);
            }
        }
        return null;
    }

    protected void handleConfig(Map<String, Object> config) {
        if (config != null && config.containsKey("state_transfer")) {
            throw new IllegalArgumentException("Protocol stack must have only one state transfer protocol");
        }
    }

    protected void handleStateChunk(Address sender, byte[] buffer, int offset, int length) {
    }

    protected void handleEOF(Address sender) {
        this.state_provider = null;
        this.down_prot.down(new Event(108));
    }

    protected void handleException(Throwable exception) {
        this.state_provider = null;
        this.up_prot.up(new Event(73, new StateTransferResult(exception)));
    }

    protected void getStateFromApplication(Address requester, OutputStream out, boolean use_separate_thread) {
        if (out == null || requester == null) {
            throw new IllegalArgumentException("output stream and requester's address have to be non-null");
        }
        StateGetter state_getter = new StateGetter(requester, out);
        if (use_separate_thread) {
            this.thread_pool.execute(state_getter);
        } else {
            state_getter.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setStateInApplication(InputStream in, Object resource, Address provider) {
        this.log.debug("%s: setting the state in the aplication", this.local_addr);
        try {
            this.up_prot.up(new Event(71, in));
            this.up_prot.up(new Event(73, new StateTransferResult()));
            this.down_prot.down(new Event(108));
        }
        catch (Throwable t) {
            this.handleException(t);
        }
        finally {
            Util.close((Closeable)in);
            this.close(resource);
            this.openBarrierAndResumeStable();
            this.closeHoleFor(provider);
        }
    }

    @ManagedOperation(description="Closes BARRIER and suspends STABLE")
    public void closeBarrierAndSuspendStable() {
        this.log.trace("%s: sending down CLOSE_BARRIER and SUSPEND_STABLE", this.local_addr);
        this.down_prot.down(new Event(76));
        this.down_prot.down(new Event(65));
    }

    @ManagedOperation(description="Opens BARRIER and resumes STABLE")
    public void openBarrierAndResumeStable() {
        this.log.trace("%s: sending down OPEN_BARRIER and RESUME_STABLE", this.local_addr);
        this.openBarrier();
        this.resumeStable();
    }

    protected void openBarrier() {
        this.down_prot.down(new Event(77));
    }

    protected void resumeStable() {
        this.down_prot.down(new Event(66));
    }

    protected void sendEof(Address requester) {
        try {
            Message eof_msg = new EmptyMessage(requester).putHeader(this.getId(), new StateHeader(4));
            this.log.trace("%s --> EOF --> %s", this.local_addr, requester);
            this.down(eof_msg);
        }
        catch (Throwable t) {
            this.log.error("%s: failed sending EOF to %s", this.local_addr, requester);
        }
    }

    protected void sendException(Address requester, Throwable exception) {
        try {
            Message ex_msg = new BytesMessage(requester).setArray(Util.exceptionToBuffer(exception)).putHeader(this.getId(), new StateHeader(5));
            this.down(ex_msg);
        }
        catch (Throwable t) {
            this.log.error("%s: failed sending exception %s to %s", this.local_addr, exception.toString(), requester);
        }
    }

    protected ThreadPoolExecutor createThreadPool() {
        ThreadPoolExecutor threadPool = new ThreadPoolExecutor(0, this.max_pool, this.pool_thread_keep_alive, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>());
        ThreadFactory factory = new ThreadFactory(){
            private final AtomicInteger thread_id = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable command) {
                return StreamingStateTransfer.this.getThreadFactory().newThread(command, "StreamingStateTransfer-sender-" + this.thread_id.getAndIncrement());
            }
        };
        threadPool.setRejectedExecutionHandler(new ShutdownRejectedExecutionHandler(threadPool.getRejectedExecutionHandler()));
        threadPool.setThreadFactory(factory);
        return threadPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Address determineCoordinator() {
        List<Address> list = this.members;
        synchronized (list) {
            for (Address member : this.members) {
                if (this.local_addr.equals(member)) continue;
                return member;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleViewChange(View v) {
        List<Address> new_members = v.getMembers();
        List<Address> list = this.members;
        synchronized (list) {
            this.members.clear();
            this.members.addAll(new_members);
        }
        this.state_requesters.retainAll(new_members);
    }

    @Override
    public void handle(Address state_requester) throws Exception {
        this.handleStateReq(state_requester);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleStateReq(Address requester) throws Exception {
        if (requester == null) {
            return;
        }
        this.log.debug("%s: received state request from %s", this.local_addr, requester);
        Digest digest = null;
        try {
            this.punchHoleFor(requester);
            this.closeBarrierAndSuspendStable();
            digest = (Digest)this.down_prot.down(Event.GET_DIGEST_EVT);
        }
        catch (Throwable t) {
            this.sendException(requester, t);
            this.resumeStable();
            this.closeHoleFor(requester);
            return;
        }
        finally {
            this.openBarrier();
        }
        StateHeader hdr = new StateHeader(2, null, digest);
        this.modifyStateResponseHeader(hdr);
        Message state_rsp = new EmptyMessage(requester).putHeader(this.id, hdr);
        this.log.debug("%s: responding to state requester %s", this.local_addr, requester);
        this.down_prot.down(state_rsp);
        if (this.stats) {
            this.num_state_reqs.increment();
        }
        try {
            this.createStreamToRequester(requester);
        }
        catch (Throwable t) {
            this.sendException(requester, t);
        }
    }

    protected void createStreamToRequester(Address requester) {
    }

    protected abstract Tuple<InputStream, Object> createStreamToProvider(Address var1, StateHeader var2) throws Exception;

    protected void close(Object resource) {
    }

    protected boolean useAsyncStateDelivery() {
        return false;
    }

    protected void modifyStateResponseHeader(StateHeader hdr) {
    }

    protected void handleStateRsp(Address provider, StateHeader hdr) {
        try {
            this.punchHoleFor(provider);
            this.closeBarrierAndSuspendStable();
            this.down_prot.down(new Event(42, hdr.getDigest()));
        }
        catch (Throwable t) {
            this.handleException(t);
            this.openBarrierAndResumeStable();
            this.closeHoleFor(provider);
            return;
        }
        InputStream in = null;
        Object resource = null;
        try {
            Tuple<InputStream, Object> tuple = this.createStreamToProvider(provider, hdr);
            in = tuple.val1();
            resource = tuple.val2();
        }
        catch (Throwable t) {
            this.handleException(t);
            Util.close(in);
            this.close(resource);
            this.openBarrierAndResumeStable();
            this.closeHoleFor(provider);
            return;
        }
        if (this.useAsyncStateDelivery()) {
            InputStream input = in;
            Object res = resource;
            Thread t = this.getThreadFactory().newThread(() -> this.setStateInApplication(input, res, provider), "STATE state reader");
            t.start();
        } else {
            this.setStateInApplication(in, resource, provider);
        }
    }

    protected void punchHoleFor(Address member) {
        this.down_prot.down(new Event(106, member));
    }

    protected void closeHoleFor(Address member) {
        this.down_prot.down(new Event(107, member));
    }

    public static class StateHeader
    extends Header {
        public static final byte STATE_REQ = 1;
        public static final byte STATE_RSP = 2;
        public static final byte STATE_PART = 3;
        public static final byte STATE_EOF = 4;
        public static final byte STATE_EX = 5;
        protected byte type = 0;
        protected Digest digest;
        protected IpAddress bind_addr;

        public StateHeader() {
        }

        public StateHeader(byte type) {
            this.type = type;
        }

        public StateHeader(byte type, Digest digest) {
            this.type = type;
            this.digest = digest;
        }

        public StateHeader(byte type, IpAddress bind_addr, Digest digest) {
            this.type = type;
            this.digest = digest;
            this.bind_addr = bind_addr;
        }

        @Override
        public short getMagicId() {
            return 65;
        }

        @Override
        public Supplier<? extends Header> create() {
            return StateHeader::new;
        }

        public int getType() {
            return this.type;
        }

        public Digest getDigest() {
            return this.digest;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("type=").append(StateHeader.type2Str(this.type));
            if (this.digest != null) {
                sb.append(", digest=").append(this.digest);
            }
            if (this.bind_addr != null) {
                sb.append(", bind_addr=" + String.valueOf(this.bind_addr));
            }
            return sb.toString();
        }

        static String type2Str(int t) {
            switch (t) {
                case 1: {
                    return "STATE_REQ";
                }
                case 2: {
                    return "STATE_RSP";
                }
                case 3: {
                    return "STATE_PART";
                }
                case 4: {
                    return "STATE_EOF";
                }
                case 5: {
                    return "STATE_EX";
                }
            }
            return "<unknown>";
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            out.writeByte(this.type);
            Util.writeStreamable(this.digest, out);
            Util.writeStreamable(this.bind_addr, out);
        }

        @Override
        public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
            this.type = in.readByte();
            this.digest = Util.readStreamable(Digest::new, in);
            this.bind_addr = Util.readStreamable(IpAddress::new, in);
        }

        @Override
        public int serializedSize() {
            int retval = 1;
            ++retval;
            if (this.digest != null) {
                retval += this.digest.serializedSize(true);
            }
            return retval += Util.size(this.bind_addr);
        }
    }

    protected class StateGetter
    implements Runnable {
        protected final Address requester;
        protected final OutputStream output;

        public StateGetter(Address requester, OutputStream output) {
            this.requester = requester;
            this.output = output;
        }

        @Override
        public void run() {
            try {
                StreamingStateTransfer.this.log.debug("%s: getting the state from the application", StreamingStateTransfer.this.local_addr);
                StreamingStateTransfer.this.up_prot.up(new Event(72, this.output));
                this.output.flush();
                StreamingStateTransfer.this.sendEof(this.requester);
            }
            catch (Throwable e) {
                StreamingStateTransfer.this.sendException(this.requester, e);
            }
            finally {
                StreamingStateTransfer.this.resumeStable();
                StreamingStateTransfer.this.closeHoleFor(this.requester);
            }
        }
    }
}

